/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef CHANGEPASSWD_H
#define CHANGEPASSWD_H

#include <QWidget>
#include <QDialog>
#include <QDebug>
#include <QStackedWidget>
#include <QPainter>
#include <QPainterPath>
#include "QGSettings/QGSettings"
#include "digitalauthdialog.h"
#include "phoneauthdialog.h"
#include "changepwddialog.h"
#define UKUI_QT_STYLE                      "org.ukui.style"
#define UKUI_STYLE_KEY                     "style-name"

class QLabel;
class QPushButton;


class changepasswd : public QDialog
{
    Q_OBJECT
public:
    explicit changepasswd(QString username, QWidget *parent = nullptr);
    ~changepasswd();

    void initUI(QString username);
    void setQSS();

Q_SIGNALS:
    void newpdSignal();
    void changepwd();

protected:
    void paintEvent(QPaintEvent *event) override;

private:
    QLabel *title_label;
    QPushButton *closeBtn;
    QStackedWidget  *m_pStackedWidget;
    DigitalAuthDialog *m_pdigitalAuthWidget;
    PhoneAuthDialog *m_pPhoneAuthWidget;
    ChangePwdDialog *m_pChangePwdDialog;
    QGSettings  *m_style = nullptr;
private slots:
    void setpwdstyle(QString key);
};

#endif // CHANGEPASSWD_H
