/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.uima.util;

import org.xml.sax.ContentHandler;

/**
 * Deserializes an {@link XMLizable} object from SAX events. This interface extends the SAX
 * {@link ContentHandler} interface and through this interface can receive events generated by a SAX
 * parser. When the parse has completed, the {@link #getObject()} method may be called to retrieve
 * the {@link XMLizable} object.
 * 
 * 
 */
public interface SaxDeserializer extends ContentHandler {

  /**
   * Retrieves the {@link XMLizable} object that has been built from the SAX events this object has
   * already received. Once this method is called, all state is cleared from this object and it is
   * ready to deserialize another object.
   * 
   * @return the deserialized object
   * 
   * @throws InvalidXMLException
   *           if an object could not be constructed
   */
  public XMLizable getObject() throws InvalidXMLException;
}
