#!/bin/sh

set -x

# Establish our temporary working directory
tmpdir=$(mktemp -d)

# Login and get the transport_url and userid
curl -s -o $tmpdir/1 -X POST https://home.nest.com/user/login --data @${HOME}/.uhome/nest_username --data @${HOME}/.uhome/nest_password
cat $tmpdir/1 | python -m json.tool

transport_url=$(cat $tmpdir/1 | sed -e "s/.*\"transport_url\":\"//" -e "s/\".*//")
userid=$(cat $tmpdir/1 | sed -e "s/.*\"userid\":\"//" -e "s/\".*//")
access_token=$(cat $tmpdir/1 | sed -e "s/expires_in.*//" -e "s/.*\"access_token\":\"//" -e "s/\".*//")
printf "auth=%s" > $tmpdir/auth

# Get the structure id

curl -v -o $tmpdir/2 -G -H "Authorization: Basic $access_token" -H "X-nl-user-id: $userid" -H "X-nl-protocol-version: 1" -A "Nest/2.1.3 CFNetwork/548.0.4" $transport_url/v3/mobile/user.$userid
cat $tmpdir/2 | json
structure_id=$(cat $tmpdir/2 | sed -e "s/.*\"structure_id\":\"//" -e "s/\".*//")
currently_away
