C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE XMFLUI
C                       *****************
C
C      -------------------------------------------------------------
     * (NDIM,NPOINF,NBCOUF,NELEBF,NELESF,NDMASF,NODEBF,NREFF,NODESF,
     *  NELRAF,NODRAF,
     *  NBFILS,NWMAIL,NWDE,NWDRE,NWDMA1)
C      -------------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------   GENERATION AUTOMATIQUE DU MAILLAGE ELEMENTS FINIS       *
C              DE LA PEAU DU MAILLAGE FLUIDE                           *
C              (PRISE EN COMPTE DES NOEUDS COUPLES D'UNE PART          *
C               ET DES NOEUDS NON COUPLES MAIS SOUMIS AU RAYONNEMENT)  *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   ! NDIM   !   E  ! D  ! DIMENSION DU PROBLEME                       !
C   ! NPOINF !   E  ! D  ! NOMBRE DE NOEUDS DU MAILLAGE VOL FLUIDE     !
C   ! NBCOUF !   E  ! D  ! NOMBRE DE NOEUDS FLUIDES COUPLES            !
C   ! NELEBF !   E  ! D  ! NOMBRE D'ELTS DU MAILLAGE SURF FLUIDE       !
C   ! NELESF !   E  ! D  ! NOMBRE D'ELTS DU MAILLAGE SURF FLUIDE COUPLE!
C   ! NDMASF !   E  ! D  ! NOMBRE DE NOEUDS DES ELTS SURF FLUIDE       !
C   ! NODEBF !  TE  ! D  ! TABLE DES ELTS SURF FLUIDE                  !
C   ! NREFF  !  TE  ! D  ! REFERENCE DES NOEUDS VOL FLUIDES            !
C   ! NODESF !  TE  ! R  ! TABLE DES ELTS SURF FLUIDE COUPLES          !
C   ! NELRAF !   E  ! D  ! NBRE D'ELTS SURF FLUIDES NON COUPLES + RAYT !
C   ! NODRAF !  TE  ! R  ! TABLE DES ELTS SURF NON COUPLES + RAYT      !
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !/XREFER/!      ! D  !                                             !
C   !/NLOFES/!      ! D  !                                             !
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : INISOL
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON
C**********************************************************************
C
#include "xrefer.h"
#include "nlofes.h"
#include "optct.h"
C
C**********************************************************************
C
      INTEGER NDX
      PARAMETER (NDX = 6)
C
C
C.. Variables externes
      INTEGER NDIM,NPOINF,NBCOUF,NELEBF,NELESF,NDMASF,NELRAF
      INTEGER NODESF(NELESF,NDMASF), NODEBF(NELEBF,NDMASF)
      INTEGER NREFF(NPOINF),NODRAF(NELRAF,NDMASF)
      INTEGER NBFILS,NWMAIL,NWDE,NWDRE,NWDMA1
C
C.. Variables internes
      INTEGER N,M,N1
      INTEGER NE,NY
      LOGICAL LCOUPL,LRAYT,LC(NDX),LY(NDX),ERR
      INTEGER NR(NDX)
C
C
C**********************************************************************
C
C
C     1- INITIALISATIONS
C     ==================
C
      IF (NWMAIL.EQ.1) THEN
        DO 11 N=1,NELESF*NDMASF
         NODESF(N,1) = 0
   11   CONTINUE
C
        DO 12 N=1,NELRAF*NDMASF
         NODRAF(N,1) = 0
   12   CONTINUE
      ENDIF
C
C
C     2- TABLE DES ELEMENTS FLUIDES COUPLES
C     =====================================
C
      NE = NWDE-1
      NY = NWDRE-1
C
      DO 200 N=1,NELEBF
C
        DO 201 M = 1,NWDMA1
          NR(M) = NREFF(NODEBF(N,M))
  201   CONTINUE
C
        DO 202 M=1,NWDMA1
          LC(M) = .FALSE.
          LY(M) = .FALSE.
  202   CONTINUE
C
        DO 205 M=1,NWDMA1
          DO 207 N1=1,NRFMAX
            IF (IREFFC(N1).NE.0 .AND. NR(M).EQ.N1) LC(M) = .TRUE. 
            IF (IREFRF(N1).NE.0 .AND. NR(M).EQ.N1) LY(M) = .TRUE. 
  207     CONTINUE
  205   CONTINUE
C
        LCOUPL = .TRUE.
        DO 208 M=1,NWDMA1
          LCOUPL = LCOUPL .AND. LC(M) 
  208   CONTINUE
C
        LRAYT = .TRUE.
        DO 209 M=1,NWDMA1
          LRAYT = LRAYT .AND. LY(M) 
  209   CONTINUE
C
CIR fin
        IF (LCOUPL) THEN
          NE = NE + 1
          DO 215 M=1,NWDMA1
            NODESF(NE,M) = NODEBF(N,M)
  215     CONTINUE
        ENDIF
C
        IF (LRAYT) THEN
          NY = NY + 1
          DO 216 M=1,NWDMA1
            NODRAF(NY,M) = NODEBF(N,M)
  216     CONTINUE
        ENDIF
C 
  200 CONTINUE
C
C
C     3- CONTROLE DES DEBORDEMENTS DE TABLEAU
C     =======================================
C
      ERR = .FALSE.
C
      IF (NWMAIL.EQ.NBFILS .AND. NE.NE.NELESF) THEN
        WRITE(NFECRA,3000) NELESF,NE
        ERR = .TRUE.
      ENDIF
      IF (NWMAIL.EQ.NBFILS .AND. NY.NE.NELRAF) THEN
        WRITE(NFECRA,3010) NELRAF,NY
        ERR = .TRUE.
      ENDIF
C
      IF (ERR) STOP
C
C
C     4- IMPRESSIONS DE CONTROLE
C     ==========================
C
      IF (NBLBLA.GT.0) WRITE(NFECRA,4000) NWMAIL,NE-NWDE+1,NY-NWDRE+1
C
      IF (NBLBLA.EQ.11) THEN
         WRITE(NFECRA,4100)
         DO 400 N=NWDE,NE-NWDE+1
            WRITE(NFECRA,4200) N,(NODESF(N,M),M=1,NWDMA1)
  400    CONTINUE
         WRITE(NFECRA,4300)
         DO 410 N=NWDRE,NY-NWDRE+1
            WRITE(NFECRA,4400) N,(NODRAF(N,M),M=1,NWDMA1)
  410    CONTINUE
C
      ENDIF        
C
C-------
C FORMAT
C-------
C
 3000 FORMAT(/,' %% ERREUR XMFLUI : LE TABLEAU DU MAILLAGE DE BORD',
     &         ' FLUIDE COUPLE EST MAL DIMENSIONNEE',/,
     &         '      - SA TAILLE EST DE  : ',I9,/,
     &         '      - XMFLUI EN DEMANDE : ',I9)
 3010 FORMAT(/,' %% ERREUR XMFLUI : LE TABLEAU DU MAILLAGE DE BORD',
     &         ' RAYONNEMENT FLUIDE EST MAL DIMENSIONNEE',/,
     &         '      - SA TAILLE EST DE  : ',I9,/,
     &         '      - XMFLUI EN DEMANDE : ',I9)
 4000 FORMAT(/,' *** XMFLUI : Maillage fluide',I3,/,
     &         '       - Maillage surfacique fluide couple : ',
     &         I6,' elements',/,
     &         '       - Maillage surfacique fluide non couple ',
     &         'mais avec rayonnement :',I6,' elements')
 4100 FORMAT(/,'   IMPRESSION DE LA TABLE DES ELEMENTS FLUIDES COUPLES')
 4200 FORMAT(  '     Element ',I9,' Noeuds : ',6I9)
 4300 FORMAT(/,'   IMPRESSION DE LA TABLE DES ELEMENTS FLUIDES+RAYT')
 4400 FORMAT(  '     Element ',I9,' Noeuds : ',6I9)
C
C----
C FIN
C----
C
      RETURN
      END
