C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=MOBTMP,SSI=0
                        SUBROUTINE MOBTMP
C                       *****************
C
C      -----------------------------
     * (NUMA,NDIM,NPOINS,TMPSA,TMPS)
C      -----------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C     SOLIDES EN TRANSLATION : REINITIALISATION DE LA TEMPERATURE      *
C     SUR LE MAILLAGE QUI VIENT SE REPOSITIONNER AU DESSOUS            *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NUMA     !  E ! D  ! Numero du maillage a translater (1 ou 2)     !
C !  NDIM     !  E ! D  ! Dimension du probleme                        !
C !  NPOINS   !  E ! D  ! Nombre de noeuds du maillage solide          !
C !  TMPSA    ! TR ! M  ! Temperature solide etape N                   |
C !  TMPS     ! TR ! M  ! Temperature solide etape N+1                 |
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : --- 
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
       IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "mobil.h"
#include "nlofes.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NUMA,NDIM,NPOINS
      DOUBLE PRECISION TMPSA(NPOINS),TMPS(NPOINS)
C
C.. Variables internes
      INTEGER N1,N2,N
C***********************************************************************
C
C
C     0- INITIALISATIONS
C     ==================
      IF (NUMA.EQ.1) THEN
         N1 = 1
         N2 = NBNMA1
      ELSEIF (NUMA.EQ.2) THEN
         N1 = NBNMA1 + 1
         N2 = NPOINS
      ELSEIF (NUMA.EQ.-1) THEN
         N1 = 1
         N2 = NPOINS
      ENDIF
C
C     1- REINITIALISATION DE LA TEMPERATURE
C     =====================================
C
      DO 100 N=N1,N2
        TMPS (N) = TENMOB
        TMPSA(N) = TENMOB
  100 CONTINUE
C
C
C
      RETURN
      END
