#include <SyFi.h>
#include <fstream>

using namespace GiNaC; 
using namespace SyFi; 
using namespace std; 



int main() {

    initSyFi(2);

    archive ar; 

    int order = 2; 
    int nsd   = 2; 

    ex polynom_space = pol(order,nsd, "a"); 
    cout <<"polynom_space "<<polynom_space<<endl; 
    ar.archive_ex(polynom_space, "polynom_space"); 

    ex p = polynom_space.op(0); 
    cout <<"polynom p = "<<p<<endl; 
    ar.archive_ex(p, "p"); 

    ex dpdx = diff(p,x);   
    cout <<"dpdx = "<<dpdx<<endl; 
    ar.archive_ex(dpdx, "dpdx"); 

    Triangle triangle(lst(0,0), lst(1,0), lst(0,1)); 
    ex intp = triangle.integrate(p); 
    cout <<"integral of p over reference triangle = "<<intp<<endl;  

    //Bernstein polynomial in barycentric coordinates 

    ex polynom_space2 = bernstein(order,triangle, "a"); 
    ex p2 = polynom_space2.op(0); 
    cout <<"polynom p2 = "<<p2<<endl; 
    ar.archive_ex(polynom_space2, "polynom_space2"); 

    ex dp2dx = diff(p2,x);   
    cout <<"dp2dx = "<<dp2dx<<endl; 
    ar.archive_ex(dp2dx, "dp2dx"); 

    ex intp2 = triangle.integrate(p2); 
    cout <<"integral of p2 over reference triangle = "<<intp<<endl;  
    ar.archive_ex(intp2, "intp2"); 

    ofstream vfile("pol.gar.v"); 
    vfile << ar; vfile.close(); 
    if(!compare_archives("pol.gar.v", "pol.gar.r")) { 
	    cerr << "Failure!" << endl;
	    return -1;
    }

    return 0; 

}
