/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;

public class IndexToBaseRowNode
extends FromTable {
    protected FromBaseTable source;
    protected ConglomerateDescriptor baseCD;
    protected boolean cursorTargetTable;
    protected PredicateList restrictionList;
    protected boolean forUpdate;
    private FormatableBitSet heapReferencedCols;
    private FormatableBitSet indexReferencedCols;
    private FormatableBitSet allReferencedCols;
    private FormatableBitSet heapOnlyReferencedCols;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        super.init(null, object9);
        this.source = (FromBaseTable)object;
        this.baseCD = (ConglomerateDescriptor)object2;
        this.resultColumns = (ResultColumnList)object3;
        this.cursorTargetTable = (Boolean)object4;
        this.restrictionList = (PredicateList)object7;
        this.forUpdate = (Boolean)object8;
        this.heapReferencedCols = (FormatableBitSet)object5;
        this.indexReferencedCols = (FormatableBitSet)object6;
        if (this.indexReferencedCols == null) {
            this.allReferencedCols = this.heapReferencedCols;
            this.heapOnlyReferencedCols = this.heapReferencedCols;
        } else {
            this.allReferencedCols = new FormatableBitSet(this.heapReferencedCols);
            this.allReferencedCols.or(this.indexReferencedCols);
            this.heapOnlyReferencedCols = new FormatableBitSet(this.allReferencedCols);
            this.heapOnlyReferencedCols.xor(this.indexReferencedCols);
        }
    }

    public boolean forUpdate() {
        return this.source.forUpdate();
    }

    public AccessPath getTrulyTheBestAccessPath() {
        return this.source.getTrulyTheBestAccessPath();
    }

    public CostEstimate getCostEstimate() {
        return this.source.getTrulyTheBestAccessPath().getCostEstimate();
    }

    public CostEstimate getFinalCostEstimate() {
        return this.source.getFinalCostEstimate();
    }

    boolean isOrderedOn(ColumnReference[] columnReferenceArray, boolean bl, Vector vector) throws StandardException {
        return this.source.isOrderedOn(columnReferenceArray, bl, vector);
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        ValueNode valueNode = null;
        this.assignResultSetNumber();
        this.costEstimate = this.getFinalCostEstimate();
        if (this.restrictionList != null) {
            valueNode = this.restrictionList.restorePredicates();
            this.restrictionList = null;
        }
        int n = -1;
        if (this.heapReferencedCols != null) {
            n = activationClassBuilder.addItem(this.heapReferencedCols);
        }
        int n2 = -1;
        if (this.allReferencedCols != null) {
            n2 = activationClassBuilder.addItem(this.allReferencedCols);
        }
        int n3 = -1;
        if (this.heapOnlyReferencedCols != null) {
            n3 = activationClassBuilder.addItem(this.heapOnlyReferencedCols);
        }
        int n4 = activationClassBuilder.addItem(new ReferencedColumnsDescriptorImpl(this.getIndexColMapping()));
        long l = this.baseCD.getConglomerateNumber();
        StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo = this.getLanguageConnectionContext().getTransactionCompile().getStaticCompiledConglomInfo(l);
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        methodBuilder.push(l);
        methodBuilder.push(activationClassBuilder.addItem(staticCompiledOpenConglomInfo));
        this.source.generate(activationClassBuilder, methodBuilder);
        methodBuilder.upCast("org.apache.derby.iapi.sql.execute.NoPutResultSet");
        this.resultColumns.generateHolder(activationClassBuilder, methodBuilder, this.heapReferencedCols, this.indexReferencedCols);
        methodBuilder.push(this.resultSetNumber);
        methodBuilder.push(this.source.getBaseTableName());
        methodBuilder.push(n);
        methodBuilder.push(n2);
        methodBuilder.push(n3);
        methodBuilder.push(n4);
        if (valueNode == null) {
            methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder methodBuilder2 = activationClassBuilder.newUserExprFun();
            valueNode.generate(activationClassBuilder, methodBuilder2);
            methodBuilder2.methodReturn();
            methodBuilder2.complete();
            activationClassBuilder.pushMethodReference(methodBuilder, methodBuilder2);
        }
        methodBuilder.push(this.forUpdate);
        methodBuilder.push(this.costEstimate.rowCount());
        methodBuilder.push(this.costEstimate.getEstimatedCost());
        methodBuilder.callMethod((short)185, null, "getIndexRowToBaseRowResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 14);
        if (this.cursorTargetTable) {
            activationClassBuilder.rememberCursorTarget(methodBuilder);
        }
    }

    public boolean isOneRowResultSet() throws StandardException {
        return this.source.isOneRowResultSet();
    }

    public boolean isNotExists() {
        return this.source.isNotExists();
    }

    void decrementLevel(int n) {
        this.source.decrementLevel(n);
    }

    public int updateTargetLockMode() {
        return this.source.updateTargetLockMode();
    }

    void adjustForSortElimination() {
        this.source.disableBulkFetch();
    }

    private int[] getIndexColMapping() {
        int n = this.resultColumns.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.resultColumns.elementAt(i);
            if (this.indexReferencedCols != null && resultColumn.getExpression() instanceof VirtualColumnNode) {
                VirtualColumnNode virtualColumnNode = (VirtualColumnNode)resultColumn.getExpression();
                nArray[i] = virtualColumnNode.getSourceColumn().getVirtualColumnId() - 1;
                continue;
            }
            nArray[i] = -1;
        }
        return nArray;
    }
}

