/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_UTIL_CHAR_H
#define _SC_UTIL_CHAR_H

namespace sc
{

class Char
{
public:
  /**
  * \brief check if a character is a whitespace.
  *
  * As whitespace counts a space (0x20), a tab (0x09), a carriage return (0x0d)
  * and a line feed (0x0a).
  */

  static bool isWhitespace( char c )
  {
    // ctype.h
    //isspace(c);
    return c == ' '    // Space
        || c == '\t'   // Tab
        || c == '\r'   // CR
        || c == '\n';  // LF
  }
};

} // namespace

#endif // _SC_UTIL_CHAR_H
