/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SVN_LOGENTRY_H
#define _SVN_LOGENTRY_H

// sc
#include "svn.h"
#include "LogEntryTypes.h"
#include "util/String.h"

// svn
struct svn_log_changed_path_t;

// sys
#include <vector>


namespace svn
{

/**
 * This class represents subversion log entries.
 */
class LogEntry
{
public:
  // svn_log_changed_path_t
  class Path
  {
  public:
    Path( const char* path, const struct svn_log_changed_path_t* svnpath );

    bool isCopied() const;
    bool isAdded() const;
    bool isModified() const;
    bool isDeleted() const;
    bool isReplaced() const;

    const sc::String& getCopyFromPath() const;
    Revnumber getCopyFromRev() const;
    const sc::String& getPath() const;
    char getAction() const;

  public:
    sc::String _path;
    char       _action;
    sc::String _copyFromPath;
    Revnumber  _copyFromRev;
  };

  typedef std::vector<Path> ChangedPaths;

  LogEntry( Revnumber rev, Date date, const sc::String& author, const sc::String& msg );

  Revnumber getRevnumber() const;
  Date getDate() const;
  const sc::String& getAuthor() const;
  const sc::String& getMessage() const;

  void addPath( const Path& path );
  const ChangedPaths& getPaths() const;

  void setMessage( const sc::String& ) const;

private:
  Revnumber    _rev;
  Date         _date;
  sc::String   _author;
  sc::String   _msg;

  ChangedPaths _paths;
};

} // namespace

#endif // _SVN_LOGENTRY_H
