---
title: 0.243.0 Breaking Changes
slug: breaking-changes/0.243.0
---

# v0.243.0 Breaking Changes

Release v0.243.0 comes with two breaking changes regarding multipart file
uploads and Django CSRF protection.

## Multipart uploads disabled by default

Previously, support for uploads via the
[GraphQL multipart request specification](https://github.com/jaydenseric/graphql-multipart-request-spec)
was enabled by default. This implicitly required Strawberry users to consider
the
[security implications outlined in the GraphQL Multipart Request Specification](https://github.com/jaydenseric/graphql-multipart-request-spec/blob/master/readme.md#security).
Given that most Strawberry users were likely not aware of this, we're making
multipart file upload support stictly opt-in via a new
`multipart_uploads_enabled` view settings.

To enable multipart upload support for your Strawberry view integration, please
follow the updated integration guides and enable appropriate security
measurements for your server.

## Django CSRF protection enabled

Previously, the Strawberry Django view integration was internally exempted from
Django's built-in CSRF protection (i.e, the `CsrfViewMiddleware` middleware).
While this is how many GraphQL APIs operate, implicitly addded exemptions can
lead to security vulnerabilities. Instead, we delegate the decision of adding an
CSRF exemption to users now.

Note that having the CSRF protection enabled on your Strawberry Django view
potentially requires all your clients to send an CSRF token with every request.
You can learn more about this in the official Django
[Cross Site Request Forgery protection documentation](https://docs.djangoproject.com/en/dev/ref/csrf/).

To restore the behaviour of the integration before this release, you can add the
`csrf_exempt` decorator provided by Django yourself:

```python
from django.urls import path
from django.views.decorators.csrf import csrf_exempt

from strawberry.django.views import GraphQLView

from api.schema import schema

urlpatterns = [
    path("graphql/", csrf_exempt(GraphQLView.as_view(schema=schema))),
]
```
