use lang:bs:macro;
use lang:bs;
use core:lang;

// Type of the result.
package Value resultType(Value original) {
	if (original == Value())
		Value(named{Bool});
	else
		wrapMaybe(original);
}

// Generate a toS function body.
package Function toSFunction(Type type) {
	Scope scope = rootScope;
	scope.lookup = BSLookup();

	BSTreeFn fn(Value(), SStr("toS"), [ValParam(type, "this"), ValParam(named{StrBuf}, "to")], null);
	FnBody body(fn, scope);
	fn.body = body;

	LocalVarAccess me(SrcPos(), body.parameters[0]);
	LocalVarAccess to(SrcPos(), body.parameters[1]);
	var b = pattern(body) {
		${to} << "{\n";
		${to}.indent();
		${to} << "value: " << ${me}.value << "\n";
		${to} << "end: " << ${me}.end << "\n";
		${to} << "error: " << ${me}.error << "\n";
		${to}.dedent();
		${to} << "}";
	};
	body.add(b);

	fn;
}

/**
 * Result type from the parsers. Contains information about a parse.
 */
Result : generate(params) {
	if (params.count != 1)
		return null;

	var resType = params[0].asRef(false);

	Type t("Result", [resType], TypeFlags:typeClass);

	// Data members:

	// Parse value, if parse succeeded.
	t.add(MemberVar("value", resultType(resType), t));

	// Last position parsed.
	t.add(MemberVar("end", named{Str:Iter}, t));

	// Error message.
	t.add(MemberVar("error", named{Str}, t));

	// To string function.
	t.add(toSFunction(t));

	// We know that all of these are default-constructible, so we can generate a default ctor.
	t.add(TypeDefaultCtor(t));
	t.add(TypeCopyCtor(t));
	t.add(TypeAssign(t));
	t.add(TypeDeepCopy(t));

	t;
}


/**
 * Result type from parsers in binary mode.
 */
BinaryResult : generate(params) {
	if (params.count != 1)
		return null;

	var resType = params[0].asRef(false);

	Type t("BinaryResult", [resType], TypeFlags:typeClass);

	// Data members:

	// Parse value, if parse succeeded.
	t.add(MemberVar("value", resultType(resType), t));

	// Last position parsed.
	t.add(MemberVar("end", named{Nat}, t));

	// Error message.
	t.add(MemberVar("error", named{Str}, t));

	// To string function.
	t.add(toSFunction(t));

	// We know that all of these are default-constructible, so we can generate a default ctor.
	t.add(TypeDefaultCtor(t));
	t.add(TypeCopyCtor(t));
	t.add(TypeAssign(t));
	t.add(TypeDeepCopy(t));

	t;
}
