use core:geometry;

/**
 * Describes a component in the layout hierarchy.
 *
 * A component is a rectangle that will be laid out according to the rules of the active Layout. The
 * Component class also stores information about the underlying component, such as minimum size and
 * other component-specific information.
 *
 * Provide a function called 'component' to wrap custom types inside the 'Component' class. The
 * system will try to call that function automatically when possible.
 *
 * Generally, all information inside a particular component is assumed to be read-only.
 */
class Component {
	// Optional reference to the root of a hierarchy of components. The layout syntax examines this
	// member whenever a component is added to the hierarchy and if it is set adds that component
	// instead. This can be used to bundle layouts together inside a function, and still have the
	// layout syntax add the proper root component.
	Component? bundleRoot;

	// Get either 'bundleRoot' if it is set, or 'this'.
	Component toAdd() {
		if (bundleRoot)
			bundleRoot;
		else
			this;
	}

	// Get the position of this component.
	Rect pos() {
		Rect();
	}

	// Set the position of this component.
	assign pos(Rect p) {}

	// Get the minimum size of this component.
	Size minSize() {
		Size(0, 0);
	}

	// Traverse the hierarchy to find all components.
	void findAll(fn(Component)->void fn) {
		fn.call(this);
	}
}


/**
 * A component that just takes up space in the layout.
 */
class FillBox extends Component {
	Size size;

	init(Size size) { init() { size = size; } }
	init(Float w, Float h) { init() { size(w, h); } }

	// Minimum size of the component.
	Size minSize() : override { size; }
}

