/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.geometry;

import adql.parser.feature.LanguageFeature;
import adql.query.ADQLObject;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.geometry.GeometryFunction;
import adql.query.operand.function.geometry.PointFunction;

public class ExtractCoord
extends GeometryFunction {
    public static final LanguageFeature FEATURE_COORD1 = new LanguageFeature("ivo://ivoa.net/std/TAPRegExt#features-adqlgeo", "COORD1", true, "Extract the first coordinate value, in degrees, of a given POINT or column reference.");
    public static final LanguageFeature FEATURE_COORD2 = new LanguageFeature("ivo://ivoa.net/std/TAPRegExt#features-adqlgeo", "COORD2", true, "Extract the second coordinate value, in degrees, of a given POINT or column reference.");
    protected final int indCoord;
    protected GeometryFunction.GeometryValue<PointFunction> point;

    public ExtractCoord(int indiceCoord, GeometryFunction.GeometryValue<PointFunction> p) throws ArrayIndexOutOfBoundsException, NullPointerException {
        if (indiceCoord <= 0 || indiceCoord > 2) {
            throw new ArrayIndexOutOfBoundsException("Impossible to extract another coordinate that the two first: only COORD1 and COORD2 exists in ADQL!");
        }
        this.indCoord = indiceCoord;
        if (p == null) {
            throw new NullPointerException("Impossible to build a COORD" + this.indCoord + " function without a point (a POINT function or a column which contains a POINT function)!");
        }
        this.point = p;
    }

    public ExtractCoord(ExtractCoord toCopy) throws Exception {
        this.indCoord = toCopy.indCoord;
        this.point = (GeometryFunction.GeometryValue)toCopy.point.getCopy();
    }

    @Override
    public final LanguageFeature getFeatureDescription() {
        return this.indCoord == 1 ? FEATURE_COORD1 : FEATURE_COORD2;
    }

    @Override
    public String getName() {
        return "COORD" + this.indCoord;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new ExtractCoord(this);
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isGeometry() {
        return false;
    }

    @Override
    public ADQLOperand[] getParameters() {
        return new ADQLOperand[]{this.point.getValue()};
    }

    @Override
    public int getNbParameters() {
        return 1;
    }

    @Override
    public ADQLOperand getParameter(int index) throws ArrayIndexOutOfBoundsException {
        if (index == 0) {
            return this.point.getValue();
        }
        throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\"!");
    }

    @Override
    public ADQLOperand setParameter(int index, ADQLOperand replacer) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        if (index == 0) {
            if (replacer == null) {
                throw new NullPointerException("Impossible to remove the only required parameter of the function " + this.getName() + "!");
            }
            ADQLOperand replaced = this.point.getValue();
            if (replacer instanceof GeometryFunction.GeometryValue) {
                this.point = (GeometryFunction.GeometryValue)replacer;
            } else if (replacer instanceof ADQLColumn) {
                this.point.setColumn((ADQLColumn)replacer);
            } else if (replacer instanceof PointFunction) {
                this.point.setGeometry((PointFunction)replacer);
            } else {
                throw new Exception("Impossible to replace GeometryValue/Column/PointFunction by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ")!");
            }
            this.setPosition(null);
            return replaced;
        }
        throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\"!");
    }
}

