-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

--------------------------------------------------------------------------------
--Synopsis:                                                                   --
--                                                                            --
--To provide a standardised file name format which is platform independent    --
--when the -plain option is chosen.                                           --
--                                                                            --
--------------------------------------------------------------------------------

with CommandLine;

package body PathFormatter is
   function Format (RawFileName : E_Strings.T) return E_Strings.T is
      WorkingDir : E_Strings.T;
      Result     : E_Strings.T;
   begin
      if CommandLine.Data.PlainOutput
        and then E_Strings.Get_Length (CommandLine.Data.StartDirectory) < E_Strings.Get_Length (RawFileName) then
         -- strip the working directory off the start of VCFileName
         WorkingDir := CommandLine.Data.StartDirectory;
         Result     :=
           E_Strings.Section
           (E_Str     => RawFileName,
            Start_Pos => E_Strings.Get_Length (E_Str => WorkingDir) + 1,
            Length    => E_Strings.Get_Length (E_Str => RawFileName) - E_Strings.Get_Length (E_Str => WorkingDir));

         -- Convert back slash directory separators to forward slashes
         Result := E_Strings.Translate (E_Str     => Result,
                                        From_Char => '\',
                                        To_Char   => '/');

         -- Finally, strip a leading slash if present
         if E_Strings.Get_Length (Result) >= 1 and then E_Strings.Get_Element (Result, E_Strings.Positions'First) = '/' then
            Result :=
              E_Strings.Section
              (E_Str     => Result,
               Start_Pos => E_Strings.Positions'First + 1,
               Length    => E_Strings.Get_Length (Result) - 1);
         end if;
      else
         Result := RawFileName;
      end if;
      return Result;
   end Format;
end PathFormatter;
