#!/bin/bash -x
# This small script can be used to export the SimplyHTML source tree from CVS
if [ $# -lt 1 ]
then
	echo "Usage: $0 <SimplyHTML version> [<RCS tag> [keep]]" >&2
	echo "Example: $0 0.7.9.rc4 fm_0_8_0_rc4" >&2
	echo "Example: $0 0.8.0+01  FM-0-8-0 keep" >&2
	echo "Use the 'keep' parameter to keep a complete copy." >&2
	exit 1
fi

simplyhtml_dir="simplyhtml-$1"
simplyhtml_tar="simplyhtml_$1"
if [ ! -d shtml ] && [ ! -d "${simplyhtml_dir}" ]
then # we don't want to overwrite anything...
	cvs -z3 -d:pserver:anonymous@simplyhtml.cvs.sourceforge.net:/cvsroot/simplyhtml export -r "$2" shtml || exit 1
	mv shtml "${simplyhtml_dir}" || exit 1
else
	echo "Directory 'shtml' or '${simplyhtml_dir}' exists." >&2
	exit 1
fi

### SAVE FIRST THE WHOLE SIMPLYHTML TREE ###
if [ -n "$3" ]
then
	mv ${simplyhtml_dir} ${simplyhtml_dir}.complete
	tar cvzf ${simplyhtml_tar}.complete.tar.gz \
		${simplyhtml_dir}.complete
	mv ${simplyhtml_dir}.complete ${simplyhtml_dir}
fi

### THEN CLEANUP THE SOURCE TREE ###
find ${simplyhtml_dir} -name \*.jar -o -name \*.zip | xargs rm -vf
rm -vfr ${simplyhtml_dir}/simplyhtml/windows-launcher

### CREATE ORIG.TAR.GZ ###
if [ -f "${simplyhtml_tar}.orig.tar.gz" ]
then
	mv -f "${simplyhtml_tar}.orig.tar.gz" "${simplyhtml_tar}.orig.tar.gz.BAK" \
		|| exit 1
fi
tar cvzf "${simplyhtml_tar}.orig.tar.gz" "${simplyhtml_dir}" || exit 1
rm -fr "${simplyhtml_dir}"
