/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef IMAGE_CODECS_CINEPAK_TABLES_H
#define IMAGE_CODECS_CINEPAK_TABLES_H

#include "common/scummsys.h"

namespace Image {

static const byte s_defaultPaletteLookup[1024] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02,
	0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02,
	0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02,
	0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02,
	0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02,
	0x03, 0x03, 0x03, 0x03, 0x02, 0x02, 0x02, 0x02,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x02, 0x02, 0x02,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x02, 0x02,
	0x04, 0x04, 0x04, 0x05, 0x06, 0x07, 0x07, 0x07,
	0x04, 0x04, 0x04, 0x05, 0x06, 0x07, 0x07, 0x07,
	0x04, 0x04, 0x04, 0x05, 0x06, 0x07, 0x07, 0x07,
	0x04, 0x04, 0x04, 0x05, 0x06, 0x07, 0x07, 0x07,
	0x08, 0x08, 0x08, 0x09, 0x0A, 0x07, 0x07, 0x07,
	0x0B, 0x0B, 0x0B, 0x0C, 0x0D, 0x0D, 0x0D, 0x07,
	0x0E, 0x0E, 0x0E, 0x0F, 0x0D, 0x0D, 0x0D, 0x0D,
	0x10, 0x10, 0x10, 0x11, 0x11, 0x11, 0x0D, 0x0D,
	0x12, 0x12, 0x12, 0x13, 0x14, 0x15, 0x16, 0x16,
	0x12, 0x12, 0x12, 0x13, 0x14, 0x15, 0x16, 0x16,
	0x12, 0x12, 0x12, 0x13, 0x14, 0x15, 0x16, 0x16,
	0x12, 0x12, 0x12, 0x13, 0x14, 0x15, 0x16, 0x16,
	0x17, 0x17, 0x17, 0x18, 0x19, 0x1A, 0x16, 0x16,
	0x1B, 0x1B, 0x1B, 0x1C, 0x1D, 0x1E, 0x1E, 0x1E,
	0x1F, 0x1F, 0x1F, 0x20, 0x21, 0x1E, 0x1E, 0x1E,
	0x22, 0x22, 0x22, 0x23, 0x24, 0x24, 0x24, 0x1E,
	0x25, 0x25, 0x25, 0x26, 0x27, 0x28, 0x29, 0x29,
	0x25, 0x25, 0x25, 0x26, 0x27, 0x28, 0x29, 0x29,
	0x25, 0x25, 0x25, 0x26, 0x27, 0x28, 0x29, 0x29,
	0x25, 0x25, 0x25, 0x26, 0x27, 0x28, 0x29, 0x29,
	0x2A, 0x2A, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2E,
	0x2F, 0x2F, 0x2F, 0x30, 0x31, 0x32, 0x2E, 0x2E,
	0x33, 0x33, 0x33, 0x34, 0x35, 0x36, 0x36, 0x36,
	0x33, 0x33, 0x33, 0x34, 0x35, 0x36, 0x36, 0x36,
	0x37, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3B, 0x3B,
	0x37, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3B, 0x3B,
	0x37, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3B, 0x3B,
	0x3C, 0x3C, 0x3D, 0x3E, 0x3F, 0x40, 0x40, 0x40,
	0x41, 0x41, 0x42, 0x43, 0x44, 0x45, 0x45, 0x45,
	0x46, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4A, 0x4A,
	0x4B, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x4F, 0x4F,
	0x4B, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x4F, 0x4F,
	0x50, 0x50, 0x51, 0x52, 0x53, 0x54, 0x54, 0x54,
	0x50, 0x50, 0x51, 0x52, 0x53, 0x54, 0x54, 0x54,
	0x50, 0x50, 0x51, 0x52, 0x53, 0x54, 0x54, 0x54,
	0x55, 0x55, 0x56, 0x57, 0x58, 0x59, 0x59, 0x59,
	0x5A, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5E, 0x5E,
	0x5F, 0x5F, 0x60, 0x61, 0x62, 0x63, 0x63, 0x63,
	0x64, 0x64, 0x65, 0x66, 0x67, 0x68, 0x68, 0x68,
	0x64, 0x64, 0x65, 0x66, 0x67, 0x68, 0x68, 0x68,
	0x69, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6D, 0x6D,
	0x69, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6D, 0x6D,
	0x69, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6D, 0x6D,
	0x6E, 0x6E, 0x6F, 0x70, 0x71, 0x72, 0x72, 0x72,
	0x73, 0x73, 0x74, 0x75, 0x76, 0x77, 0x77, 0x77,
	0x78, 0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7C, 0x7C,
	0x7D, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x81, 0x81,
	0x7D, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x81, 0x81,
	0x82, 0x82, 0x83, 0x84, 0x85, 0x86, 0x86, 0x86,
	0x82, 0x82, 0x83, 0x84, 0x85, 0x86, 0x86, 0x86,
	0x87, 0x87, 0x88, 0x89, 0x8A, 0x8B, 0x8B, 0x8B,
	0x8C, 0x8C, 0x8D, 0x8E, 0x8F, 0x90, 0x90, 0x90,
	0x91, 0x91, 0x92, 0x93, 0x94, 0x95, 0x95, 0x95,
	0x96, 0x96, 0x97, 0x98, 0x99, 0x9A, 0x9A, 0x9A,
	0x96, 0x96, 0x97, 0x98, 0x99, 0x9A, 0x9A, 0x9A,
	0x96, 0x96, 0x97, 0x98, 0x99, 0x9A, 0x9A, 0x9A,
	0x9B, 0x9B, 0x9B, 0x9C, 0x9D, 0x9D, 0x9D, 0x9D,
	0x9E, 0x9B, 0x9B, 0x9C, 0x9D, 0x9D, 0x9D, 0x9D,
	0x9E, 0x9E, 0x9F, 0xA0, 0xA1, 0xA1, 0xA1, 0xA1,
	0xA2, 0xA2, 0xA3, 0xA4, 0xA5, 0xA5, 0xA5, 0xA5,
	0xA6, 0xA6, 0xA7, 0xA8, 0xA9, 0xA9, 0xA9, 0xA9,
	0xAA, 0xAA, 0xAB, 0xAC, 0xAD, 0xAD, 0xAD, 0xAD,
	0xAA, 0xAA, 0xAB, 0xAC, 0xAD, 0xAD, 0xAD, 0xAD,
	0xAA, 0xAA, 0xAB, 0xAC, 0xAD, 0xAD, 0xAD, 0xAD,
	0xAE, 0xAE, 0xAE, 0xAF, 0xB0, 0xB0, 0xB0, 0xB0,
	0xAE, 0xAE, 0xAE, 0xAF, 0xB0, 0xB0, 0xB0, 0xB0,
	0xB4, 0xB1, 0xB1, 0xB2, 0xB3, 0xB3, 0xB3, 0xB3,
	0xB4, 0xB4, 0xB5, 0xB6, 0xB7, 0xB7, 0xB7, 0xB7,
	0xB8, 0xB8, 0xB9, 0xBA, 0xBB, 0xBB, 0xBB, 0xBB,
	0xBC, 0xBC, 0xBD, 0xBE, 0xBF, 0xBF, 0xBF, 0xBF,
	0xBC, 0xBC, 0xBD, 0xBE, 0xBF, 0xBF, 0xBF, 0xBF,
	0xBC, 0xBC, 0xBD, 0xBE, 0xBF, 0xBF, 0xBF, 0xBF,
	0xC2, 0xC0, 0xC0, 0xC0, 0xC1, 0xC1, 0xC1, 0xC1,
	0xC2, 0xC2, 0xC0, 0xC0, 0xC1, 0xC1, 0xC1, 0xC1,
	0xC2, 0xC2, 0xC2, 0xC3, 0xC4, 0xC4, 0xC4, 0xC4,
	0xC8, 0xC5, 0xC5, 0xC6, 0xC7, 0xC7, 0xC7, 0xC7,
	0xC8, 0xC8, 0xC9, 0xCA, 0xCB, 0xCB, 0xCB, 0xCB,
	0xCC, 0xCC, 0xCD, 0xCE, 0xCF, 0xCF, 0xCF, 0xCF,
	0xCC, 0xCC, 0xCD, 0xCE, 0xCF, 0xCF, 0xCF, 0xCF,
	0xCC, 0xCC, 0xCD, 0xCE, 0xCF, 0xCF, 0xCF, 0xCF,
	0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0,
	0xD2, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0,
	0xD2, 0xD2, 0xD1, 0xD1, 0xD1, 0xD1, 0xD1, 0xD1,
	0xD2, 0xD2, 0xD2, 0xD3, 0xD3, 0xD3, 0xD3, 0xD3,
	0xD4, 0xD4, 0xD4, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5,
	0xD4, 0xD4, 0xD4, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5,
	0xD4, 0xD4, 0xD4, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5,
	0xD4, 0xD4, 0xD4, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5,
	0xD6, 0xD6, 0xD6, 0xD6, 0xD6, 0xD6, 0xD6, 0xD6,
	0xD6, 0xD6, 0xD6, 0xD6, 0xD6, 0xD6, 0xD6, 0xD6,
	0xD8, 0xD6, 0xD6, 0xD6, 0xD6, 0xD6, 0xD6, 0xD6,
	0xD8, 0xD8, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7,
	0xD8, 0xD8, 0xD8, 0xD9, 0xD9, 0xD9, 0xD9, 0xD9,
	0xD8, 0xD8, 0xD8, 0xD9, 0xD9, 0xD9, 0xD9, 0xD9,
	0xD8, 0xD8, 0xD8, 0xD9, 0xD9, 0xD9, 0xD9, 0xD9,
	0xD8, 0xD8, 0xD8, 0xD9, 0xD9, 0xD9, 0xD9, 0xD9,
	0xDA, 0xDA, 0xDA, 0xDA, 0xDA, 0xDA, 0xDA, 0xDA,
	0xDA, 0xDA, 0xDA, 0xDA, 0xDA, 0xDA, 0xDA, 0xDA,
	0xDA, 0xDA, 0xDA, 0xDA, 0xDA, 0xDA, 0xDA, 0xDA,
	0xDA, 0xDA, 0xDA, 0xDA, 0xDA, 0xDA, 0xDA, 0xDA,
	0xDB, 0xDB, 0xDB, 0xDB, 0xDB, 0xDB, 0xDB, 0xDB,
	0xDB, 0xDB, 0xDB, 0xDB, 0xDB, 0xDB, 0xDB, 0xDB,
	0xDB, 0xDB, 0xDB, 0xDB, 0xDB, 0xDB, 0xDB, 0xDB,
	0xDB, 0xDB, 0xDB, 0xDB, 0xDB, 0xDB, 0xDB, 0xDB,
	0xDC, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC,
	0xDC, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC,
	0xDC, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC,
	0xDC, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC,
	0xDC, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC,
	0xDC, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC,
	0xDC, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC,
	0xDC, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC
};

static const byte s_defaultPalette[221 * 3] = {
	0x02, 0x02, 0x02,
	0x19, 0x19, 0x19,
	0x47, 0x02, 0x19,
	0x19, 0x0D, 0x47,
	0x00, 0x51, 0x00,
	0x2E, 0x3A, 0x00,
	0x5C, 0x23, 0x00,
	0x8F, 0x0A, 0x00,
	0x00, 0x45, 0x2E,
	0x2E, 0x2E, 0x2E,
	0x5C, 0x17, 0x2E,
	0x00, 0x3A, 0x5C,
	0x2E, 0x23, 0x5C,
	0x5C, 0x0C, 0x5C,
	0x00, 0x2C, 0x95,
	0x2E, 0x15, 0x95,
	0x00, 0x1A, 0xDC,
	0x2E, 0x03, 0xDC,
	0x15, 0x66, 0x15,
	0x43, 0x4F, 0x15,
	0x71, 0x38, 0x15,
	0xA4, 0x1E, 0x15,
	0xDB, 0x02, 0x15,
	0x15, 0x5A, 0x43,
	0x43, 0x43, 0x43,
	0x71, 0x2C, 0x43,
	0xA4, 0x13, 0x43,
	0x15, 0x4F, 0x71,
	0x43, 0x38, 0x71,
	0x71, 0x21, 0x71,
	0xA4, 0x07, 0x71,
	0x15, 0x40, 0xAA,
	0x43, 0x29, 0xAA,
	0x71, 0x12, 0xAA,
	0x15, 0x2F, 0xF1,
	0x43, 0x18, 0xF1,
	0x71, 0x01, 0xF1,
	0x29, 0x79, 0x29,
	0x57, 0x62, 0x29,
	0x85, 0x4B, 0x29,
	0xB7, 0x32, 0x29,
	0xEF, 0x16, 0x29,
	0x29, 0x6E, 0x57,
	0x57, 0x57, 0x57,
	0x85, 0x40, 0x57,
	0xB7, 0x27, 0x57,
	0xEF, 0x0B, 0x57,
	0x29, 0x62, 0x85,
	0x57, 0x4B, 0x85,
	0x85, 0x34, 0x85,
	0xB7, 0x1B, 0x85,
	0x29, 0x54, 0xBE,
	0x57, 0x3D, 0xBE,
	0x85, 0x26, 0xBE,
	0xB7, 0x0D, 0xBE,
	0x03, 0xB5, 0x09,
	0x3C, 0x99, 0x09,
	0x6A, 0x82, 0x09,
	0x98, 0x6B, 0x09,
	0xCA, 0x51, 0x09,
	0x03, 0xA9, 0x3C,
	0x3C, 0x8C, 0x3C,
	0x6A, 0x75, 0x3C,
	0x98, 0x5E, 0x3C,
	0xCA, 0x45, 0x3C,
	0x03, 0x9D, 0x6A,
	0x3C, 0x81, 0x6A,
	0x6A, 0x6A, 0x6A,
	0x98, 0x53, 0x6A,
	0xCA, 0x39, 0x6A,
	0x03, 0x92, 0x98,
	0x3C, 0x75, 0x98,
	0x6A, 0x5E, 0x98,
	0x98, 0x47, 0x98,
	0xCA, 0x2E, 0x98,
	0x03, 0x83, 0xD1,
	0x3C, 0x67, 0xD1,
	0x6A, 0x50, 0xD1,
	0x98, 0x39, 0xD1,
	0xCA, 0x20, 0xD1,
	0x14, 0xC7, 0x1B,
	0x4D, 0xAB, 0x1B,
	0x7B, 0x94, 0x1B,
	0xA9, 0x7D, 0x1B,
	0xDC, 0x63, 0x1B,
	0x14, 0xBA, 0x4D,
	0x4D, 0x9E, 0x4D,
	0x7B, 0x87, 0x4D,
	0xA9, 0x70, 0x4D,
	0xDC, 0x57, 0x4D,
	0x14, 0xAF, 0x7B,
	0x4D, 0x92, 0x7B,
	0x7B, 0x7B, 0x7B,
	0xA9, 0x64, 0x7B,
	0xDC, 0x4B, 0x7B,
	0x14, 0xA3, 0xA9,
	0x4D, 0x87, 0xA9,
	0x7B, 0x70, 0xA9,
	0xA9, 0x59, 0xA9,
	0xDC, 0x40, 0xA9,
	0x14, 0x95, 0xE2,
	0x4D, 0x79, 0xE2,
	0x7B, 0x62, 0xE2,
	0xA9, 0x4B, 0xE2,
	0xDC, 0x31, 0xE2,
	0x25, 0xD8, 0x2C,
	0x5E, 0xBB, 0x2C,
	0x8C, 0xA4, 0x2C,
	0xBA, 0x8D, 0x2C,
	0xED, 0x74, 0x2C,
	0x25, 0xCB, 0x5E,
	0x5E, 0xAF, 0x5E,
	0x8C, 0x98, 0x5E,
	0xBA, 0x81, 0x5E,
	0xED, 0x67, 0x5E,
	0x25, 0xC0, 0x8C,
	0x5E, 0xA3, 0x8C,
	0x8C, 0x8C, 0x8C,
	0xBA, 0x75, 0x8C,
	0xED, 0x5C, 0x8C,
	0x25, 0xB4, 0xBA,
	0x5E, 0x98, 0xBA,
	0x8C, 0x81, 0xBA,
	0xBA, 0x6A, 0xBA,
	0xED, 0x50, 0xBA,
	0x25, 0xA6, 0xF3,
	0x5E, 0x8A, 0xF3,
	0x8C, 0x73, 0xF3,
	0xBA, 0x5C, 0xF3,
	0xED, 0x42, 0xF3,
	0x35, 0xF6, 0x04,
	0x6E, 0xD9, 0x04,
	0x9C, 0xC2, 0x04,
	0xCA, 0xAB, 0x04,
	0xFD, 0x92, 0x04,
	0x35, 0xE8, 0x3C,
	0x6E, 0xCB, 0x3C,
	0x9C, 0xB4, 0x3C,
	0xCA, 0x9D, 0x3C,
	0xFD, 0x84, 0x3C,
	0x35, 0xDB, 0x6E,
	0x6E, 0xBF, 0x6E,
	0x9C, 0xA8, 0x6E,
	0xCA, 0x91, 0x6E,
	0xFD, 0x78, 0x6E,
	0x35, 0xD0, 0x9C,
	0x6E, 0xB3, 0x9C,
	0x9C, 0x9C, 0x9C,
	0xCA, 0x85, 0x9C,
	0xFD, 0x6C, 0x9C,
	0x35, 0xC4, 0xCA,
	0x6E, 0xA8, 0xCA,
	0x9C, 0x91, 0xCA,
	0xCA, 0x7A, 0xCA,
	0xFD, 0x61, 0xCA,
	0x7E, 0xE9, 0x13,
	0xAC, 0xD2, 0x13,
	0xDA, 0xBB, 0x13,
	0x45, 0xF7, 0x4B,
	0x7E, 0xDB, 0x4B,
	0xAC, 0xC4, 0x4B,
	0xDA, 0xAD, 0x4B,
	0x45, 0xEB, 0x7E,
	0x7E, 0xCE, 0x7E,
	0xAC, 0xB7, 0x7E,
	0xDA, 0xA0, 0x7E,
	0x45, 0xDF, 0xAC,
	0x7E, 0xC3, 0xAC,
	0xAC, 0xAC, 0xAC,
	0xDA, 0x95, 0xAC,
	0x45, 0xD4, 0xDA,
	0x7E, 0xB7, 0xDA,
	0xAC, 0xA0, 0xDA,
	0xDA, 0x89, 0xDA,
	0x8C, 0xF7, 0x22,
	0xBA, 0xE0, 0x22,
	0xE8, 0xC9, 0x22,
	0x8C, 0xE9, 0x59,
	0xBA, 0xD2, 0x59,
	0xE8, 0xBB, 0x59,
	0x53, 0xF9, 0x8C,
	0x8C, 0xDD, 0x8C,
	0xBA, 0xC6, 0x8C,
	0xE8, 0xAF, 0x8C,
	0x53, 0xEE, 0xBA,
	0x8C, 0xD1, 0xBA,
	0xBA, 0xBA, 0xBA,
	0xE8, 0xA3, 0xBA,
	0x53, 0xE2, 0xE8,
	0x8C, 0xC6, 0xE8,
	0xBA, 0xAF, 0xE8,
	0xE8, 0x98, 0xE8,
	0xC8, 0xEE, 0x30,
	0xF6, 0xD7, 0x30,
	0x9A, 0xF7, 0x67,
	0xC8, 0xE0, 0x67,
	0xF6, 0xC9, 0x67,
	0x9A, 0xEA, 0x9A,
	0xC8, 0xD3, 0x9A,
	0xF6, 0xBC, 0x9A,
	0x61, 0xFB, 0xC8,
	0x9A, 0xDF, 0xC8,
	0xC8, 0xC8, 0xC8,
	0xF6, 0xB1, 0xC8,
	0x61, 0xF0, 0xF6,
	0x9A, 0xD3, 0xF6,
	0xC8, 0xBC, 0xF6,
	0xF6, 0xA5, 0xF6,
	0xD5, 0xFB, 0x3D,
	0xD5, 0xED, 0x74,
	0xA7, 0xF7, 0xA7,
	0xD5, 0xE0, 0xA7,
	0xA7, 0xEC, 0xD5,
	0xD5, 0xD5, 0xD5,
	0xE1, 0xFA, 0x81,
	0xE1, 0xED, 0xB3,
	0xB3, 0xF8, 0xE1,
	0xE1, 0xE1, 0xE1,
	0xED, 0xF9, 0xBF,
	0xED, 0xED, 0xED,
	0xF8, 0xF8, 0xF8
};

static const uint32 s_yLookup[512] = {
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000040, 0x00000000, 0x00000040, 0x00000000,
	0x00000040, 0x00000000, 0x00000040, 0x00000000,
	0x00000040, 0x00000000, 0x00000040, 0x00000040,
	0x00000040, 0x00000040, 0x00000040, 0x00000040,
	0x00000040, 0x00000040, 0x00400040, 0x00000040,
	0x00400040, 0x00000040, 0x00400040, 0x00000040,
	0x00400040, 0x00000040, 0x00400040, 0x00000040,
	0x00400040, 0x00400040, 0x00400040, 0x00400040,
	0x00400040, 0x00400040, 0x00400040, 0x00400040,
	0x00400040, 0x00400040, 0x00400040, 0x00400040,
	0x00400040, 0x00400040, 0x00400040, 0x00400040,
	0x00400040, 0x00400040, 0x00400080, 0x00400040,
	0x00400080, 0x00400040, 0x00400080, 0x00400040,
	0x00400080, 0x00400040, 0x00400080, 0x00400080,
	0x00400080, 0x00400080, 0x00400080, 0x00400080,
	0x00400080, 0x00400080, 0x00400080, 0x00400080,
	0x00800080, 0x00400080, 0x00800080, 0x00400080,
	0x00800080, 0x00400080, 0x00800080, 0x00400080,
	0x00800080, 0x00800080, 0x00800080, 0x00800080,
	0x00800080, 0x00800080, 0x00800080, 0x00800080,
	0x00800080, 0x00800080, 0x00800080, 0x00800080,
	0x00800080, 0x00800080, 0x00800080, 0x00800080,
	0x00800080, 0x00800080, 0x008000C0, 0x00800080,
	0x008000C0, 0x00800080, 0x008000C0, 0x00800080,
	0x008000C0, 0x00800080, 0x008000C0, 0x008000C0,
	0x008000C0, 0x008000C0, 0x008000C0, 0x008000C0,
	0x008000C0, 0x008000C0, 0x00C000C0, 0x008000C0,
	0x00C000C0, 0x008000C0, 0x00C000C0, 0x008000C0,
	0x00C000C0, 0x008000C0, 0x00C000C0, 0x00C000C0,
	0x00C000C0, 0x00C000C0, 0x00C000C0, 0x00C000C0,
	0x00C000C0, 0x00C000C0, 0x00C000C0, 0x00C000C0,
	0x00C000C0, 0x00C000C0, 0x00C000C0, 0x00C000C0,
	0x00C000C0, 0x00C000C0, 0x00C00100, 0x00C000C0,
	0x00C00100, 0x00C000C0, 0x00C00100, 0x00C000C0,
	0x00C00100, 0x00C000C0, 0x00C00100, 0x00C00100,
	0x00C00100, 0x00C00100, 0x00C00100, 0x00C00100,
	0x00C00100, 0x00C00100, 0x01000100, 0x00C00100,
	0x01000100, 0x00C00100, 0x01000100, 0x00C00100,
	0x01000100, 0x00C00100, 0x01000100, 0x01000100,
	0x01000100, 0x01000100, 0x01000100, 0x01000100,
	0x01000100, 0x01000100, 0x01000100, 0x01000100,
	0x01000100, 0x01000100, 0x01000100, 0x01000100,
	0x01000100, 0x01000100, 0x01000140, 0x01000100,
	0x01000140, 0x01000100, 0x01000140, 0x01000100,
	0x01000140, 0x01000140, 0x01000140, 0x01000140,
	0x01000140, 0x01000140, 0x01000140, 0x01000140,
	0x01400140, 0x01000140, 0x01400140, 0x01000140,
	0x01400140, 0x01000140, 0x01400140, 0x01000140,
	0x01400140, 0x01400140, 0x01400140, 0x01400140,
	0x01400140, 0x01400140, 0x01400140, 0x01400140,
	0x01400140, 0x01400140, 0x01400140, 0x01400140,
	0x01400140, 0x01400140, 0x01400180, 0x01400140,
	0x01400180, 0x01400140, 0x01400180, 0x01400140,
	0x01400180, 0x01400140, 0x01400180, 0x01400180,
	0x01400180, 0x01400180, 0x01400180, 0x01400180,
	0x01800180, 0x01400180, 0x01800180, 0x01400180,
	0x01800180, 0x01400180, 0x01800180, 0x01400180,
	0x01800180, 0x01800180, 0x01800180, 0x01800180,
	0x01800180, 0x01800180, 0x01800180, 0x01800180,
	0x01800180, 0x01800180, 0x01800180, 0x01800180,
	0x01800180, 0x01800180, 0x018001C0, 0x01800180,
	0x018001C0, 0x01800180, 0x018001C0, 0x01800180,
	0x018001C0, 0x018001C0, 0x018001C0, 0x018001C0,
	0x018001C0, 0x018001C0, 0x018001C0, 0x018001C0,
	0x01C001C0, 0x018001C0, 0x01C001C0, 0x018001C0,
	0x01C001C0, 0x018001C0, 0x01C001C0, 0x01C001C0,
	0x01C001C0, 0x01C001C0, 0x01C001C0, 0x01C001C0,
	0x01C001C0, 0x01C001C0, 0x01C001C0, 0x01C001C0,
	0x01C001C0, 0x01C001C0, 0x01C00200, 0x01C001C0,
	0x01C00200, 0x01C001C0, 0x01C00200, 0x01C001C0,
	0x01C00200, 0x01C001C0, 0x01C00200, 0x01C00200,
	0x01C00200, 0x01C00200, 0x01C00200, 0x01C00200,
	0x02000200, 0x01C00200, 0x02000200, 0x01C00200,
	0x02000200, 0x01C00200, 0x02000200, 0x02000200,
	0x02000200, 0x02000200, 0x02000200, 0x02000200,
	0x02000200, 0x02000200, 0x02000200, 0x02000200,
	0x02000200, 0x02000200, 0x02000240, 0x02000200,
	0x02000240, 0x02000200, 0x02000240, 0x02000200,
	0x02000240, 0x02000240, 0x02000240, 0x02000240,
	0x02000240, 0x02000240, 0x02400240, 0x02000240,
	0x02400240, 0x02000240, 0x02400240, 0x02000240,
	0x02400240, 0x02000240, 0x02400240, 0x02400240,
	0x02400240, 0x02400240, 0x02400240, 0x02400240,
	0x02400240, 0x02400240, 0x02400240, 0x02400240,
	0x02400280, 0x02400240, 0x02400280, 0x02400240,
	0x02400280, 0x02400240, 0x02400280, 0x02400280,
	0x02400280, 0x02400280, 0x02400280, 0x02400280,
	0x02800280, 0x02400280, 0x02800280, 0x02400280,
	0x02800280, 0x02400280, 0x02800280, 0x02800280,
	0x02800280, 0x02800280, 0x02800280, 0x02800280,
	0x02800280, 0x02800280, 0x02800280, 0x02800280,
	0x02800280, 0x02800280, 0x028002C0, 0x02800280,
	0x028002C0, 0x02800280, 0x028002C0, 0x02800280,
	0x028002C0, 0x028002C0, 0x028002C0, 0x028002C0,
	0x02C002C0, 0x028002C0, 0x02C002C0, 0x028002C0,
	0x02C002C0, 0x028002C0, 0x02C002C0, 0x02C002C0,
	0x02C002C0, 0x02C002C0, 0x02C002C0, 0x02C002C0,
	0x02C002C0, 0x02C002C0, 0x02C002C0, 0x02C002C0,
	0x02C00300, 0x02C002C0, 0x02C00300, 0x02C002C0,
	0x02C00300, 0x02C002C0, 0x02C00300, 0x02C00300,
	0x02C00300, 0x02C00300, 0x02C00300, 0x02C00300,
	0x03000300, 0x02C00300, 0x03000300, 0x02C00300,
	0x03000300, 0x03000300, 0x03000300, 0x03000300,
	0x03000300, 0x03000300, 0x03000300, 0x03000300,
	0x03000300, 0x03000300, 0x03000340, 0x03000300,
	0x03000340, 0x03000300, 0x03000340, 0x03000300,
	0x03000340, 0x03000340, 0x03000340, 0x03000340,
	0x03400340, 0x03000340, 0x03400340, 0x03000340,
	0x03400340, 0x03000340, 0x03400340, 0x03400340,
	0x03400340, 0x03400340, 0x03400340, 0x03400340,
	0x03400340, 0x03400340, 0x03400340, 0x03400340,
	0x03400380, 0x03400340, 0x03400380, 0x03400340,
	0x03400380, 0x03400380, 0x03400380, 0x03400380,
	0x03800380, 0x03400380, 0x03800380, 0x03400380,
	0x03800380, 0x03400380, 0x03800380, 0x03800380,
	0x03800380, 0x03800380, 0x03800380, 0x03800380,
	0x03800380, 0x03800380, 0x038003C0, 0x03800380,
	0x038003C0, 0x03800380, 0x038003C0, 0x03800380,
	0x038003C0, 0x038003C0, 0x038003C0, 0x038003C0,
	0x03C003C0, 0x038003C0, 0x03C003C0, 0x038003C0,
	0x03C003C0, 0x03C003C0, 0x03C003C0, 0x03C003C0,
	0x03C003C0, 0x03C003C0, 0x03C003C0, 0x03C003C0,
	0x03C003C0, 0x03C003C0, 0x03C003C0, 0x03C003C0,
	0x03C003C0, 0x03C003C0, 0x03C003C0, 0x03C003C0,
	0x03C003C0, 0x03C003C0, 0x03C003C0, 0x03C003C0
};

static const uint32 s_uLookup[512] = {
	0x00200020, 0x00200020, 0x00200020, 0x00200020,
	0x00200020, 0x00200020, 0x00200020, 0x00200020,
	0x00200020, 0x00200020, 0x00280020, 0x00200020,
	0x00280020, 0x00200020, 0x00280020, 0x00200020,
	0x00280020, 0x00200020, 0x00280020, 0x00280020,
	0x00280020, 0x00280020, 0x00280020, 0x00280020,
	0x00280020, 0x00280020, 0x00280020, 0x00280020,
	0x00280020, 0x00280028, 0x00280020, 0x00280028,
	0x00280020, 0x00280028, 0x00280020, 0x00280028,
	0x00280028, 0x00280028, 0x00280028, 0x00280028,
	0x00280028, 0x00280028, 0x00280028, 0x00280028,
	0x00280028, 0x00280028, 0x00280028, 0x00280028,
	0x00280028, 0x00280028, 0x00280028, 0x00280028,
	0x00280028, 0x00280028, 0x00280028, 0x00280028,
	0x00280028, 0x00280028, 0x00300028, 0x00280028,
	0x00300028, 0x00280028, 0x00300028, 0x00280028,
	0x00300028, 0x00280028, 0x00300028, 0x00280028,
	0x00300028, 0x00300028, 0x00300028, 0x00300028,
	0x00300028, 0x00300028, 0x00300028, 0x00300028,
	0x00300028, 0x00300028, 0x00300028, 0x00300028,
	0x00300028, 0x00300030, 0x00300028, 0x00300030,
	0x00300028, 0x00300030, 0x00300028, 0x00300030,
	0x00300028, 0x00300030, 0x00300028, 0x00300030,
	0x00300030, 0x00300030, 0x00300030, 0x00300030,
	0x00300030, 0x00300030, 0x00300030, 0x00300030,
	0x00300030, 0x00300030, 0x00300030, 0x00300030,
	0x00300030, 0x00300030, 0x00300030, 0x00300030,
	0x00300030, 0x00300030, 0x00300030, 0x00300030,
	0x00300030, 0x00300030, 0x00300030, 0x00300030,
	0x00300030, 0x00300030, 0x00380030, 0x00300030,
	0x00380030, 0x00300030, 0x00380030, 0x00300030,
	0x00380030, 0x00300030, 0x00380030, 0x00300030,
	0x00380030, 0x00300030, 0x00380030, 0x00300030,
	0x00380030, 0x00380030, 0x00380030, 0x00380030,
	0x00380030, 0x00380030, 0x00380030, 0x00380030,
	0x00380030, 0x00380030, 0x00380030, 0x00380030,
	0x00380030, 0x00380030, 0x00380030, 0x00380038,
	0x00380030, 0x00380038, 0x00380030, 0x00380038,
	0x00380030, 0x00380038, 0x00380030, 0x00380038,
	0x00380030, 0x00380038, 0x00380030, 0x00380038,
	0x00380038, 0x00380038, 0x00380038, 0x00380038,
	0x00380038, 0x00380038, 0x00380038, 0x00380038,
	0x00380038, 0x00380038, 0x00380038, 0x00380038,
	0x00380038, 0x00380038, 0x00380038, 0x00380038,
	0x00380038, 0x00380038, 0x00380038, 0x00380038,
	0x00380038, 0x00380038, 0x00380038, 0x00380038,
	0x00380038, 0x00380038, 0x00380038, 0x00380038,
	0x00380038, 0x00380038, 0x00380038, 0x00380038,
	0x00380038, 0x00380038, 0x00380038, 0x00380038,
	0x00380038, 0x00380038, 0x00380038, 0x00380038,
	0x00380038, 0x00380038, 0x00380038, 0x00380038,
	0x00380038, 0x00380038, 0x00380038, 0x00380038,
	0x00380038, 0x00380038, 0x00380038, 0x00380038,
	0x00380038, 0x00380038, 0x00380038, 0x00380038,
	0x00380038, 0x00380038, 0x00380038, 0x00380038,
	0x00380038, 0x00380038, 0x00380038, 0x00380038,
	0x00380038, 0x00380038, 0x00380038, 0x00380038,
	0x00380038, 0x00380038, 0x00380038, 0x00380038,
	0x00380038, 0x00380038, 0x00380038, 0x00380038,
	0x00380038, 0x00380038, 0x00380038, 0x00380038,
	0x00380038, 0x00380038, 0x00380038, 0x00380038,
	0x00380038, 0x00380038, 0x00380038, 0x00380038,
	0x00380038, 0x00380038, 0x00380038, 0x00380038,
	0x00380038, 0x00380038, 0x00380038, 0x00380038,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00080000, 0x00000000,
	0x00080000, 0x00000000, 0x00080000, 0x00000000,
	0x00080000, 0x00000000, 0x00080000, 0x00000000,
	0x00080000, 0x00000000, 0x00080000, 0x00000000,
	0x00080000, 0x00080000, 0x00080000, 0x00080000,
	0x00080000, 0x00080000, 0x00080000, 0x00080000,
	0x00080000, 0x00080000, 0x00080000, 0x00080000,
	0x00080000, 0x00080008, 0x00080000, 0x00080008,
	0x00080000, 0x00080008, 0x00080000, 0x00080008,
	0x00080000, 0x00080008, 0x00080000, 0x00080008,
	0x00080008, 0x00080008, 0x00080008, 0x00080008,
	0x00080008, 0x00080008, 0x00080008, 0x00080008,
	0x00080008, 0x00080008, 0x00080008, 0x00080008,
	0x00080008, 0x00080008, 0x00080008, 0x00080008,
	0x00080008, 0x00080008, 0x00080008, 0x00080008,
	0x00080008, 0x00080008, 0x00100008, 0x00080008,
	0x00100008, 0x00080008, 0x00100008, 0x00080008,
	0x00100008, 0x00080008, 0x00100008, 0x00080008,
	0x00100008, 0x00080008, 0x00100008, 0x00100008,
	0x00100008, 0x00100008, 0x00100008, 0x00100008,
	0x00100008, 0x00100008, 0x00100008, 0x00100008,
	0x00100008, 0x00100008, 0x00100008, 0x00100010,
	0x00100008, 0x00100010, 0x00100008, 0x00100010,
	0x00100008, 0x00100010, 0x00100008, 0x00100010,
	0x00100010, 0x00100010, 0x00100010, 0x00100010,
	0x00100010, 0x00100010, 0x00100010, 0x00100010,
	0x00100010, 0x00100010, 0x00100010, 0x00100010,
	0x00100010, 0x00100010, 0x00100010, 0x00100010,
	0x00100010, 0x00100010, 0x00100010, 0x00100010,
	0x00100010, 0x00100010, 0x00180010, 0x00100010,
	0x00180010, 0x00100010, 0x00180010, 0x00100010,
	0x00180010, 0x00100010, 0x00180010, 0x00100010,
	0x00180010, 0x00180010, 0x00180010, 0x00180010,
	0x00180010, 0x00180010, 0x00180010, 0x00180010,
	0x00180010, 0x00180010, 0x00180010, 0x00180018,
	0x00180010, 0x00180018, 0x00180010, 0x00180018,
	0x00180010, 0x00180018, 0x00180010, 0x00180018,
	0x00180018, 0x00180018, 0x00180018, 0x00180018,
	0x00180018, 0x00180018, 0x00180018, 0x00180018,
	0x00180018, 0x00180018, 0x00180018, 0x00180018,
	0x00180018, 0x00180018, 0x00180018, 0x00180018,
	0x00180018, 0x00180018, 0x00180018, 0x00180018,
	0x00200018, 0x00180018, 0x00200018, 0x00180018,
	0x00200018, 0x00180018, 0x00200018, 0x00180018,
	0x00200018, 0x00200018, 0x00200018, 0x00200018,
	0x00200018, 0x00200018, 0x00200018, 0x00200018,
	0x00200018, 0x00200018, 0x00200018, 0x00200020,
	0x00200018, 0x00200020, 0x00200018, 0x00200020,
	0x00200018, 0x00200020, 0x00200020, 0x00200020,
	0x00200020, 0x00200020, 0x00200020, 0x00200020,
	0x00200020, 0x00200020, 0x00200020, 0x00200020
};

static const uint32 s_vLookup[512] = {
	0x00030003, 0x00030003, 0x00030003, 0x00030003,
	0x00030003, 0x00030003, 0x00030003, 0x00030003,
	0x00030003, 0x00030003, 0x00030003, 0x00030004,
	0x00030003, 0x00030004, 0x00030003, 0x00030004,
	0x00030003, 0x00030004, 0x00030004, 0x00030004,
	0x00030004, 0x00030004, 0x00030004, 0x00030004,
	0x00030004, 0x00030004, 0x00030004, 0x00030004,
	0x00030004, 0x00040004, 0x00030004, 0x00040004,
	0x00030004, 0x00040004, 0x00030004, 0x00040004,
	0x00040004, 0x00040004, 0x00040004, 0x00040004,
	0x00040004, 0x00040004, 0x00040004, 0x00040004,
	0x00040004, 0x00040004, 0x00040004, 0x00040004,
	0x00040004, 0x00040004, 0x00040004, 0x00040004,
	0x00040004, 0x00040004, 0x00040004, 0x00040004,
	0x00040004, 0x00040005, 0x00040004, 0x00040005,
	0x00040004, 0x00040005, 0x00040004, 0x00040005,
	0x00040004, 0x00040005, 0x00040005, 0x00040005,
	0x00040005, 0x00040005, 0x00040005, 0x00040005,
	0x00040005, 0x00040005, 0x00040005, 0x00040005,
	0x00040005, 0x00050005, 0x00040005, 0x00050005,
	0x00040005, 0x00050005, 0x00040005, 0x00050005,
	0x00040005, 0x00050005, 0x00050005, 0x00050005,
	0x00050005, 0x00050005, 0x00050005, 0x00050005,
	0x00050005, 0x00050005, 0x00050005, 0x00050005,
	0x00050005, 0x00050005, 0x00050005, 0x00050005,
	0x00050005, 0x00050005, 0x00050005, 0x00050005,
	0x00050005, 0x00050005, 0x00050005, 0x00050005,
	0x00050005, 0x00050006, 0x00050005, 0x00050006,
	0x00050005, 0x00050006, 0x00050005, 0x00050006,
	0x00050005, 0x00050006, 0x00050006, 0x00050006,
	0x00050006, 0x00050006, 0x00050006, 0x00050006,
	0x00050006, 0x00050006, 0x00050006, 0x00050006,
	0x00050006, 0x00050006, 0x00050006, 0x00060006,
	0x00050006, 0x00060006, 0x00050006, 0x00060006,
	0x00050006, 0x00060006, 0x00050006, 0x00060006,
	0x00050006, 0x00060006, 0x00060006, 0x00060006,
	0x00060006, 0x00060006, 0x00060006, 0x00060006,
	0x00060006, 0x00060006, 0x00060006, 0x00060006,
	0x00060006, 0x00060006, 0x00060006, 0x00060006,
	0x00060006, 0x00060006, 0x00060006, 0x00060006,
	0x00060006, 0x00060006, 0x00060006, 0x00060006,
	0x00060006, 0x00060007, 0x00060006, 0x00060007,
	0x00060006, 0x00060007, 0x00060006, 0x00060007,
	0x00060006, 0x00060007, 0x00060006, 0x00060007,
	0x00060007, 0x00060007, 0x00060007, 0x00060007,
	0x00060007, 0x00060007, 0x00060007, 0x00060007,
	0x00060007, 0x00060007, 0x00060007, 0x00060007,
	0x00060007, 0x00070007, 0x00060007, 0x00070007,
	0x00060007, 0x00070007, 0x00060007, 0x00070007,
	0x00060007, 0x00070007, 0x00060007, 0x00070007,
	0x00060007, 0x00070007, 0x00070007, 0x00070007,
	0x00070007, 0x00070007, 0x00070007, 0x00070007,
	0x00070007, 0x00070007, 0x00070007, 0x00070007,
	0x00070007, 0x00070007, 0x00070007, 0x00070007,
	0x00070007, 0x00070007, 0x00070007, 0x00070007,
	0x00070007, 0x00070007, 0x00070007, 0x00070007,
	0x00070007, 0x00070007, 0x00070007, 0x00070007,
	0x00070007, 0x00070007, 0x00070007, 0x00070007,
	0x00070007, 0x00070007, 0x00070007, 0x00070007,
	0x00070007, 0x00070007, 0x00070007, 0x00070007,
	0x00070007, 0x00070007, 0x00070007, 0x00070007,
	0x00070007, 0x00070007, 0x00070007, 0x00070007,
	0x00070007, 0x00070007, 0x00070007, 0x00070007,
	0x00070007, 0x00070007, 0x00070007, 0x00070007,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000001, 0x00000000, 0x00000001,
	0x00000000, 0x00000001, 0x00000000, 0x00000001,
	0x00000000, 0x00000001, 0x00000000, 0x00000001,
	0x00000000, 0x00000001, 0x00000001, 0x00000001,
	0x00000001, 0x00000001, 0x00000001, 0x00000001,
	0x00000001, 0x00000001, 0x00000001, 0x00000001,
	0x00000001, 0x00000001, 0x00000001, 0x00000001,
	0x00000001, 0x00010001, 0x00000001, 0x00010001,
	0x00000001, 0x00010001, 0x00000001, 0x00010001,
	0x00000001, 0x00010001, 0x00000001, 0x00010001,
	0x00000001, 0x00010001, 0x00010001, 0x00010001,
	0x00010001, 0x00010001, 0x00010001, 0x00010001,
	0x00010001, 0x00010001, 0x00010001, 0x00010001,
	0x00010001, 0x00010001, 0x00010001, 0x00010001,
	0x00010001, 0x00010001, 0x00010001, 0x00010001,
	0x00010001, 0x00010001, 0x00010001, 0x00010001,
	0x00010001, 0x00010001, 0x00010001, 0x00010001,
	0x00010001, 0x00010002, 0x00010001, 0x00010002,
	0x00010001, 0x00010002, 0x00010001, 0x00010002,
	0x00010001, 0x00010002, 0x00010001, 0x00010002,
	0x00010002, 0x00010002, 0x00010002, 0x00010002,
	0x00010002, 0x00010002, 0x00010002, 0x00010002,
	0x00010002, 0x00010002, 0x00010002, 0x00010002,
	0x00010002, 0x00020002, 0x00010002, 0x00020002,
	0x00010002, 0x00020002, 0x00010002, 0x00020002,
	0x00010002, 0x00020002, 0x00020002, 0x00020002,
	0x00020002, 0x00020002, 0x00020002, 0x00020002,
	0x00020002, 0x00020002, 0x00020002, 0x00020002,
	0x00020002, 0x00020002, 0x00020002, 0x00020002,
	0x00020002, 0x00020002, 0x00020002, 0x00020002,
	0x00020002, 0x00020002, 0x00020002, 0x00020002,
	0x00020002, 0x00020003, 0x00020002, 0x00020003,
	0x00020002, 0x00020003, 0x00020002, 0x00020003,
	0x00020003, 0x00020003, 0x00020003, 0x00020003,
	0x00020003, 0x00020003, 0x00020003, 0x00020003,
	0x00020003, 0x00020003, 0x00020003, 0x00030003,
	0x00020003, 0x00030003, 0x00020003, 0x00030003,
	0x00020003, 0x00030003, 0x00030003, 0x00030003,
	0x00030003, 0x00030003, 0x00030003, 0x00030003,
	0x00030003, 0x00030003, 0x00030003, 0x00030003
};

} // End of namespace Image

#endif
