/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil;

import ch.epfl.lamp.compiler.msil.Assembly;
import ch.epfl.lamp.compiler.msil.ConstructorInfo;
import ch.epfl.lamp.compiler.msil.PEFile;
import ch.epfl.lamp.compiler.msil.ParameterInfo;
import ch.epfl.lamp.compiler.msil.Type;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class Attribute {
    private final ConstructorInfo constr;
    private final byte[] value;
    private static final Map type2id = new HashMap();
    private static final Map id2type = new HashMap();
    private Object[] constrArgs;
    private Map namedArgs;
    private ByteBuffer buf;

    Attribute(ConstructorInfo constr, byte[] value) {
        assert (constr != null);
        this.constr = constr;
        assert (value != null) : constr.toString();
        this.value = value;
    }

    public Type GetType() {
        return this.constr.DeclaringType;
    }

    public ConstructorInfo getConstructor() {
        return this.constr;
    }

    public byte[] getValue() {
        byte[] value = new byte[this.value.length];
        System.arraycopy(this.value, 0, value, 0, value.length);
        return value;
    }

    public Object[] getConstructorArguments() {
        this.parseBlob();
        Object[] cas = new Object[this.constrArgs.length];
        System.arraycopy(this.constrArgs, 0, cas, 0, cas.length);
        return cas;
    }

    public NamedArgument getNamedArgument(String name) {
        return (NamedArgument)this.namedArgs.get(name);
    }

    public NamedArgument[] getNamedArguments() {
        NamedArgument[] nargs = this.namedArgs.values().toArray(NamedArgument.EMPTY);
        return nargs;
    }

    public String toString() {
        this.parseBlob();
        ParameterInfo[] params = this.constr.GetParameters();
        assert (params.length == this.constrArgs.length) : this.constr;
        StringBuffer str = new StringBuffer();
        str.append('[');
        str.append(this.constr.DeclaringType.FullName);
        str.append('(');
        for (int i = 0; i < this.constrArgs.length; ++i) {
            Type t;
            if (i > 0) {
                str.append(", ");
            }
            if ((t = params[i].ParameterType).IsEnum()) {
                str.append('(');
                str.append(t.FullName);
                str.append(')');
            }
            Attribute.formatValue(str, this.constrArgs[i]);
        }
        NamedArgument[] nargs = this.getNamedArguments();
        for (int i = 0; i < nargs.length; ++i) {
            str.append(", ").append(nargs[i]);
        }
        str.append(")]");
        return str.toString();
    }

    private static void map(String type, int id) {
        Type t = Type.GetType("System." + type);
        assert (type != null) : type + " -> " + id;
        Integer i = new Integer(id);
        type2id.put(t, i);
        id2type.put(i, t);
    }

    private static int getTypeId(Type type) {
        Integer id = (Integer)type2id.get(type);
        assert (id != null) : type;
        return id;
    }

    private void parseBlob() {
        try {
            this.parseBlob0();
        }
        catch (RuntimeException e) {
            throw new RuntimeException(PEFile.bytes2hex(this.value), e);
        }
    }

    private void parseBlob0() {
        if (this.buf != null) {
            return;
        }
        this.buf = ByteBuffer.wrap(this.value);
        this.buf.order(ByteOrder.LITTLE_ENDIAN);
        short sig = this.buf.getShort();
        assert (sig == 1) : PEFile.bytes2hex(this.value);
        ParameterInfo[] params = this.constr.GetParameters();
        this.constrArgs = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            this.constrArgs[i] = this.parseFixedArg(params[i].ParameterType);
        }
        int ncount = this.buf.getShort();
        this.namedArgs = new LinkedHashMap();
        for (int i = 0; i < ncount; ++i) {
            byte designator = this.buf.get();
            assert (designator == 83 || designator == 84) : "0x" + PEFile.byte2hex(designator);
            Type type = this.parseFieldOrPropTypeInNamedArg();
            String name = this.parseString();
            Object value = this.parseFixedArg(type);
            NamedArgument narg = new NamedArgument(designator, name, type, value);
            this.namedArgs.put(name, narg);
        }
    }

    private Object parseFixedArg(Type type) {
        if (type.IsArray()) {
            return this.parseArray(type.GetElementType());
        }
        return this.parseElem(type);
    }

    private boolean isSimpleElem(Type type) {
        if (!type2id.containsKey(type)) {
            return false;
        }
        int id = Attribute.getTypeId(type);
        switch (id) {
            case 14: 
            case 28: 
            case 80: {
                return false;
            }
        }
        return true;
    }

    private boolean isStringElem(Type type) {
        if (!type2id.containsKey(type)) {
            return false;
        }
        int id = Attribute.getTypeId(type);
        return id == 14;
    }

    private boolean isTypeElem(Type type) {
        if (!type2id.containsKey(type)) {
            return false;
        }
        int id = Attribute.getTypeId(type);
        return id == 80;
    }

    private boolean isSystemObject(Type type) {
        if (!type2id.containsKey(type)) {
            return false;
        }
        int id = Attribute.getTypeId(type);
        return id == 28;
    }

    private Object parseElem(Type type) {
        if (this.isSimpleElem(type)) {
            return this.parseVal(Attribute.getTypeId(type));
        }
        if (type.IsEnum()) {
            return this.parseVal(Attribute.getTypeId(type.getUnderlyingType()));
        }
        if (this.isStringElem(type)) {
            return this.parseString();
        }
        if (this.isTypeElem(type)) {
            return this.getTypeFromSerString();
        }
        if (this.isSystemObject(type)) {
            Type boxedT = this.parse0x51();
            if (boxedT.IsEnum()) {
                return new BoxedArgument(boxedT, this.parseVal(Attribute.getTypeId(boxedT.getUnderlyingType())));
            }
            return new BoxedArgument(boxedT, this.parseVal(Attribute.getTypeId(boxedT)));
        }
        Type boxedT = this.parseType();
        return this.parseVal(Attribute.getTypeId(boxedT));
    }

    private Object parseVal(int id) {
        switch (id) {
            case 2: {
                return new Boolean(this.buf.get() != 0);
            }
            case 3: {
                return new Character(this.buf.getChar());
            }
            case 4: 
            case 5: {
                return new Byte(this.buf.get());
            }
            case 6: 
            case 7: {
                return new Short(this.buf.getShort());
            }
            case 8: 
            case 9: {
                return new Integer(this.buf.getInt());
            }
            case 10: 
            case 11: {
                return new Long(this.buf.getLong());
            }
            case 12: {
                return new Float(this.buf.getFloat());
            }
            case 13: {
                return new Double(this.buf.getDouble());
            }
            case 80: {
                return this.getTypeFromSerString();
            }
            case 14: {
                return this.parseString();
            }
        }
        throw new RuntimeException("Shouldn't have called parseVal with: " + id);
    }

    private Object parseArray(Type type) {
        if (type.IsEnum()) {
            return this.parseArray(type.getUnderlyingType());
        }
        return this.parseArray(Attribute.getTypeId(type));
    }

    private Object parseArray(int id) {
        switch (id) {
            case 2: {
                return this.parseBooleanArray();
            }
            case 3: {
                return this.parseCharArray();
            }
            case 4: 
            case 5: {
                return this.parseByteArray();
            }
            case 6: 
            case 7: {
                return this.parseShortArray();
            }
            case 8: 
            case 9: {
                return this.parseIntArray();
            }
            case 10: 
            case 11: {
                return this.parseLongArray();
            }
            case 12: {
                return this.parseFloatArray();
            }
            case 13: {
                return this.parseDoubleArray();
            }
            case 14: {
                return this.parseStringArray();
            }
            case 85: {
                return this.parseArray(this.getTypeFromSerString());
            }
        }
        throw new RuntimeException("Unknown type id: " + id);
    }

    private Type parseType() {
        byte id = this.buf.get();
        switch (id) {
            case 29: {
                Type arrT = Type.mkArray(this.parseType(), 1);
                return arrT;
            }
            case 85: {
                String enumName = this.parseString();
                Type enumT = Type.getType(enumName);
                return enumT;
            }
        }
        Type t = (Type)id2type.get(new Integer(id));
        assert (t != null) : PEFile.byte2hex(id);
        return t;
    }

    private Type parse0x51() {
        byte id = this.buf.get();
        switch (id) {
            case 81: {
                return this.parse0x51();
            }
            case 29: {
                Type arrT = Type.mkArray(this.parseType(), 1);
                return arrT;
            }
            case 85: {
                String enumName = this.parseString();
                Type enumT = Type.getType(enumName);
                return enumT;
            }
        }
        Type t = (Type)id2type.get(new Integer(id));
        assert (t != null) : PEFile.byte2hex(id);
        return t;
    }

    private Type parseFieldOrPropTypeInNamedArg() {
        byte id = this.buf.get();
        switch (id) {
            case 81: {
                return (Type)id2type.get(new Integer(28));
            }
            case 85: {
                String enumName = this.parseString();
                Type enumT = Type.getType(enumName);
                return enumT;
            }
        }
        Type t = (Type)id2type.get(new Integer(id));
        assert (t != null) : PEFile.byte2hex(id);
        return t;
    }

    private Type getTypeFromSerString() {
        int j;
        String typename = this.parseString();
        int i = typename.indexOf(44);
        String name = i < 0 ? typename : typename.substring(0, i);
        Type t = Type.GetType(name);
        if (t == null && i > 0 && (j = typename.indexOf(44, i + 1)) > 0) {
            String assemName = typename.substring(i + 1, j);
            try {
                Assembly.LoadFrom(assemName);
            }
            catch (Throwable e) {
                throw new RuntimeException(typename, e);
            }
            t = Type.GetType(name);
        }
        assert (t != null) : typename;
        return t;
    }

    private boolean[] parseBooleanArray() {
        boolean[] arr = new boolean[this.buf.getInt()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.buf.get() != 0;
        }
        return arr;
    }

    private char[] parseCharArray() {
        char[] arr = new char[this.buf.getInt()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.buf.getChar();
        }
        return arr;
    }

    private byte[] parseByteArray() {
        byte[] arr = new byte[this.buf.getInt()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.buf.get();
        }
        return arr;
    }

    private short[] parseShortArray() {
        short[] arr = new short[this.buf.getInt()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.buf.getShort();
        }
        return arr;
    }

    private int[] parseIntArray() {
        int[] arr = new int[this.buf.getInt()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.buf.getInt();
        }
        return arr;
    }

    private long[] parseLongArray() {
        long[] arr = new long[this.buf.getInt()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.buf.getLong();
        }
        return arr;
    }

    private float[] parseFloatArray() {
        float[] arr = new float[this.buf.getInt()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.buf.getFloat();
        }
        return arr;
    }

    private double[] parseDoubleArray() {
        double[] arr = new double[this.buf.getInt()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.buf.getDouble();
        }
        return arr;
    }

    private String[] parseStringArray() {
        String[] arr = new String[this.buf.getInt()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.parseString();
        }
        return arr;
    }

    private String parseString() {
        String str = null;
        int length = this.parseLength();
        if (length < 0) {
            return null;
        }
        try {
            str = new String(this.value, this.buf.position(), length, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        this.buf.position(this.buf.position() + length);
        return str;
    }

    private int getByte() {
        return this.buf.get() + 256 & 0xFF;
    }

    public int parseLength() {
        int length = this.getByte();
        if ((length & 0xE0) == 224) {
            return -1;
        }
        if ((length & 0x80) != 0 && ((length = (length & 0x7F) << 8 | this.getByte()) & 0x4000) != 0) {
            length = (length & 0x3FFF) << 16 | this.getByte() << 8 | this.getByte();
        }
        return length;
    }

    private static void formatValue(StringBuffer str, Object o) {
        Class<?> c;
        Class<?> clazz = c = o == null ? null : o.getClass();
        if (c == null) {
            str.append("<null>");
        } else if (c == String.class) {
            str.append('\"');
            str.append(o);
            str.append('\"');
        } else if (c == Character.class) {
            str.append('\'');
            str.append(o);
            str.append('\'');
        } else if (c == boolean[].class) {
            str.append("new boolean[] {");
            boolean[] arr = (boolean[])o;
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    str.append(", ");
                }
                str.append(arr[i]);
            }
            str.append('}');
        } else if (c == char[].class) {
            str.append("new short[] {");
            short[] arr = (short[])o;
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    str.append(", ");
                }
                str.append(arr[i]);
            }
            str.append('}');
        } else if (c == byte[].class) {
            str.append("new byte[] {");
            byte[] arr = (byte[])o;
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    str.append(", ");
                }
                str.append(arr[i]);
            }
            str.append('}');
        } else if (c == short[].class) {
            str.append("new short[] {");
            short[] arr = (short[])o;
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    str.append(", ");
                }
                str.append(arr[i]);
            }
            str.append('}');
        } else if (c == int[].class) {
            str.append("new int[] {");
            int[] arr = (int[])o;
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    str.append(", ");
                }
                str.append(arr[i]);
            }
            str.append('}');
        } else if (c == long[].class) {
            str.append("new long[] {");
            long[] arr = (long[])o;
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    str.append(", ");
                }
                str.append(arr[i]);
            }
            str.append('}');
        } else if (c == float[].class) {
            str.append("new float[] {");
            float[] arr = (float[])o;
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    str.append(", ");
                }
                str.append(arr[i]);
            }
            str.append('}');
        } else if (c == double[].class) {
            str.append("new double[] {");
            double[] arr = (double[])o;
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    str.append(", ");
                }
                str.append(arr[i]);
            }
            str.append('}');
        } else if (c == String[].class) {
            str.append("new String[] {");
            String[] arr = (String[])o;
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    str.append(", ");
                }
                Attribute.formatValue(str, arr[i]);
            }
            str.append('}');
        } else if (o instanceof Type) {
            str.append("typeof(");
            str.append(o);
            str.append(")");
        } else {
            str.append(o);
        }
    }

    static {
        Attribute.map("Boolean", 2);
        Attribute.map("Char", 3);
        Attribute.map("SByte", 4);
        Attribute.map("Byte", 5);
        Attribute.map("Int16", 6);
        Attribute.map("UInt16", 7);
        Attribute.map("Int32", 8);
        Attribute.map("UInt32", 9);
        Attribute.map("Int64", 10);
        Attribute.map("UInt64", 11);
        Attribute.map("Single", 12);
        Attribute.map("Double", 13);
        Attribute.map("String", 14);
        Attribute.map("Type", 80);
        Attribute.map("Object", 28);
    }

    public static class BoxedArgument {
        public final Type type;
        public final Object value;

        public BoxedArgument(Type type, Object value) {
            this.type = type;
            this.value = value;
        }

        public String toString() {
            return "(" + this.type.FullName + ")" + this.value;
        }
    }

    public static class NamedArgument {
        public final int designator;
        public final String name;
        public final Type type;
        public final Object value;
        public static final NamedArgument[] EMPTY = new NamedArgument[0];

        public NamedArgument(int designator, String name, Type type, Object value) {
            this.designator = designator;
            this.name = name;
            this.type = type;
            this.value = value;
        }

        public boolean isField() {
            return this.designator == 83;
        }

        public boolean isProperty() {
            return this.designator == 84;
        }

        public String toString() {
            StringBuffer str = new StringBuffer(this.name);
            str.append(" = ");
            if (this.type.IsEnum()) {
                str.append('(').append(this.type.FullName).append(')');
            }
            Attribute.formatValue(str, this.value);
            return str.toString();
        }
    }
}

