package net.sf.saxon.charcode;


/*
Copyright (C) 2006 Hewlett-Packard Development Company, L.P.

The contents of this file are subject to the Mozilla Public License Version 1.1
(the "License"); you may not use this file except in compliance with the
License. You may obtain a copy of the License at http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: all this file
The Initial Developer of the Original Code is Lauren Ward. All Rights Reserved.
Contributor(s): Integrated into Saxon by Michael Kay. Removed code to perform dynamic
 initialization of the boolean array, replaced it with generated static data.
 
*************************
Author:
  Lauren Ward
Date:
  February 01, 2006
Address:
  Hewlett-Packard Company
  3404 East Harmony Road
  Fort Collins, CO 80528-9599
Revision:
  1.0 - Initial creation

Description: This class implements the PluggableCharacterSet to support
EUC-KR encoding.  The character mapping was obtained by extracting the
Unicode values from an iconv character table (eucKR=ucs2) available on HP-UX 11.23.

The class was tested by transforming numerous manuals and having localization engineers
review the output. The class was also tested by transforming a document with EUC-KR
set as the output encoding, converting EUC-KR output to utf-8 using iconv,
and then comparing converted content to the same transformed document with utf-8 set
as the output encoding.

*/

public class EucKRCharacterSet implements net.sf.saxon.charcode.PluggableCharacterSet {

    private static EucKRCharacterSet THE_INSTANCE = new EucKRCharacterSet();

    public static EucKRCharacterSet getInstance() {
        return THE_INSTANCE;
    }

    public static long[] flags = {
        0xffffffffffffffffL, 0xffffffffffffffffL, 0x49a0faefL, 0x200818302008182L,
        0x400003007081L, 0xe070300003000000L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x10000fc00000000L,
        0x0L, 0x0L, 0x7fffdfc07fffL, 0xdfc0000000000000L,
        0x4000ffffffffffffL, 0xffff400000000000L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x1accc600b010L, 0x801L, 0x7800000000000000L, 0x0L,
        0x1040120062100000L, 0x181effc0ffc0L, 0xffc000000000L, 0x280000000000L,
        0xb191402681fa0e04L, 0x2000cc000000L, 0x3300000004000000L, 0x0L,
        0x200000000000L, 0x0L, 0x0L, 0x0L,
        0x0L, 0xfffe0fffL, 0xe000000ffffffc00L, 0xffffffc00000L,
        0xf00fffffffffffffL, 0xfff0000000000000L, 0x2000dfc0330cL, 0xc3d3c00000000000L,
        0x603000a00000000L, 0xa0000000ddec0000L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0xf0ffdc0000000000L, 0x7fffffffffffffffL, 0xfffff0007fffffffL, 0xfffffffffffffe10L,
        0x7fffL, 0xffffffffffffffffL, 0xfffe000000000000L, 0x0L,
        0xfffffff800000000L, 0xfffffff1L, 0x0L, 0x0L,
        0x0L, 0x0L, 0xf8ffffffffffffffL, 0xffe1929c00000000L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0xd1f44ec2000420d0L, 0x341702c700141302L, 0x229aec926e9e0220L, 0xc9340fc51c00a310L,
        0x4077c00000010aacL, 0x1387c47800419223L, 0x5ab5429400030601L, 0x38625925c00354a0L,
        0x2254626b5bbc0010L, 0x11c1042804000e80L, 0x840440c0000c3502L, 0x461462205040051L,
        0xca40200140202128L, 0xdfde200825fe4788L, 0x8224250084280304L, 0xa5c000e4000c2e4L,
        0x93a241040c6283f0L, 0x113c0a1440612405L, 0x11c4601198700002L, 0x554426d7380014b3L,
        0x4858740d0210041L, 0xd9e4792a8281cd05L, 0x80010a186040010L, 0x10f40b107c7df080L,
        0x18efc015825010daL, 0x20a0400000a0541cL, 0x820a800008981084L, 0xc8c0000044862020L,
        0xb02800800014402L, 0xa01120210000008L, 0x8b6000ec017a0000L, 0x500082918000006L,
        0x240090000012a00L, 0x100000900800L, 0x2000000040a0808L, 0x24403280008060L,
        0x1894328100848010L, 0xa126c0004a228408L, 0x20901000b0000000L, 0x1192000180008968L,
        0xa6e000024921cc20L, 0x3149a26800044aL, 0x1440100b00c21032L, 0x450254c308190074L,
        0x10e6821764102L, 0x9c3cd20a13e1884L, 0x3820134004880052L, 0x1250d86c02aa0091L,
        0x5000409984400208L, 0x4240002022000000L, 0x203008000000L, 0x6848000042400000L,
        0x458020000200000L, 0x9000cdad1850c4a8L, 0x5d917f83e0a9ec1L, 0xbf08b9036fdb06a0L,
        0x49f74240088040fbL, 0x86964410ac094040L, 0xc000405855a2L, 0x8000004080818a14L,
        0x1064b4001400000L, 0x18800000490000L, 0x1100004a02000acL, 0x4220667927906L,
        0x3208425404141285L, 0x8d080401700039deL, 0x921052883140782L, 0x20e09231b0081330L,
        0x48215d9103404428L, 0xaa0350237cc149L, 0xc538e1c2c0e20544L, 0x140c03c080100405L,
        0x1220cc5a10000L, 0x7004a4443ced8000L, 0x44c0a319900ba8cL, 0x5004029c000d270L,
        0x42c704310100890bL, 0x29b814c539928306L, 0x6022c8e0095a2222L, 0x11f00000020023a9L,
        0x81aee2214022ca03L, 0xc1d4108000024249L, 0x886065900010444cL, 0x21cdbbd8000f5103L,
        0x4140400000110036L, 0x49840001822131L, 0x10c82290e5e00000L, 0x8a01823040060b00L,
        0x50b08200c0022L, 0x80804100e0L, 0x8070220c16a010L, 0x4d2628a067082822L,
        0x88000084103903d3L, 0x4874302320c2d82L, 0x3508c1594d19814cL, 0x4419210096cc483dL,
        0x36bdc038585ca30L, 0x785100570fd31ba0L, 0x9c2c384a0123852L, 0xb40024c8200b9ebL,
        0x90d40d1703be4a24L, 0x243d20b0005d513L, 0x151952c00019382L, 0x801f8240049de12L,
        0x3300602100ccL, 0xf082d80000040201L, 0x440119056185d600L, 0xc5425a181822060L,
        0x8406200001008005L, 0x201d62f09705c0L, 0x41805020810L, 0x501c800000a00015L,
        0x20205143500004e4L, 0x89030c140100000L, 0x8846010830001010L, 0x3000103000000210L,
        0x8282200d0002026L, 0x30a80017e202191L, 0x1a60028200032529L, 0x46153b9000180000L,
        0x81500010000982L, 0xe002852780a4a226L, 0x7788be70001210dfL, 0x6868151074939000L,
        0x184152056026d6L, 0x40000068126a09c1L, 0x5ce540000012400L, 0x9f1140e240b255f0L,
        0x171de1d2aaeL, 0x1824029b01133020L, 0x820d24314220L, 0x2c5a580000010883L,
        0x62014c00b0186081L, 0x400049b32806802eL, 0x4886890019035042L, 0xf0200421c8594002L,
        0x465144bf11810102L, 0x8c0841010808cL, 0x42220e0481d11c0L, 0x9100c500004044L,
        0x848006242008200L, 0x16a824a0f4a0004L, 0x861284120084062L, 0x50c2ac010706001bL,
        0x82008010002ca636L, 0x838820d561402044L, 0xc000000021090000L, 0xa8028140404000ccL,
        0x20021c04700303L, 0xc00a10000a0a4b0L, 0xb520b8101443040L, 0xa06d02469e640146L,
        0x57401010e6bb9ea1L, 0xd810057bace10002L, 0x3150008b55a0a445L, 0x22108a8b2020100L,
        0x480044b11698f1a0L, 0x109585c262186a1L, 0x3334004041074ceL, 0x25042cd02000a828L,
        0x80040041ea000010L, 0x200a22004848a09eL, 0xb02900000020021L, 0x32a0221b5902288aL,
        0x48d00002804001a8L, 0x8004001052100043L, 0x104002040c9019L, 0x11834471000L,
        0x2000200007082800L, 0x401000400190008L, 0x410e410011400038L, 0x4432800000890410L,
        0x4002020000380022L, 0xc1c0833e84840021L, 0x4007400003225047L, 0xc07064810b400010L,
        0x849409698002431dL, 0x8246010060508a65L, 0x4880348100630020L, 0xd30014594250261L,
        0x14052820c0040L, 0x25dea00800a0404L, 0x1110d2440044880L, 0xcb40200088400000L,
        0x100200241300007L, 0x100c000088081000L, 0x1040258105027042L, 0x20020381000012L,
        0xafb489f0e01b9460L, 0x3e00800262a27241L, 0x31008a00c6cb7L, 0x13002a6d0c90810L,
        0x60041750134106L, 0x53002c0240748048L, 0x2009129800000000L, 0x0L,
        0x2a0L, 0x88c000032a540L, 0x4aa082208c020c4L, 0x442a2c01c0508048L,
        0xd648858000041205L, 0x122002a20001b107L, 0xf58021464616820L, 0x180a00324c004884L,
        0x27a000b010510042L, 0x12cc000610c0e1L, 0x80a1002c90801427L, 0xa204008115a4183aL,
        0x5ac201b40380740L, 0x850000400a036282L, 0x162065064f51ddL, 0x6d1347004006L,
        0x7c40010000914ec0L, 0x8161600000001110L, 0x62028220700004L, 0x446812080051e844L,
        0x182e000000484084L, 0x40011052190420L, 0x884840002099L, 0xaa544020000a0808L,
        0x59a2540d0005L, 0x5042104010e40000L, 0x901481002e18020L, 0x4047040c0c600131L,
        0x2320032000040001L, 0x28c1b01000040L, 0x28100018400000L, 0x110085108040002L,
        0xb08000a800000000L, 0x2050102800a80L, 0x2004000120001020L, 0x800000080092052L,
        0x400000130004210L, 0x820c31547090a103L, 0x6094230200100800L, 0x60010c4d40801c84L,
        0x100b0c004200290L, 0x4800000108202001L, 0x5311120040602024L, 0x8000200010000880L,
        0xb0aa139514244a30L, 0x8c12b246f440L, 0x50c1482dea0a04bL, 0x29152218433643a2L,
        0xe8028b7480981040L, 0x404300a802098904L, 0x8020b22000000000L, 0x0L,
        0x101L, 0x42a8042040300060L, 0x20280006e1f99b9dL, 0xf9a0502aba24081cL,
        0xda4120000000000L, 0xa109900L, 0x420004010801022L, 0x219001450811000L,
        0x21800200208400L, 0x29e0004180000a00L, 0x4124000000380000L, 0x803c200100100092L,
        0x14403c1f036110d3L, 0xc46000520000000L, 0x181285e000L, 0x240248000234a144L,
        0xf695cd67f002648aL, 0x6136dc4ed04725adL, 0xf9a1444032a1c480L, 0x4020000240840404L,
        0x2000244001042000L, 0x7e200020680580L, 0x1542008001b4c00L, 0x815fc18c11200400L,
        0x4e10200000821L, 0x844001122e000000L, 0x9400528800001340L, 0x9200008200088L,
        0x80080a3ea930000L, 0xb408100002040aL, 0x80a20110c8000L, 0x1000400248000200L,
        0x800008004100480L, 0x800601000000005L, 0x0L, 0x0L,
        0x0L, 0x100L, 0x905178801c844018L, 0x1200e0860000000L,
        0x840222011L, 0xa81c801f38209784L, 0x6360cd811a04110L, 0xcf5e065830e1a350L,
        0x8300524a0100a044L, 0x2880420a60440920L, 0x15000080940000L, 0x210100800001211L,
        0xf6a8f180000480d0L, 0x20e08a205110000L, 0x814000L, 0x90000196007080eL,
        0x1068908280800000L, 0x45c690000000000L, 0x244048e5840L, 0x4000e44500044001L,
        0x4083004000108300L, 0x9404053124600000L, 0x800080L, 0x188004020000L,
        0x2001204008L, 0x7c01082000010000L, 0x2400100120000L, 0x40020008800000L,
        0x4a40004002010L, 0x140010000000000L, 0x0L, 0x5401a00L,
        0x40001002800010L, 0x4004c0082000L, 0x410800L, 0x8000100000020e0L,
        0x2200000000L, 0x445L, 0x310504000c12L, 0x1006489a00800800L,
        0x182100080000010L, 0x32200141280100L, 0x4840800000000L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0xc9e0ff7c880dc0c8L, 0x801408880000c9a0L, 0xde78880dc0e980dcL, 0x48880500c9a9d60cL,
        0x8a0d4088804c0c88L, 0xd408880500c9e1dL, 0x60c8800c08000100L, 0xc880d008880000c9L,
        0xc0d408000000c9a0L, 0xd62e8a0dc4c880dcL, 0xc0800000000000eL, 0x880dc0c800940888L,
        0x1848000000ca80dL, 0x70c0800c0c000040L, 0x8880c408000000c8L, 0x81d6080800c0c880L,
        0xc808880c00800000L, 0xcaa1d440000000cL, 0x880d40e9e0df5c88L, 0xdc0c88084000000L,
        0xd8b0dc1c880dc0L, 0xc880cc88800000c8L, 0xa0d4388800800000L, 0x8880d00c88054L,
        0xc980d4080000808L, 0x8880c00c08L, 0xc40c8e0d6288800L, 0xc8a0d42e9f1df1L,
        0xc880dc0800000000L, 0xe9b0d52c880L, 0xdc088800c0880000L, 0xc9a8d5488800008L,
        0x808880d00800L, 0xc880d4080000L, 0x8080000408880540L, 0x8880840c9a0d4080L,
        0xc980de0c880L, 0xdc1c880dc0000000L, 0xc8b0dc1cL, 0x880dc08000080000L,
        0xc88004080800L, 0x80000008800000L, 0xc88184000L, 0x80000008880L,
        0xc400000000c980d0L, 0x8880c008880d40cL, 0x880de3c880dc0c80L, 0x1400000000c880dL,
        0xc1c880d40c880dc0L, 0x8800500c880d4088L, 0x4000000808880L, 0xd408880540c880d4L,
        0x80000808000000cL, 0x880940c880d40c88L, 0xd660000000c880dL, 0x40cbe0d65c880de0L,
        0xc0800400000000c8L, 0xa0d61c880dc0c880L, 0x1d08000000d8a0d4L, 0x88000c000000008L,
        0x8805408880500e9eL, 0xd45888050080000L, 0x88800008880900L, 0x88809000000000c9L,
        0xa0dd4f9f0d44c880L, 0xdc4c800400000000L, 0xc9a0d60c980dc0cL, 0x8805c48800000e88L,
        0xd40880008080000L, 0x80c880c008800000L, 0xc9e0d46808008080L, 0xc8800408880L,
        0x940c880d00000000L, 0xc8a0d70c8a0dc1cL, 0x880dc0c000800000L, 0xc9809c080000L,
        0x40c000dc00000000L, 0xc880c40000000000L, 0x80000008000L, 0x40c880940000000L,
        0x8L, 0x408880c00000L, 0xc880d40d9e0dL, 0xc4c880dc0c880d40L,
        0x8880840f9b0dc2c8L, 0x80dc0c880dc08880L, 0x40e8a0d44c88004L, 0x88809808880d00cL,
        0x880d40c980d56800L, 0x80c880840c880dL, 0x40c080940c8c0d40L, 0xc981d42d8L,
        0x80cc1c880cc00000L, 0x400000000c8a0ccL, 0x888000000000000L, 0x800000c9a0c40c80L,
        0x8080000808880cL, 0x8000000c880c40L, 0x8000080800000088L, 0x40c8a1L,
        0xc008880800c880d4L, 0xcee1dc6c880dc0cL, 0x890d458880400cdeL, 0xfeac880d40e8b0fL,
        0xc78880d80c8e9d50L, 0xc880dc0c800940c8L, 0x80d40c880d40c8e0L, 0xd40c880cc0c880c4L,
        0xc880d40c880d50cL, 0x882d7f8880900c8eL, 0x1de2cba0de0c880dL, 0xc0ca808408880000L,
        0xc8a0d60c880d4088L, 0x80cc08000000c8a0L, 0xd71c08054080000cL, 0x8880d40c800040cL,
        0x8e0d408000080800L, 0xc880d0088808L, 0xc880d400000000L, 0xc9a0d66ca90dc0c8L,
        0x80dc088000400000L, 0xc880dc0800004L, 0x80000800000000cL, 0x880d50c080080800L,
        0x808880c0000000L, 0x40c880c4080000c0L, 0x800000080L, 0x80009400000L,
        0xc880c61ca80deL, 0xc880dc08a808400L, 0xc880dc0c88L, 0xd40880008088000L,
        0x40c880d408880040L, 0x8880d4080L, 0x800c880d408000L, 0x8088000008880d4L,
        0x8880840c880d400L, 0xc9c0d40c88L, 0xd40c880dc0c0000L, 0x400000000c980dc0L,
        0xc880d408880dc080L, 0xc880d40c880L, 0x8408000040808000L, 0x8000000c880d408L,
        0x8800408000040c88L, 0xd408880800c880cL, 0x400000000c880d40L, 0xc8c0dc0c880dc080L,
        0x400000000c8a0L, 0xdc0c880d40880008L, 0x8800000c880d428L, 0x8000008000000880L,
        0x1408000000c880dL, 0x4080000808000000L, 0xc880c408880840c9L, 0xa0d008880c00c880L,
        0xd40e8a0dc4c880dcL, 0xc0000000000000cL, 0x880dc0c880d40888L, 0xcc08080500c880dL,
        0x4080000400000000L, 0x88000008880500c9L, 0xa0d4080000400000L, 0x8880900888094L,
        0x8880d000000000cL, 0x880d40c884d40c88L, 0xdc0800004000000L, 0xc8a0d40c880d40L,
        0xc880dc08880400c8L, 0x84d44c880140c800L, 0x140c880540888050L, 0xc8849408880840cL,
        0x880040c880d40c88L, 0x940cbc0d448880cL, 0x40c880d400000000L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffffffffffffffL,
        0xfff0000000000000L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x0L, 0x0L, 0x0L, 0x0L,
        0x7fffffffffffffffL, 0xfffffffe00000000L, 0x0L, 0xf6000000L

    };

		// raqou and laquo symbol not handled correctly in browser
		// during testing if not numeric character reference */
		// c[187] = false;
		// c[171] = false;


	public EucKRCharacterSet() {

	}

	// Determine if it is a valid character
	public final boolean inCharset(int ch) {
        if (ch > 65535) {
            return false;
        }
        long g = flags[ch>>6];
        long h = (g>>(63 - (ch&0x3f))) & 1L;
        return h == 1L;
	}

	public final String getEncodingName() {
		// Canonical Name for java.io and java.lang API
		return "EUC_KR";
	}
}


