/* rygel-media-resource.c generated by valac 0.36.6, the Vala compiler
 * generated from rygel-media-resource.vala, do not modify */

/*
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;
typedef struct _RygelMediaResourcePrivate RygelMediaResourcePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _RygelMediaResource {
	GObject parent_instance;
	RygelMediaResourcePrivate * priv;
	gchar** play_speeds;
	gint play_speeds_length1;
};

struct _RygelMediaResourceClass {
	GObjectClass parent_class;
};

struct _RygelMediaResourcePrivate {
	gchar* name;
	gchar* _uri;
	gchar* _import_uri;
	gchar* _extension;
	gint64 _size;
	gint64 _cleartext_size;
	glong _duration;
	gint _bitrate;
	gint _bits_per_sample;
	gint _color_depth;
	gint _width;
	gint _height;
	gint _audio_channels;
	gint _sample_freq;
	gchar* _protocol;
	gchar* _mime_type;
	gchar* _dlna_profile;
	gchar* _network;
	GUPnPDLNAConversion _dlna_conversion;
	GUPnPDLNAFlags _dlna_flags;
	GUPnPDLNAOperation _dlna_operation;
};


static gpointer rygel_media_resource_parent_class = NULL;

GType rygel_media_resource_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_RESOURCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourcePrivate))
enum  {
	RYGEL_MEDIA_RESOURCE_DUMMY_PROPERTY,
	RYGEL_MEDIA_RESOURCE_URI_PROPERTY,
	RYGEL_MEDIA_RESOURCE_IMPORT_URI_PROPERTY,
	RYGEL_MEDIA_RESOURCE_EXTENSION_PROPERTY,
	RYGEL_MEDIA_RESOURCE_SIZE_PROPERTY,
	RYGEL_MEDIA_RESOURCE_CLEARTEXT_SIZE_PROPERTY,
	RYGEL_MEDIA_RESOURCE_DURATION_PROPERTY,
	RYGEL_MEDIA_RESOURCE_BITRATE_PROPERTY,
	RYGEL_MEDIA_RESOURCE_BITS_PER_SAMPLE_PROPERTY,
	RYGEL_MEDIA_RESOURCE_COLOR_DEPTH_PROPERTY,
	RYGEL_MEDIA_RESOURCE_WIDTH_PROPERTY,
	RYGEL_MEDIA_RESOURCE_HEIGHT_PROPERTY,
	RYGEL_MEDIA_RESOURCE_AUDIO_CHANNELS_PROPERTY,
	RYGEL_MEDIA_RESOURCE_SAMPLE_FREQ_PROPERTY,
	RYGEL_MEDIA_RESOURCE_PROTOCOL_PROPERTY,
	RYGEL_MEDIA_RESOURCE_MIME_TYPE_PROPERTY,
	RYGEL_MEDIA_RESOURCE_DLNA_PROFILE_PROPERTY,
	RYGEL_MEDIA_RESOURCE_NETWORK_PROPERTY,
	RYGEL_MEDIA_RESOURCE_DLNA_CONVERSION_PROPERTY,
	RYGEL_MEDIA_RESOURCE_DLNA_FLAGS_PROPERTY,
	RYGEL_MEDIA_RESOURCE_DLNA_OPERATION_PROPERTY
};
RygelMediaResource* rygel_media_resource_new (const gchar* name);
RygelMediaResource* rygel_media_resource_construct (GType object_type, const gchar* name);
RygelMediaResource* rygel_media_resource_new_from_resource (const gchar* name, RygelMediaResource* that);
RygelMediaResource* rygel_media_resource_construct_from_resource (GType object_type, const gchar* name, RygelMediaResource* that);
const gchar* rygel_media_resource_get_uri (RygelMediaResource* self);
void rygel_media_resource_set_uri (RygelMediaResource* self, const gchar* value);
const gchar* rygel_media_resource_get_import_uri (RygelMediaResource* self);
void rygel_media_resource_set_import_uri (RygelMediaResource* self, const gchar* value);
const gchar* rygel_media_resource_get_extension (RygelMediaResource* self);
void rygel_media_resource_set_extension (RygelMediaResource* self, const gchar* value);
gint64 rygel_media_resource_get_size (RygelMediaResource* self);
void rygel_media_resource_set_size (RygelMediaResource* self, gint64 value);
gint64 rygel_media_resource_get_cleartext_size (RygelMediaResource* self);
void rygel_media_resource_set_cleartext_size (RygelMediaResource* self, gint64 value);
glong rygel_media_resource_get_duration (RygelMediaResource* self);
void rygel_media_resource_set_duration (RygelMediaResource* self, glong value);
gint rygel_media_resource_get_bitrate (RygelMediaResource* self);
void rygel_media_resource_set_bitrate (RygelMediaResource* self, gint value);
gint rygel_media_resource_get_bits_per_sample (RygelMediaResource* self);
void rygel_media_resource_set_bits_per_sample (RygelMediaResource* self, gint value);
gint rygel_media_resource_get_color_depth (RygelMediaResource* self);
void rygel_media_resource_set_color_depth (RygelMediaResource* self, gint value);
gint rygel_media_resource_get_width (RygelMediaResource* self);
void rygel_media_resource_set_width (RygelMediaResource* self, gint value);
gint rygel_media_resource_get_height (RygelMediaResource* self);
void rygel_media_resource_set_height (RygelMediaResource* self, gint value);
gint rygel_media_resource_get_audio_channels (RygelMediaResource* self);
void rygel_media_resource_set_audio_channels (RygelMediaResource* self, gint value);
gint rygel_media_resource_get_sample_freq (RygelMediaResource* self);
void rygel_media_resource_set_sample_freq (RygelMediaResource* self, gint value);
const gchar* rygel_media_resource_get_protocol (RygelMediaResource* self);
void rygel_media_resource_set_protocol (RygelMediaResource* self, const gchar* value);
const gchar* rygel_media_resource_get_mime_type (RygelMediaResource* self);
void rygel_media_resource_set_mime_type (RygelMediaResource* self, const gchar* value);
const gchar* rygel_media_resource_get_dlna_profile (RygelMediaResource* self);
void rygel_media_resource_set_dlna_profile (RygelMediaResource* self, const gchar* value);
const gchar* rygel_media_resource_get_network (RygelMediaResource* self);
void rygel_media_resource_set_network (RygelMediaResource* self, const gchar* value);
static gchar** _vala_array_dup2 (gchar** self, int length);
GUPnPDLNAConversion rygel_media_resource_get_dlna_conversion (RygelMediaResource* self);
void rygel_media_resource_set_dlna_conversion (RygelMediaResource* self, GUPnPDLNAConversion value);
GUPnPDLNAFlags rygel_media_resource_get_dlna_flags (RygelMediaResource* self);
void rygel_media_resource_set_dlna_flags (RygelMediaResource* self, GUPnPDLNAFlags value);
GUPnPDLNAOperation rygel_media_resource_get_dlna_operation (RygelMediaResource* self);
void rygel_media_resource_set_dlna_operation (RygelMediaResource* self, GUPnPDLNAOperation value);
RygelMediaResource* rygel_media_resource_new_from_didl_lite_resource (const gchar* name, GUPnPDIDLLiteResource* didl_resource);
RygelMediaResource* rygel_media_resource_construct_from_didl_lite_resource (GType object_type, const gchar* name, GUPnPDIDLLiteResource* didl_resource);
static gchar** _vala_array_dup3 (gchar** self, int length);
RygelMediaResource* rygel_media_resource_dup (RygelMediaResource* self);
gchar* rygel_media_resource_get_name (RygelMediaResource* self);
GUPnPDIDLLiteResource* rygel_media_resource_serialize (RygelMediaResource* self, GUPnPDIDLLiteResource* didl_resource, GHashTable* replacements);
gchar* rygel_media_object_apply_replacements (GHashTable* replacement_pairs, const gchar* source_string);
GUPnPProtocolInfo* rygel_media_resource_get_protocol_info (RygelMediaResource* self, GHashTable* replacements);
void rygel_media_resource_set_protocol_info (RygelMediaResource* self, GUPnPProtocolInfo* pi);
static gchar** _vala_array_dup4 (gchar** self, int length);
gboolean rygel_media_resource_supports_arbitrary_byte_seek (RygelMediaResource* self);
gboolean rygel_media_resource_is_dlna_operation_mode_set (RygelMediaResource* self, glong flags);
gboolean rygel_media_resource_supports_arbitrary_time_seek (RygelMediaResource* self);
gboolean rygel_media_resource_supports_limited_byte_seek (RygelMediaResource* self);
gboolean rygel_media_resource_is_dlna_protocol_flag_set (RygelMediaResource* self, glong flags);
gboolean rygel_media_resource_supports_limited_time_seek (RygelMediaResource* self);
gboolean rygel_media_resource_supports_limited_cleartext_byte_seek (RygelMediaResource* self);
gboolean rygel_media_resource_supports_full_cleartext_byte_seek (RygelMediaResource* self);
gboolean rygel_media_resource_is_link_protection_enabled (RygelMediaResource* self);
gboolean rygel_media_resource_is_dlna_content (RygelMediaResource* self);
gchar* rygel_media_resource_get_default_transfer_mode (RygelMediaResource* self);
gboolean rygel_media_resource_supports_transfer_mode (RygelMediaResource* self, const gchar* transfer_mode);
gboolean rygel_media_resource_is_streamable (RygelMediaResource* self);
gboolean rygel_media_resource_is_cleartext_range_support_enabled (RygelMediaResource* self);
gboolean rygel_media_resource_supports_playspeed (RygelMediaResource* self);
gchar* rygel_media_resource_to_string (RygelMediaResource* self);
static void rygel_media_resource_finalize (GObject * obj);
static void _vala_rygel_media_resource_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_resource_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


RygelMediaResource* rygel_media_resource_construct (GType object_type, const gchar* name) {
	RygelMediaResource * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (RygelMediaResource*) g_object_new (object_type, NULL);
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp1_;
	return self;
}


RygelMediaResource* rygel_media_resource_new (const gchar* name) {
	return rygel_media_resource_construct (RYGEL_TYPE_MEDIA_RESOURCE, name);
}


/**
     * Copy constructor
     */
static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


RygelMediaResource* rygel_media_resource_construct_from_resource (GType object_type, const gchar* name, RygelMediaResource* that) {
	RygelMediaResource * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	RygelMediaResource* _tmp2_;
	const gchar* _tmp3_;
	RygelMediaResource* _tmp4_;
	const gchar* _tmp5_;
	RygelMediaResource* _tmp6_;
	const gchar* _tmp7_;
	RygelMediaResource* _tmp8_;
	gint64 _tmp9_;
	RygelMediaResource* _tmp10_;
	gint64 _tmp11_;
	RygelMediaResource* _tmp12_;
	glong _tmp13_;
	RygelMediaResource* _tmp14_;
	gint _tmp15_;
	RygelMediaResource* _tmp16_;
	gint _tmp17_;
	RygelMediaResource* _tmp18_;
	gint _tmp19_;
	RygelMediaResource* _tmp20_;
	gint _tmp21_;
	RygelMediaResource* _tmp22_;
	gint _tmp23_;
	RygelMediaResource* _tmp24_;
	gint _tmp25_;
	RygelMediaResource* _tmp26_;
	gint _tmp27_;
	RygelMediaResource* _tmp28_;
	const gchar* _tmp29_;
	RygelMediaResource* _tmp30_;
	const gchar* _tmp31_;
	RygelMediaResource* _tmp32_;
	const gchar* _tmp33_;
	RygelMediaResource* _tmp34_;
	const gchar* _tmp35_;
	RygelMediaResource* _tmp36_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	gchar** _tmp38_;
	gint _tmp38__length1;
	RygelMediaResource* _tmp39_;
	GUPnPDLNAConversion _tmp40_;
	RygelMediaResource* _tmp41_;
	GUPnPDLNAFlags _tmp42_;
	RygelMediaResource* _tmp43_;
	GUPnPDLNAOperation _tmp44_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (that != NULL, NULL);
	self = (RygelMediaResource*) g_object_new (object_type, NULL);
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp1_;
	_tmp2_ = that;
	_tmp3_ = _tmp2_->priv->_uri;
	rygel_media_resource_set_uri (self, _tmp3_);
	_tmp4_ = that;
	_tmp5_ = _tmp4_->priv->_import_uri;
	rygel_media_resource_set_import_uri (self, _tmp5_);
	_tmp6_ = that;
	_tmp7_ = _tmp6_->priv->_extension;
	rygel_media_resource_set_extension (self, _tmp7_);
	_tmp8_ = that;
	_tmp9_ = _tmp8_->priv->_size;
	rygel_media_resource_set_size (self, _tmp9_);
	_tmp10_ = that;
	_tmp11_ = _tmp10_->priv->_cleartext_size;
	rygel_media_resource_set_cleartext_size (self, _tmp11_);
	_tmp12_ = that;
	_tmp13_ = _tmp12_->priv->_duration;
	rygel_media_resource_set_duration (self, _tmp13_);
	_tmp14_ = that;
	_tmp15_ = _tmp14_->priv->_bitrate;
	rygel_media_resource_set_bitrate (self, _tmp15_);
	_tmp16_ = that;
	_tmp17_ = _tmp16_->priv->_bits_per_sample;
	rygel_media_resource_set_bits_per_sample (self, _tmp17_);
	_tmp18_ = that;
	_tmp19_ = _tmp18_->priv->_color_depth;
	rygel_media_resource_set_color_depth (self, _tmp19_);
	_tmp20_ = that;
	_tmp21_ = _tmp20_->priv->_width;
	rygel_media_resource_set_width (self, _tmp21_);
	_tmp22_ = that;
	_tmp23_ = _tmp22_->priv->_height;
	rygel_media_resource_set_height (self, _tmp23_);
	_tmp24_ = that;
	_tmp25_ = _tmp24_->priv->_audio_channels;
	rygel_media_resource_set_audio_channels (self, _tmp25_);
	_tmp26_ = that;
	_tmp27_ = _tmp26_->priv->_sample_freq;
	rygel_media_resource_set_sample_freq (self, _tmp27_);
	_tmp28_ = that;
	_tmp29_ = _tmp28_->priv->_protocol;
	rygel_media_resource_set_protocol (self, _tmp29_);
	_tmp30_ = that;
	_tmp31_ = _tmp30_->priv->_mime_type;
	rygel_media_resource_set_mime_type (self, _tmp31_);
	_tmp32_ = that;
	_tmp33_ = _tmp32_->priv->_dlna_profile;
	rygel_media_resource_set_dlna_profile (self, _tmp33_);
	_tmp34_ = that;
	_tmp35_ = _tmp34_->priv->_network;
	rygel_media_resource_set_network (self, _tmp35_);
	_tmp36_ = that;
	_tmp37_ = _tmp36_->play_speeds;
	_tmp37__length1 = _tmp36_->play_speeds_length1;
	_tmp38_ = (_tmp37_ != NULL) ? _vala_array_dup2 (_tmp37_, _tmp37__length1) : ((gpointer) _tmp37_);
	_tmp38__length1 = _tmp37__length1;
	self->play_speeds = (_vala_array_free (self->play_speeds, self->play_speeds_length1, (GDestroyNotify) g_free), NULL);
	self->play_speeds = _tmp38_;
	self->play_speeds_length1 = _tmp38__length1;
	_tmp39_ = that;
	_tmp40_ = _tmp39_->priv->_dlna_conversion;
	rygel_media_resource_set_dlna_conversion (self, _tmp40_);
	_tmp41_ = that;
	_tmp42_ = _tmp41_->priv->_dlna_flags;
	rygel_media_resource_set_dlna_flags (self, _tmp42_);
	_tmp43_ = that;
	_tmp44_ = _tmp43_->priv->_dlna_operation;
	rygel_media_resource_set_dlna_operation (self, _tmp44_);
	return self;
}


RygelMediaResource* rygel_media_resource_new_from_resource (const gchar* name, RygelMediaResource* that) {
	return rygel_media_resource_construct_from_resource (RYGEL_TYPE_MEDIA_RESOURCE, name, that);
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


RygelMediaResource* rygel_media_resource_construct_from_didl_lite_resource (GType object_type, const gchar* name, GUPnPDIDLLiteResource* didl_resource) {
	RygelMediaResource * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GUPnPDIDLLiteResource* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GUPnPDIDLLiteResource* _tmp5_;
	gint64 _tmp6_;
	gint64 _tmp7_;
	GUPnPDIDLLiteResource* _tmp8_;
	gint64 _tmp9_;
	gint64 _tmp10_;
	GUPnPDIDLLiteResource* _tmp11_;
	glong _tmp12_;
	glong _tmp13_;
	GUPnPDIDLLiteResource* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GUPnPDIDLLiteResource* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	GUPnPDIDLLiteResource* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GUPnPDIDLLiteResource* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GUPnPDIDLLiteResource* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	GUPnPDIDLLiteResource* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	GUPnPDIDLLiteResource* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	GUPnPDIDLLiteResource* _tmp35_;
	GUPnPProtocolInfo* _tmp36_;
	GUPnPProtocolInfo* _tmp37_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (didl_resource != NULL, NULL);
	self = (RygelMediaResource*) g_object_new (object_type, NULL);
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp1_;
	_tmp2_ = didl_resource;
	_tmp3_ = gupnp_didl_lite_resource_get_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	rygel_media_resource_set_uri (self, _tmp4_);
	_tmp5_ = didl_resource;
	_tmp6_ = gupnp_didl_lite_resource_get_size64 (_tmp5_);
	_tmp7_ = _tmp6_;
	rygel_media_resource_set_size (self, _tmp7_);
	_tmp8_ = didl_resource;
	_tmp9_ = gupnp_didl_lite_resource_get_cleartext_size (_tmp8_);
	_tmp10_ = _tmp9_;
	rygel_media_resource_set_cleartext_size (self, _tmp10_);
	_tmp11_ = didl_resource;
	_tmp12_ = gupnp_didl_lite_resource_get_duration (_tmp11_);
	_tmp13_ = _tmp12_;
	rygel_media_resource_set_duration (self, _tmp13_);
	_tmp14_ = didl_resource;
	_tmp15_ = gupnp_didl_lite_resource_get_bitrate (_tmp14_);
	_tmp16_ = _tmp15_;
	rygel_media_resource_set_bitrate (self, _tmp16_);
	_tmp17_ = didl_resource;
	_tmp18_ = gupnp_didl_lite_resource_get_bits_per_sample (_tmp17_);
	_tmp19_ = _tmp18_;
	rygel_media_resource_set_bits_per_sample (self, _tmp19_);
	_tmp20_ = didl_resource;
	_tmp21_ = gupnp_didl_lite_resource_get_color_depth (_tmp20_);
	_tmp22_ = _tmp21_;
	rygel_media_resource_set_color_depth (self, _tmp22_);
	_tmp23_ = didl_resource;
	_tmp24_ = gupnp_didl_lite_resource_get_width (_tmp23_);
	_tmp25_ = _tmp24_;
	rygel_media_resource_set_width (self, _tmp25_);
	_tmp26_ = didl_resource;
	_tmp27_ = gupnp_didl_lite_resource_get_height (_tmp26_);
	_tmp28_ = _tmp27_;
	rygel_media_resource_set_height (self, _tmp28_);
	_tmp29_ = didl_resource;
	_tmp30_ = gupnp_didl_lite_resource_get_audio_channels (_tmp29_);
	_tmp31_ = _tmp30_;
	rygel_media_resource_set_audio_channels (self, _tmp31_);
	_tmp32_ = didl_resource;
	_tmp33_ = gupnp_didl_lite_resource_get_sample_freq (_tmp32_);
	_tmp34_ = _tmp33_;
	rygel_media_resource_set_sample_freq (self, _tmp34_);
	_tmp35_ = didl_resource;
	_tmp36_ = gupnp_didl_lite_resource_get_protocol_info (_tmp35_);
	_tmp37_ = _tmp36_;
	if (_tmp37_ != NULL) {
		GUPnPDIDLLiteResource* _tmp38_;
		GUPnPProtocolInfo* _tmp39_;
		GUPnPProtocolInfo* _tmp40_;
		const gchar* _tmp41_;
		const gchar* _tmp42_;
		GUPnPDIDLLiteResource* _tmp43_;
		GUPnPProtocolInfo* _tmp44_;
		GUPnPProtocolInfo* _tmp45_;
		const gchar* _tmp46_;
		const gchar* _tmp47_;
		GUPnPDIDLLiteResource* _tmp48_;
		GUPnPProtocolInfo* _tmp49_;
		GUPnPProtocolInfo* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		GUPnPDIDLLiteResource* _tmp53_;
		GUPnPProtocolInfo* _tmp54_;
		GUPnPProtocolInfo* _tmp55_;
		const gchar* _tmp56_;
		const gchar* _tmp57_;
		GUPnPDIDLLiteResource* _tmp58_;
		GUPnPProtocolInfo* _tmp59_;
		GUPnPProtocolInfo* _tmp60_;
		gchar** _tmp61_;
		gint _tmp61__length1;
		gchar** _tmp62_;
		gint _tmp62__length1;
		gchar** _tmp63_;
		gint _tmp63__length1;
		GUPnPDIDLLiteResource* _tmp64_;
		GUPnPProtocolInfo* _tmp65_;
		GUPnPProtocolInfo* _tmp66_;
		GUPnPDLNAConversion _tmp67_;
		GUPnPDLNAConversion _tmp68_;
		GUPnPDIDLLiteResource* _tmp69_;
		GUPnPProtocolInfo* _tmp70_;
		GUPnPProtocolInfo* _tmp71_;
		GUPnPDLNAFlags _tmp72_;
		GUPnPDLNAFlags _tmp73_;
		GUPnPDIDLLiteResource* _tmp74_;
		GUPnPProtocolInfo* _tmp75_;
		GUPnPProtocolInfo* _tmp76_;
		GUPnPDLNAOperation _tmp77_;
		GUPnPDLNAOperation _tmp78_;
		_tmp38_ = didl_resource;
		_tmp39_ = gupnp_didl_lite_resource_get_protocol_info (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = gupnp_protocol_info_get_protocol (_tmp40_);
		_tmp42_ = _tmp41_;
		rygel_media_resource_set_protocol (self, _tmp42_);
		_tmp43_ = didl_resource;
		_tmp44_ = gupnp_didl_lite_resource_get_protocol_info (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = gupnp_protocol_info_get_mime_type (_tmp45_);
		_tmp47_ = _tmp46_;
		rygel_media_resource_set_mime_type (self, _tmp47_);
		_tmp48_ = didl_resource;
		_tmp49_ = gupnp_didl_lite_resource_get_protocol_info (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = gupnp_protocol_info_get_dlna_profile (_tmp50_);
		_tmp52_ = _tmp51_;
		rygel_media_resource_set_dlna_profile (self, _tmp52_);
		_tmp53_ = didl_resource;
		_tmp54_ = gupnp_didl_lite_resource_get_protocol_info (_tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = gupnp_protocol_info_get_network (_tmp55_);
		_tmp57_ = _tmp56_;
		rygel_media_resource_set_network (self, _tmp57_);
		_tmp58_ = didl_resource;
		_tmp59_ = gupnp_didl_lite_resource_get_protocol_info (_tmp58_);
		_tmp60_ = _tmp59_;
		_tmp61_ = gupnp_protocol_info_get_play_speeds (_tmp60_);
		_tmp61__length1 = _vala_array_length (_tmp61_);
		_tmp62_ = _tmp61_;
		_tmp62__length1 = _tmp61__length1;
		_tmp63_ = (_tmp62_ != NULL) ? _vala_array_dup3 (_tmp62_, _tmp62__length1) : ((gpointer) _tmp62_);
		_tmp63__length1 = _tmp62__length1;
		self->play_speeds = (_vala_array_free (self->play_speeds, self->play_speeds_length1, (GDestroyNotify) g_free), NULL);
		self->play_speeds = _tmp63_;
		self->play_speeds_length1 = _tmp63__length1;
		_tmp64_ = didl_resource;
		_tmp65_ = gupnp_didl_lite_resource_get_protocol_info (_tmp64_);
		_tmp66_ = _tmp65_;
		_tmp67_ = gupnp_protocol_info_get_dlna_conversion (_tmp66_);
		_tmp68_ = _tmp67_;
		rygel_media_resource_set_dlna_conversion (self, _tmp68_);
		_tmp69_ = didl_resource;
		_tmp70_ = gupnp_didl_lite_resource_get_protocol_info (_tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = gupnp_protocol_info_get_dlna_flags (_tmp71_);
		_tmp73_ = _tmp72_;
		rygel_media_resource_set_dlna_flags (self, _tmp73_);
		_tmp74_ = didl_resource;
		_tmp75_ = gupnp_didl_lite_resource_get_protocol_info (_tmp74_);
		_tmp76_ = _tmp75_;
		_tmp77_ = gupnp_protocol_info_get_dlna_operation (_tmp76_);
		_tmp78_ = _tmp77_;
		rygel_media_resource_set_dlna_operation (self, _tmp78_);
	}
	return self;
}


RygelMediaResource* rygel_media_resource_new_from_didl_lite_resource (const gchar* name, GUPnPDIDLLiteResource* didl_resource) {
	return rygel_media_resource_construct_from_didl_lite_resource (RYGEL_TYPE_MEDIA_RESOURCE, name, didl_resource);
}


RygelMediaResource* rygel_media_resource_dup (RygelMediaResource* self) {
	RygelMediaResource* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	RygelMediaResource* _tmp2_;
	RygelMediaResource* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_media_resource_get_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = rygel_media_resource_new_from_resource (_tmp1_, self);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}


gchar* rygel_media_resource_get_name (RygelMediaResource* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GUPnPDIDLLiteResource* rygel_media_resource_serialize (RygelMediaResource* self, GUPnPDIDLLiteResource* didl_resource, GHashTable* replacements) {
	GUPnPDIDLLiteResource* result = NULL;
	GHashTable* _tmp0_;
	GUPnPDIDLLiteResource* _tmp17_;
	gint64 _tmp18_;
	GUPnPDIDLLiteResource* _tmp19_;
	gint64 _tmp20_;
	GUPnPDIDLLiteResource* _tmp21_;
	glong _tmp22_;
	GUPnPDIDLLiteResource* _tmp23_;
	gint _tmp24_;
	GUPnPDIDLLiteResource* _tmp25_;
	gint _tmp26_;
	GUPnPDIDLLiteResource* _tmp27_;
	gint _tmp28_;
	GUPnPDIDLLiteResource* _tmp29_;
	gint _tmp30_;
	GUPnPDIDLLiteResource* _tmp31_;
	gint _tmp32_;
	GUPnPDIDLLiteResource* _tmp33_;
	gint _tmp34_;
	GUPnPDIDLLiteResource* _tmp35_;
	gint _tmp36_;
	GUPnPDIDLLiteResource* _tmp37_;
	GUPnPProtocolInfo* _tmp38_;
	GUPnPProtocolInfo* _tmp39_;
	GUPnPDIDLLiteResource* _tmp40_;
	GUPnPDIDLLiteResource* _tmp41_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (didl_resource != NULL, NULL);
	_tmp0_ = replacements;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->_import_uri;
		if (_tmp1_ != NULL) {
			GUPnPDIDLLiteResource* _tmp2_;
			const gchar* _tmp3_;
			_tmp2_ = didl_resource;
			_tmp3_ = self->priv->_import_uri;
			gupnp_didl_lite_resource_set_import_uri (_tmp2_, _tmp3_);
		} else {
			GUPnPDIDLLiteResource* _tmp4_;
			const gchar* _tmp5_;
			_tmp4_ = didl_resource;
			_tmp5_ = self->priv->_uri;
			gupnp_didl_lite_resource_set_uri (_tmp4_, _tmp5_);
		}
	} else {
		const gchar* _tmp6_;
		_tmp6_ = self->priv->_import_uri;
		if (_tmp6_ != NULL) {
			GUPnPDIDLLiteResource* _tmp7_;
			GHashTable* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp7_ = didl_resource;
			_tmp8_ = replacements;
			_tmp9_ = self->priv->_import_uri;
			_tmp10_ = rygel_media_object_apply_replacements (_tmp8_, _tmp9_);
			_tmp11_ = _tmp10_;
			gupnp_didl_lite_resource_set_import_uri (_tmp7_, _tmp11_);
			_g_free0 (_tmp11_);
		} else {
			GUPnPDIDLLiteResource* _tmp12_;
			GHashTable* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp12_ = didl_resource;
			_tmp13_ = replacements;
			_tmp14_ = self->priv->_uri;
			_tmp15_ = rygel_media_object_apply_replacements (_tmp13_, _tmp14_);
			_tmp16_ = _tmp15_;
			gupnp_didl_lite_resource_set_uri (_tmp12_, _tmp16_);
			_g_free0 (_tmp16_);
		}
	}
	_tmp17_ = didl_resource;
	_tmp18_ = self->priv->_size;
	gupnp_didl_lite_resource_set_size64 (_tmp17_, _tmp18_);
	_tmp19_ = didl_resource;
	_tmp20_ = self->priv->_cleartext_size;
	gupnp_didl_lite_resource_set_cleartext_size (_tmp19_, _tmp20_);
	_tmp21_ = didl_resource;
	_tmp22_ = self->priv->_duration;
	gupnp_didl_lite_resource_set_duration (_tmp21_, _tmp22_);
	_tmp23_ = didl_resource;
	_tmp24_ = self->priv->_bitrate;
	gupnp_didl_lite_resource_set_bitrate (_tmp23_, _tmp24_);
	_tmp25_ = didl_resource;
	_tmp26_ = self->priv->_bits_per_sample;
	gupnp_didl_lite_resource_set_bits_per_sample (_tmp25_, _tmp26_);
	_tmp27_ = didl_resource;
	_tmp28_ = self->priv->_color_depth;
	gupnp_didl_lite_resource_set_color_depth (_tmp27_, _tmp28_);
	_tmp29_ = didl_resource;
	_tmp30_ = self->priv->_width;
	gupnp_didl_lite_resource_set_width (_tmp29_, _tmp30_);
	_tmp31_ = didl_resource;
	_tmp32_ = self->priv->_height;
	gupnp_didl_lite_resource_set_height (_tmp31_, _tmp32_);
	_tmp33_ = didl_resource;
	_tmp34_ = self->priv->_audio_channels;
	gupnp_didl_lite_resource_set_audio_channels (_tmp33_, _tmp34_);
	_tmp35_ = didl_resource;
	_tmp36_ = self->priv->_sample_freq;
	gupnp_didl_lite_resource_set_sample_freq (_tmp35_, _tmp36_);
	_tmp37_ = didl_resource;
	_tmp38_ = rygel_media_resource_get_protocol_info (self, NULL);
	_tmp39_ = _tmp38_;
	gupnp_didl_lite_resource_set_protocol_info (_tmp37_, _tmp39_);
	_g_object_unref0 (_tmp39_);
	_tmp40_ = didl_resource;
	_tmp41_ = _g_object_ref0 (_tmp40_);
	result = _tmp41_;
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void rygel_media_resource_set_protocol_info (RygelMediaResource* self, GUPnPProtocolInfo* pi) {
	GUPnPProtocolInfo* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GUPnPProtocolInfo* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GUPnPProtocolInfo* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GUPnPProtocolInfo* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GUPnPProtocolInfo* _tmp12_;
	GUPnPDLNAConversion _tmp13_;
	GUPnPDLNAConversion _tmp14_;
	GUPnPProtocolInfo* _tmp15_;
	GUPnPDLNAOperation _tmp16_;
	GUPnPDLNAOperation _tmp17_;
	GUPnPProtocolInfo* _tmp18_;
	GUPnPDLNAFlags _tmp19_;
	GUPnPDLNAFlags _tmp20_;
	GUPnPProtocolInfo* _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gchar** _tmp24_;
	gint _tmp24__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pi != NULL);
	_tmp0_ = pi;
	_tmp1_ = gupnp_protocol_info_get_protocol (_tmp0_);
	_tmp2_ = _tmp1_;
	rygel_media_resource_set_protocol (self, _tmp2_);
	_tmp3_ = pi;
	_tmp4_ = gupnp_protocol_info_get_network (_tmp3_);
	_tmp5_ = _tmp4_;
	rygel_media_resource_set_network (self, _tmp5_);
	_tmp6_ = pi;
	_tmp7_ = gupnp_protocol_info_get_mime_type (_tmp6_);
	_tmp8_ = _tmp7_;
	rygel_media_resource_set_mime_type (self, _tmp8_);
	_tmp9_ = pi;
	_tmp10_ = gupnp_protocol_info_get_dlna_profile (_tmp9_);
	_tmp11_ = _tmp10_;
	rygel_media_resource_set_dlna_profile (self, _tmp11_);
	_tmp12_ = pi;
	_tmp13_ = gupnp_protocol_info_get_dlna_conversion (_tmp12_);
	_tmp14_ = _tmp13_;
	rygel_media_resource_set_dlna_conversion (self, _tmp14_);
	_tmp15_ = pi;
	_tmp16_ = gupnp_protocol_info_get_dlna_operation (_tmp15_);
	_tmp17_ = _tmp16_;
	rygel_media_resource_set_dlna_operation (self, _tmp17_);
	_tmp18_ = pi;
	_tmp19_ = gupnp_protocol_info_get_dlna_flags (_tmp18_);
	_tmp20_ = _tmp19_;
	rygel_media_resource_set_dlna_flags (self, _tmp20_);
	_tmp21_ = pi;
	_tmp22_ = gupnp_protocol_info_get_play_speeds (_tmp21_);
	_tmp22__length1 = _vala_array_length (_tmp22_);
	_tmp23_ = _tmp22_;
	_tmp23__length1 = _tmp22__length1;
	_tmp24_ = (_tmp23_ != NULL) ? _vala_array_dup4 (_tmp23_, _tmp23__length1) : ((gpointer) _tmp23_);
	_tmp24__length1 = _tmp23__length1;
	self->play_speeds = (_vala_array_free (self->play_speeds, self->play_speeds_length1, (GDestroyNotify) g_free), NULL);
	self->play_speeds = _tmp24_;
	self->play_speeds_length1 = _tmp24__length1;
}


GUPnPProtocolInfo* rygel_media_resource_get_protocol_info (RygelMediaResource* self, GHashTable* replacements) {
	GUPnPProtocolInfo* result = NULL;
	GUPnPProtocolInfo* new_pi = NULL;
	GUPnPProtocolInfo* _tmp0_;
	GUPnPProtocolInfo* _tmp1_;
	const gchar* _tmp2_;
	GUPnPProtocolInfo* _tmp3_;
	const gchar* _tmp4_;
	GHashTable* _tmp5_;
	GUPnPProtocolInfo* _tmp13_;
	const gchar* _tmp14_;
	GUPnPProtocolInfo* _tmp15_;
	GUPnPDLNAConversion _tmp16_;
	GUPnPProtocolInfo* _tmp17_;
	GUPnPDLNAOperation _tmp18_;
	GUPnPProtocolInfo* _tmp19_;
	GUPnPDLNAFlags _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gupnp_protocol_info_new ();
	new_pi = _tmp0_;
	_tmp1_ = new_pi;
	_tmp2_ = self->priv->_protocol;
	gupnp_protocol_info_set_protocol (_tmp1_, _tmp2_);
	_tmp3_ = new_pi;
	_tmp4_ = self->priv->_network;
	gupnp_protocol_info_set_network (_tmp3_, _tmp4_);
	_tmp5_ = replacements;
	if (_tmp5_ == NULL) {
		GUPnPProtocolInfo* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = new_pi;
		_tmp7_ = self->priv->_mime_type;
		gupnp_protocol_info_set_mime_type (_tmp6_, _tmp7_);
	} else {
		GUPnPProtocolInfo* _tmp8_;
		GHashTable* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp8_ = new_pi;
		_tmp9_ = replacements;
		_tmp10_ = self->priv->_mime_type;
		_tmp11_ = rygel_media_object_apply_replacements (_tmp9_, _tmp10_);
		_tmp12_ = _tmp11_;
		gupnp_protocol_info_set_mime_type (_tmp8_, _tmp12_);
		_g_free0 (_tmp12_);
	}
	_tmp13_ = new_pi;
	_tmp14_ = self->priv->_dlna_profile;
	gupnp_protocol_info_set_dlna_profile (_tmp13_, _tmp14_);
	_tmp15_ = new_pi;
	_tmp16_ = self->priv->_dlna_conversion;
	gupnp_protocol_info_set_dlna_conversion (_tmp15_, _tmp16_);
	_tmp17_ = new_pi;
	_tmp18_ = self->priv->_dlna_operation;
	gupnp_protocol_info_set_dlna_operation (_tmp17_, _tmp18_);
	_tmp19_ = new_pi;
	_tmp20_ = self->priv->_dlna_flags;
	gupnp_protocol_info_set_dlna_flags (_tmp19_, _tmp20_);
	_tmp21_ = self->play_speeds;
	_tmp21__length1 = self->play_speeds_length1;
	if (_tmp21_ != NULL) {
		GUPnPProtocolInfo* _tmp22_;
		gchar** _tmp23_;
		gint _tmp23__length1;
		_tmp22_ = new_pi;
		_tmp23_ = self->play_speeds;
		_tmp23__length1 = self->play_speeds_length1;
		gupnp_protocol_info_set_play_speeds (_tmp22_, _tmp23_);
	}
	result = new_pi;
	return result;
}


gboolean rygel_media_resource_supports_arbitrary_byte_seek (RygelMediaResource* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = rygel_media_resource_is_dlna_operation_mode_set (self, (glong) GUPNP_DLNA_OPERATION_RANGE);
	result = _tmp0_;
	return result;
}


gboolean rygel_media_resource_supports_arbitrary_time_seek (RygelMediaResource* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = rygel_media_resource_is_dlna_operation_mode_set (self, (glong) GUPNP_DLNA_OPERATION_TIMESEEK);
	result = _tmp0_;
	return result;
}


gboolean rygel_media_resource_supports_limited_byte_seek (RygelMediaResource* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_BYTE_BASED_SEEK);
	result = _tmp0_;
	return result;
}


gboolean rygel_media_resource_supports_limited_time_seek (RygelMediaResource* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_TIME_BASED_SEEK);
	result = _tmp0_;
	return result;
}


gboolean rygel_media_resource_supports_limited_cleartext_byte_seek (RygelMediaResource* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_LOP_CLEAR_TEXT_BYTE_SEEK);
	result = _tmp0_;
	return result;
}


gboolean rygel_media_resource_supports_full_cleartext_byte_seek (RygelMediaResource* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_CLEAR_TEXT_BYTE_SEEK_FULL);
	result = _tmp0_;
	return result;
}


gboolean rygel_media_resource_is_link_protection_enabled (RygelMediaResource* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_LINK_PROTECTED_CONTENT);
	result = _tmp0_;
	return result;
}


gboolean rygel_media_resource_is_dlna_content (RygelMediaResource* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_dlna_profile;
	result = _tmp0_ != NULL;
	return result;
}


gchar* rygel_media_resource_get_default_transfer_mode (RygelMediaResource* self) {
	gchar* result = NULL;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE);
	if (_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("Streaming");
		result = _tmp1_;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("Interactive");
		result = _tmp2_;
		return result;
	}
}


gboolean rygel_media_resource_supports_transfer_mode (RygelMediaResource* self, const gchar* transfer_mode) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (transfer_mode != NULL, FALSE);
	_tmp0_ = rygel_media_resource_is_dlna_content (self);
	if (!_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp1_ = transfer_mode;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("Streaming")))) {
		switch (0) {
			default:
			{
				gboolean _tmp5_;
				_tmp5_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE);
				result = _tmp5_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("Interactive")))) {
		switch (0) {
			default:
			{
				gboolean _tmp6_;
				_tmp6_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE);
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("Background")))) {
		switch (0) {
			default:
			{
				gboolean _tmp7_;
				_tmp7_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE);
				result = _tmp7_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = FALSE;
				return result;
			}
		}
	}
}


gboolean rygel_media_resource_is_streamable (RygelMediaResource* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE);
	result = _tmp0_;
	return result;
}


gboolean rygel_media_resource_is_cleartext_range_support_enabled (RygelMediaResource* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) (GUPNP_DLNA_FLAGS_CLEAR_TEXT_BYTE_SEEK_FULL | GUPNP_DLNA_FLAGS_LOP_CLEAR_TEXT_BYTE_SEEK));
	result = _tmp0_;
	return result;
}


gboolean rygel_media_resource_supports_playspeed (RygelMediaResource* self) {
	gboolean result = FALSE;
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->play_speeds;
	_tmp0__length1 = self->play_speeds_length1;
	result = _tmp0__length1 > 0;
	return result;
}


gboolean rygel_media_resource_is_dlna_protocol_flag_set (RygelMediaResource* self, glong flags) {
	gboolean result = FALSE;
	GUPnPDLNAFlags _tmp0_;
	glong _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_dlna_flags;
	_tmp1_ = flags;
	result = (_tmp0_ & _tmp1_) != 0;
	return result;
}


gboolean rygel_media_resource_is_dlna_operation_mode_set (RygelMediaResource* self, glong flags) {
	gboolean result = FALSE;
	GUPnPDLNAOperation _tmp0_;
	glong _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_dlna_operation;
	_tmp1_ = flags;
	result = (_tmp0_ & _tmp1_) != 0;
	return result;
}


gchar* rygel_media_resource_to_string (RygelMediaResource* self) {
	gchar* result = NULL;
	GString* strbuf = NULL;
	const gchar* _tmp0_;
	GString* _tmp1_;
	GString* _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp10_;
	glong _tmp17_;
	gint _tmp24_;
	gint _tmp31_;
	gint _tmp38_;
	gint _tmp45_;
	gint _tmp52_;
	gint _tmp59_;
	gint _tmp66_;
	const gchar* _tmp73_;
	const gchar* _tmp78_ = NULL;
	const gchar* _tmp79_;
	GString* _tmp81_;
	GString* _tmp82_;
	GString* _tmp83_;
	const gchar* _tmp84_ = NULL;
	const gchar* _tmp85_;
	GString* _tmp87_;
	GString* _tmp88_;
	GString* _tmp89_;
	const gchar* _tmp90_ = NULL;
	const gchar* _tmp91_;
	GString* _tmp93_;
	GString* _tmp94_;
	GString* _tmp95_;
	GString* _tmp96_;
	GUPnPDLNAFlags _tmp97_;
	gboolean _tmp98_;
	gboolean _tmp100_;
	gboolean _tmp102_;
	gboolean _tmp104_;
	gboolean _tmp106_;
	gboolean _tmp108_;
	gboolean _tmp110_;
	gboolean _tmp112_;
	gboolean _tmp114_;
	gboolean _tmp116_;
	gboolean _tmp118_;
	gboolean _tmp120_;
	gboolean _tmp122_;
	GString* _tmp124_;
	GString* _tmp125_;
	gssize _tmp126_;
	GUPnPDLNAConversion _tmp127_;
	GUPnPDLNAOperation _tmp130_;
	gchar** _tmp140_;
	gint _tmp140__length1;
	const gchar* _tmp150_ = NULL;
	const gchar* _tmp151_;
	GString* _tmp153_;
	GString* _tmp154_;
	GString* _tmp155_;
	GString* _tmp156_;
	const gchar* _tmp157_;
	gchar* _tmp158_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->name;
	_tmp1_ = g_string_new (_tmp0_);
	strbuf = _tmp1_;
	_tmp2_ = strbuf;
	g_string_append_unichar (_tmp2_, (gunichar) '(');
	_tmp3_ = self->priv->_size;
	if (_tmp3_ >= ((gint64) 0)) {
		GString* _tmp4_;
		GString* _tmp5_;
		gint64 _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GString* _tmp9_;
		_tmp4_ = strbuf;
		_tmp5_ = g_string_append (_tmp4_, "size ");
		_tmp6_ = self->priv->_size;
		_tmp7_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_string_append (_tmp5_, _tmp8_);
		g_string_append_unichar (_tmp9_, (gunichar) ',');
		_g_free0 (_tmp8_);
	}
	_tmp10_ = self->priv->_cleartext_size;
	if (_tmp10_ >= ((gint64) 0)) {
		GString* _tmp11_;
		GString* _tmp12_;
		gint64 _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		GString* _tmp16_;
		_tmp11_ = strbuf;
		_tmp12_ = g_string_append (_tmp11_, "cleartextsize ");
		_tmp13_ = self->priv->_cleartext_size;
		_tmp14_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_string_append (_tmp12_, _tmp15_);
		g_string_append_unichar (_tmp16_, (gunichar) ',');
		_g_free0 (_tmp15_);
	}
	_tmp17_ = self->priv->_duration;
	if (_tmp17_ >= ((glong) 0)) {
		GString* _tmp18_;
		GString* _tmp19_;
		glong _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		GString* _tmp23_;
		_tmp18_ = strbuf;
		_tmp19_ = g_string_append (_tmp18_, "duration ");
		_tmp20_ = self->priv->_duration;
		_tmp21_ = g_strdup_printf ("%li", _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_string_append (_tmp19_, _tmp22_);
		g_string_append_unichar (_tmp23_, (gunichar) ',');
		_g_free0 (_tmp22_);
	}
	_tmp24_ = self->priv->_bitrate;
	if (_tmp24_ >= 0) {
		GString* _tmp25_;
		GString* _tmp26_;
		gint _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		GString* _tmp30_;
		_tmp25_ = strbuf;
		_tmp26_ = g_string_append (_tmp25_, "bitrate ");
		_tmp27_ = self->priv->_bitrate;
		_tmp28_ = g_strdup_printf ("%i", _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_string_append (_tmp26_, _tmp29_);
		g_string_append_unichar (_tmp30_, (gunichar) ',');
		_g_free0 (_tmp29_);
	}
	_tmp31_ = self->priv->_bits_per_sample;
	if (_tmp31_ >= 0) {
		GString* _tmp32_;
		GString* _tmp33_;
		gint _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		GString* _tmp37_;
		_tmp32_ = strbuf;
		_tmp33_ = g_string_append (_tmp32_, "bits_per_sample ");
		_tmp34_ = self->priv->_bits_per_sample;
		_tmp35_ = g_strdup_printf ("%i", _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_string_append (_tmp33_, _tmp36_);
		g_string_append_unichar (_tmp37_, (gunichar) ',');
		_g_free0 (_tmp36_);
	}
	_tmp38_ = self->priv->_width;
	if (_tmp38_ >= 0) {
		GString* _tmp39_;
		GString* _tmp40_;
		gint _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		GString* _tmp44_;
		_tmp39_ = strbuf;
		_tmp40_ = g_string_append (_tmp39_, "width ");
		_tmp41_ = self->priv->_width;
		_tmp42_ = g_strdup_printf ("%i", _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_string_append (_tmp40_, _tmp43_);
		g_string_append_unichar (_tmp44_, (gunichar) ',');
		_g_free0 (_tmp43_);
	}
	_tmp45_ = self->priv->_height;
	if (_tmp45_ >= 0) {
		GString* _tmp46_;
		GString* _tmp47_;
		gint _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		GString* _tmp51_;
		_tmp46_ = strbuf;
		_tmp47_ = g_string_append (_tmp46_, "height ");
		_tmp48_ = self->priv->_height;
		_tmp49_ = g_strdup_printf ("%i", _tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = g_string_append (_tmp47_, _tmp50_);
		g_string_append_unichar (_tmp51_, (gunichar) ',');
		_g_free0 (_tmp50_);
	}
	_tmp52_ = self->priv->_color_depth;
	if (_tmp52_ >= 0) {
		GString* _tmp53_;
		GString* _tmp54_;
		gint _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		GString* _tmp58_;
		_tmp53_ = strbuf;
		_tmp54_ = g_string_append (_tmp53_, "color_depth ");
		_tmp55_ = self->priv->_color_depth;
		_tmp56_ = g_strdup_printf ("%i", _tmp55_);
		_tmp57_ = _tmp56_;
		_tmp58_ = g_string_append (_tmp54_, _tmp57_);
		g_string_append_unichar (_tmp58_, (gunichar) ',');
		_g_free0 (_tmp57_);
	}
	_tmp59_ = self->priv->_audio_channels;
	if (_tmp59_ >= 0) {
		GString* _tmp60_;
		GString* _tmp61_;
		gint _tmp62_;
		gchar* _tmp63_;
		gchar* _tmp64_;
		GString* _tmp65_;
		_tmp60_ = strbuf;
		_tmp61_ = g_string_append (_tmp60_, "audio_channels ");
		_tmp62_ = self->priv->_audio_channels;
		_tmp63_ = g_strdup_printf ("%i", _tmp62_);
		_tmp64_ = _tmp63_;
		_tmp65_ = g_string_append (_tmp61_, _tmp64_);
		g_string_append_unichar (_tmp65_, (gunichar) ',');
		_g_free0 (_tmp64_);
	}
	_tmp66_ = self->priv->_sample_freq;
	if (_tmp66_ >= 0) {
		GString* _tmp67_;
		GString* _tmp68_;
		gint _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		GString* _tmp72_;
		_tmp67_ = strbuf;
		_tmp68_ = g_string_append (_tmp67_, "sample_freq ");
		_tmp69_ = self->priv->_sample_freq;
		_tmp70_ = g_strdup_printf ("%i", _tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = g_string_append (_tmp68_, _tmp71_);
		g_string_append_unichar (_tmp72_, (gunichar) ',');
		_g_free0 (_tmp71_);
	}
	_tmp73_ = self->priv->_network;
	if (_tmp73_ != NULL) {
		GString* _tmp74_;
		GString* _tmp75_;
		const gchar* _tmp76_;
		GString* _tmp77_;
		_tmp74_ = strbuf;
		_tmp75_ = g_string_append (_tmp74_, "network ");
		_tmp76_ = self->priv->_network;
		_tmp77_ = g_string_append (_tmp75_, _tmp76_);
		g_string_append_unichar (_tmp77_, (gunichar) ',');
	}
	_tmp79_ = self->priv->_protocol;
	if (_tmp79_ == NULL) {
		_tmp78_ = "null";
	} else {
		const gchar* _tmp80_;
		_tmp80_ = self->priv->_protocol;
		_tmp78_ = _tmp80_;
	}
	_tmp81_ = strbuf;
	_tmp82_ = g_string_append (_tmp81_, "protocol ");
	_tmp83_ = g_string_append (_tmp82_, _tmp78_);
	g_string_append_unichar (_tmp83_, (gunichar) ',');
	_tmp85_ = self->priv->_mime_type;
	if (_tmp85_ == NULL) {
		_tmp84_ = "null";
	} else {
		const gchar* _tmp86_;
		_tmp86_ = self->priv->_mime_type;
		_tmp84_ = _tmp86_;
	}
	_tmp87_ = strbuf;
	_tmp88_ = g_string_append (_tmp87_, "mime_type ");
	_tmp89_ = g_string_append (_tmp88_, _tmp84_);
	g_string_append_unichar (_tmp89_, (gunichar) ',');
	_tmp91_ = self->priv->_dlna_profile;
	if (_tmp91_ == NULL) {
		_tmp90_ = "null";
	} else {
		const gchar* _tmp92_;
		_tmp92_ = self->priv->_dlna_profile;
		_tmp90_ = _tmp92_;
	}
	_tmp93_ = strbuf;
	_tmp94_ = g_string_append (_tmp93_, "dlna_profile ");
	_tmp95_ = g_string_append (_tmp94_, _tmp90_);
	g_string_append_unichar (_tmp95_, (gunichar) ',');
	_tmp96_ = strbuf;
	_tmp97_ = self->priv->_dlna_flags;
	g_string_append_printf (_tmp96_, "dlna_flags %.8X [", (guint) _tmp97_);
	_tmp98_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_SENDER_PACED);
	if (_tmp98_) {
		GString* _tmp99_;
		_tmp99_ = strbuf;
		g_string_append (_tmp99_, "sp-flag ");
	}
	_tmp100_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_TIME_BASED_SEEK);
	if (_tmp100_) {
		GString* _tmp101_;
		_tmp101_ = strbuf;
		g_string_append (_tmp101_, "lop-time ");
	}
	_tmp102_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_BYTE_BASED_SEEK);
	if (_tmp102_) {
		GString* _tmp103_;
		_tmp103_ = strbuf;
		g_string_append (_tmp103_, "lop-byte ");
	}
	_tmp104_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_S0_INCREASE);
	if (_tmp104_) {
		GString* _tmp105_;
		_tmp105_ = strbuf;
		g_string_append (_tmp105_, "s0-increase ");
	}
	_tmp106_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_SN_INCREASE);
	if (_tmp106_) {
		GString* _tmp107_;
		_tmp107_ = strbuf;
		g_string_append (_tmp107_, "sn-increase ");
	}
	_tmp108_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE);
	if (_tmp108_) {
		GString* _tmp109_;
		_tmp109_ = strbuf;
		g_string_append (_tmp109_, "streaming ");
	}
	_tmp110_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE);
	if (_tmp110_) {
		GString* _tmp111_;
		_tmp111_ = strbuf;
		g_string_append (_tmp111_, "interactive ");
	}
	_tmp112_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE);
	if (_tmp112_) {
		GString* _tmp113_;
		_tmp113_ = strbuf;
		g_string_append (_tmp113_, "background ");
	}
	_tmp114_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_CONNECTION_STALL);
	if (_tmp114_) {
		GString* _tmp115_;
		_tmp115_ = strbuf;
		g_string_append (_tmp115_, "stall ");
	}
	_tmp116_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_DLNA_V15);
	if (_tmp116_) {
		GString* _tmp117_;
		_tmp117_ = strbuf;
		g_string_append (_tmp117_, "v1.5 ");
	}
	_tmp118_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_LINK_PROTECTED_CONTENT);
	if (_tmp118_) {
		GString* _tmp119_;
		_tmp119_ = strbuf;
		g_string_append (_tmp119_, "link-protected ");
	}
	_tmp120_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_CLEAR_TEXT_BYTE_SEEK_FULL);
	if (_tmp120_) {
		GString* _tmp121_;
		_tmp121_ = strbuf;
		g_string_append (_tmp121_, "cleartext-full ");
	}
	_tmp122_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_LOP_CLEAR_TEXT_BYTE_SEEK);
	if (_tmp122_) {
		GString* _tmp123_;
		_tmp123_ = strbuf;
		g_string_append (_tmp123_, "cleartext-lop ");
	}
	_tmp124_ = strbuf;
	_tmp125_ = strbuf;
	_tmp126_ = _tmp125_->len;
	g_string_overwrite (_tmp124_, (gsize) (_tmp126_ - 1), "],");
	_tmp127_ = self->priv->_dlna_conversion;
	if (_tmp127_ != GUPNP_DLNA_CONVERSION_NONE) {
		GString* _tmp128_;
		GUPnPDLNAConversion _tmp129_;
		_tmp128_ = strbuf;
		_tmp129_ = self->priv->_dlna_conversion;
		g_string_append_printf (_tmp128_, "dlna_conversion %1d,", (gint) _tmp129_);
	}
	_tmp130_ = self->priv->_dlna_operation;
	if (_tmp130_ != GUPNP_DLNA_OPERATION_NONE) {
		GString* _tmp131_;
		GUPnPDLNAOperation _tmp132_;
		gboolean _tmp133_;
		gboolean _tmp135_;
		GString* _tmp137_;
		GString* _tmp138_;
		gssize _tmp139_;
		_tmp131_ = strbuf;
		_tmp132_ = self->priv->_dlna_operation;
		g_string_append_printf (_tmp131_, "dlna_operation %.2X [", (guint) _tmp132_);
		_tmp133_ = rygel_media_resource_is_dlna_operation_mode_set (self, (glong) GUPNP_DLNA_OPERATION_RANGE);
		if (_tmp133_) {
			GString* _tmp134_;
			_tmp134_ = strbuf;
			g_string_append (_tmp134_, "byte-seek ");
		}
		_tmp135_ = rygel_media_resource_is_dlna_operation_mode_set (self, (glong) GUPNP_DLNA_OPERATION_TIMESEEK);
		if (_tmp135_) {
			GString* _tmp136_;
			_tmp136_ = strbuf;
			g_string_append (_tmp136_, "time-seek ");
		}
		_tmp137_ = strbuf;
		_tmp138_ = strbuf;
		_tmp139_ = _tmp138_->len;
		g_string_overwrite (_tmp137_, (gsize) (_tmp139_ - 1), "],");
	}
	_tmp140_ = self->play_speeds;
	_tmp140__length1 = self->play_speeds_length1;
	if (_tmp140_ != NULL) {
		GString* _tmp141_;
		gchar** _tmp142_;
		gint _tmp142__length1;
		GString* _tmp147_;
		GString* _tmp148_;
		gssize _tmp149_;
		_tmp141_ = strbuf;
		g_string_append (_tmp141_, "play_speeds [");
		_tmp142_ = self->play_speeds;
		_tmp142__length1 = self->play_speeds_length1;
		{
			gchar** speed_collection = NULL;
			gint speed_collection_length1 = 0;
			gint _speed_collection_size_ = 0;
			gint speed_it = 0;
			speed_collection = _tmp142_;
			speed_collection_length1 = _tmp142__length1;
			for (speed_it = 0; speed_it < _tmp142__length1; speed_it = speed_it + 1) {
				gchar* _tmp143_;
				gchar* speed = NULL;
				_tmp143_ = g_strdup (speed_collection[speed_it]);
				speed = _tmp143_;
				{
					GString* _tmp144_;
					const gchar* _tmp145_;
					GString* _tmp146_;
					_tmp144_ = strbuf;
					_tmp145_ = speed;
					_tmp146_ = g_string_append (_tmp144_, _tmp145_);
					g_string_append_unichar (_tmp146_, (gunichar) ',');
					_g_free0 (speed);
				}
			}
		}
		_tmp147_ = strbuf;
		_tmp148_ = strbuf;
		_tmp149_ = _tmp148_->len;
		g_string_overwrite (_tmp147_, (gsize) (_tmp149_ - 1), "]");
	}
	_tmp151_ = self->priv->_uri;
	if (_tmp151_ == NULL) {
		_tmp150_ = "null";
	} else {
		const gchar* _tmp152_;
		_tmp152_ = self->priv->_uri;
		_tmp150_ = _tmp152_;
	}
	_tmp153_ = strbuf;
	_tmp154_ = g_string_append (_tmp153_, ",uri ");
	g_string_append (_tmp154_, _tmp150_);
	_tmp155_ = strbuf;
	g_string_append_unichar (_tmp155_, (gunichar) ')');
	_tmp156_ = strbuf;
	_tmp157_ = _tmp156_->str;
	_tmp158_ = g_strdup (_tmp157_);
	result = _tmp158_;
	_g_string_free0 (strbuf);
	return result;
}


const gchar* rygel_media_resource_get_uri (RygelMediaResource* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uri;
	result = _tmp0_;
	return result;
}


void rygel_media_resource_set_uri (RygelMediaResource* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_media_resource_get_uri (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_uri);
		self->priv->_uri = _tmp1_;
		g_object_notify ((GObject *) self, "uri");
	}
}


const gchar* rygel_media_resource_get_import_uri (RygelMediaResource* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_import_uri;
	result = _tmp0_;
	return result;
}


void rygel_media_resource_set_import_uri (RygelMediaResource* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_media_resource_get_import_uri (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_import_uri);
		self->priv->_import_uri = _tmp1_;
		g_object_notify ((GObject *) self, "import-uri");
	}
}


const gchar* rygel_media_resource_get_extension (RygelMediaResource* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_extension;
	result = _tmp0_;
	return result;
}


void rygel_media_resource_set_extension (RygelMediaResource* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_media_resource_get_extension (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_extension);
		self->priv->_extension = _tmp1_;
		g_object_notify ((GObject *) self, "extension");
	}
}


gint64 rygel_media_resource_get_size (RygelMediaResource* self) {
	gint64 result;
	gint64 _tmp0_;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_size;
	result = _tmp0_;
	return result;
}


void rygel_media_resource_set_size (RygelMediaResource* self, gint64 value) {
	g_return_if_fail (self != NULL);
	if (rygel_media_resource_get_size (self) != value) {
		gint64 _tmp0_;
		_tmp0_ = value;
		self->priv->_size = _tmp0_;
		g_object_notify ((GObject *) self, "size");
	}
}


gint64 rygel_media_resource_get_cleartext_size (RygelMediaResource* self) {
	gint64 result;
	gint64 _tmp0_;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_cleartext_size;
	result = _tmp0_;
	return result;
}


void rygel_media_resource_set_cleartext_size (RygelMediaResource* self, gint64 value) {
	g_return_if_fail (self != NULL);
	if (rygel_media_resource_get_cleartext_size (self) != value) {
		gint64 _tmp0_;
		_tmp0_ = value;
		self->priv->_cleartext_size = _tmp0_;
		g_object_notify ((GObject *) self, "cleartext-size");
	}
}


glong rygel_media_resource_get_duration (RygelMediaResource* self) {
	glong result;
	glong _tmp0_;
	g_return_val_if_fail (self != NULL, 0L);
	_tmp0_ = self->priv->_duration;
	result = _tmp0_;
	return result;
}


void rygel_media_resource_set_duration (RygelMediaResource* self, glong value) {
	g_return_if_fail (self != NULL);
	if (rygel_media_resource_get_duration (self) != value) {
		glong _tmp0_;
		_tmp0_ = value;
		self->priv->_duration = _tmp0_;
		g_object_notify ((GObject *) self, "duration");
	}
}


gint rygel_media_resource_get_bitrate (RygelMediaResource* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_bitrate;
	result = _tmp0_;
	return result;
}


void rygel_media_resource_set_bitrate (RygelMediaResource* self, gint value) {
	g_return_if_fail (self != NULL);
	if (rygel_media_resource_get_bitrate (self) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_bitrate = _tmp0_;
		g_object_notify ((GObject *) self, "bitrate");
	}
}


gint rygel_media_resource_get_bits_per_sample (RygelMediaResource* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_bits_per_sample;
	result = _tmp0_;
	return result;
}


void rygel_media_resource_set_bits_per_sample (RygelMediaResource* self, gint value) {
	g_return_if_fail (self != NULL);
	if (rygel_media_resource_get_bits_per_sample (self) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_bits_per_sample = _tmp0_;
		g_object_notify ((GObject *) self, "bits-per-sample");
	}
}


gint rygel_media_resource_get_color_depth (RygelMediaResource* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_color_depth;
	result = _tmp0_;
	return result;
}


void rygel_media_resource_set_color_depth (RygelMediaResource* self, gint value) {
	g_return_if_fail (self != NULL);
	if (rygel_media_resource_get_color_depth (self) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_color_depth = _tmp0_;
		g_object_notify ((GObject *) self, "color-depth");
	}
}


gint rygel_media_resource_get_width (RygelMediaResource* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_width;
	result = _tmp0_;
	return result;
}


void rygel_media_resource_set_width (RygelMediaResource* self, gint value) {
	g_return_if_fail (self != NULL);
	if (rygel_media_resource_get_width (self) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_width = _tmp0_;
		g_object_notify ((GObject *) self, "width");
	}
}


gint rygel_media_resource_get_height (RygelMediaResource* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_height;
	result = _tmp0_;
	return result;
}


void rygel_media_resource_set_height (RygelMediaResource* self, gint value) {
	g_return_if_fail (self != NULL);
	if (rygel_media_resource_get_height (self) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_height = _tmp0_;
		g_object_notify ((GObject *) self, "height");
	}
}


gint rygel_media_resource_get_audio_channels (RygelMediaResource* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_audio_channels;
	result = _tmp0_;
	return result;
}


void rygel_media_resource_set_audio_channels (RygelMediaResource* self, gint value) {
	g_return_if_fail (self != NULL);
	if (rygel_media_resource_get_audio_channels (self) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_audio_channels = _tmp0_;
		g_object_notify ((GObject *) self, "audio-channels");
	}
}


gint rygel_media_resource_get_sample_freq (RygelMediaResource* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_sample_freq;
	result = _tmp0_;
	return result;
}


void rygel_media_resource_set_sample_freq (RygelMediaResource* self, gint value) {
	g_return_if_fail (self != NULL);
	if (rygel_media_resource_get_sample_freq (self) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_sample_freq = _tmp0_;
		g_object_notify ((GObject *) self, "sample-freq");
	}
}


const gchar* rygel_media_resource_get_protocol (RygelMediaResource* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_protocol;
	result = _tmp0_;
	return result;
}


void rygel_media_resource_set_protocol (RygelMediaResource* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_media_resource_get_protocol (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_protocol);
		self->priv->_protocol = _tmp1_;
		g_object_notify ((GObject *) self, "protocol");
	}
}


const gchar* rygel_media_resource_get_mime_type (RygelMediaResource* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mime_type;
	result = _tmp0_;
	return result;
}


void rygel_media_resource_set_mime_type (RygelMediaResource* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_media_resource_get_mime_type (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_mime_type);
		self->priv->_mime_type = _tmp1_;
		g_object_notify ((GObject *) self, "mime-type");
	}
}


const gchar* rygel_media_resource_get_dlna_profile (RygelMediaResource* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_dlna_profile;
	result = _tmp0_;
	return result;
}


void rygel_media_resource_set_dlna_profile (RygelMediaResource* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_media_resource_get_dlna_profile (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_dlna_profile);
		self->priv->_dlna_profile = _tmp1_;
		g_object_notify ((GObject *) self, "dlna-profile");
	}
}


const gchar* rygel_media_resource_get_network (RygelMediaResource* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_network;
	result = _tmp0_;
	return result;
}


void rygel_media_resource_set_network (RygelMediaResource* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_media_resource_get_network (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_network);
		self->priv->_network = _tmp1_;
		g_object_notify ((GObject *) self, "network");
	}
}


GUPnPDLNAConversion rygel_media_resource_get_dlna_conversion (RygelMediaResource* self) {
	GUPnPDLNAConversion result;
	GUPnPDLNAConversion _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_dlna_conversion;
	result = _tmp0_;
	return result;
}


void rygel_media_resource_set_dlna_conversion (RygelMediaResource* self, GUPnPDLNAConversion value) {
	g_return_if_fail (self != NULL);
	if (rygel_media_resource_get_dlna_conversion (self) != value) {
		GUPnPDLNAConversion _tmp0_;
		_tmp0_ = value;
		self->priv->_dlna_conversion = _tmp0_;
		g_object_notify ((GObject *) self, "dlna-conversion");
	}
}


GUPnPDLNAFlags rygel_media_resource_get_dlna_flags (RygelMediaResource* self) {
	GUPnPDLNAFlags result;
	GUPnPDLNAFlags _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_dlna_flags;
	result = _tmp0_;
	return result;
}


void rygel_media_resource_set_dlna_flags (RygelMediaResource* self, GUPnPDLNAFlags value) {
	g_return_if_fail (self != NULL);
	if (rygel_media_resource_get_dlna_flags (self) != value) {
		GUPnPDLNAFlags _tmp0_;
		_tmp0_ = value;
		self->priv->_dlna_flags = _tmp0_;
		g_object_notify ((GObject *) self, "dlna-flags");
	}
}


GUPnPDLNAOperation rygel_media_resource_get_dlna_operation (RygelMediaResource* self) {
	GUPnPDLNAOperation result;
	GUPnPDLNAOperation _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_dlna_operation;
	result = _tmp0_;
	return result;
}


void rygel_media_resource_set_dlna_operation (RygelMediaResource* self, GUPnPDLNAOperation value) {
	g_return_if_fail (self != NULL);
	if (rygel_media_resource_get_dlna_operation (self) != value) {
		GUPnPDLNAOperation _tmp0_;
		_tmp0_ = value;
		self->priv->_dlna_operation = _tmp0_;
		g_object_notify ((GObject *) self, "dlna-operation");
	}
}


static void rygel_media_resource_class_init (RygelMediaResourceClass * klass) {
	rygel_media_resource_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaResourcePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_resource_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_resource_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_resource_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_URI_PROPERTY, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_IMPORT_URI_PROPERTY, g_param_spec_string ("import-uri", "import-uri", "import-uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_EXTENSION_PROPERTY, g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_SIZE_PROPERTY, g_param_spec_int64 ("size", "size", "size", G_MININT64, G_MAXINT64, (gint64) -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_CLEARTEXT_SIZE_PROPERTY, g_param_spec_int64 ("cleartext-size", "cleartext-size", "cleartext-size", G_MININT64, G_MAXINT64, (gint64) -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_DURATION_PROPERTY, g_param_spec_long ("duration", "duration", "duration", G_MINLONG, G_MAXLONG, (glong) -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_BITRATE_PROPERTY, g_param_spec_int ("bitrate", "bitrate", "bitrate", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_BITS_PER_SAMPLE_PROPERTY, g_param_spec_int ("bits-per-sample", "bits-per-sample", "bits-per-sample", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_COLOR_DEPTH_PROPERTY, g_param_spec_int ("color-depth", "color-depth", "color-depth", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_WIDTH_PROPERTY, g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_HEIGHT_PROPERTY, g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_AUDIO_CHANNELS_PROPERTY, g_param_spec_int ("audio-channels", "audio-channels", "audio-channels", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_SAMPLE_FREQ_PROPERTY, g_param_spec_int ("sample-freq", "sample-freq", "sample-freq", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_PROTOCOL_PROPERTY, g_param_spec_string ("protocol", "protocol", "protocol", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_MIME_TYPE_PROPERTY, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_DLNA_PROFILE_PROPERTY, g_param_spec_string ("dlna-profile", "dlna-profile", "dlna-profile", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_NETWORK_PROPERTY, g_param_spec_string ("network", "network", "network", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_DLNA_CONVERSION_PROPERTY, g_param_spec_flags ("dlna-conversion", "dlna-conversion", "dlna-conversion", gupnp_dlna_conversion_get_type (), GUPNP_DLNA_CONVERSION_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_DLNA_FLAGS_PROPERTY, g_param_spec_flags ("dlna-flags", "dlna-flags", "dlna-flags", gupnp_dlna_flags_get_type (), GUPNP_DLNA_FLAGS_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_DLNA_OPERATION_PROPERTY, g_param_spec_flags ("dlna-operation", "dlna-operation", "dlna-operation", gupnp_dlna_operation_get_type (), GUPNP_DLNA_OPERATION_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_media_resource_instance_init (RygelMediaResource * self) {
	self->priv = RYGEL_MEDIA_RESOURCE_GET_PRIVATE (self);
	self->priv->_extension = NULL;
	self->priv->_size = (gint64) -1;
	self->priv->_cleartext_size = (gint64) -1;
	self->priv->_duration = (glong) -1;
	self->priv->_bitrate = -1;
	self->priv->_bits_per_sample = -1;
	self->priv->_color_depth = -1;
	self->priv->_width = -1;
	self->priv->_height = -1;
	self->priv->_audio_channels = -1;
	self->priv->_sample_freq = -1;
	self->priv->_protocol = NULL;
	self->priv->_mime_type = NULL;
	self->priv->_dlna_profile = NULL;
	self->priv->_network = NULL;
	self->play_speeds = NULL;
	self->play_speeds_length1 = 0;
	self->priv->_dlna_conversion = GUPNP_DLNA_CONVERSION_NONE;
	self->priv->_dlna_flags = GUPNP_DLNA_FLAGS_NONE;
	self->priv->_dlna_operation = GUPNP_DLNA_OPERATION_NONE;
}


static void rygel_media_resource_finalize (GObject * obj) {
	RygelMediaResource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource);
	_g_free0 (self->priv->name);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_import_uri);
	_g_free0 (self->priv->_extension);
	_g_free0 (self->priv->_protocol);
	_g_free0 (self->priv->_mime_type);
	_g_free0 (self->priv->_dlna_profile);
	_g_free0 (self->priv->_network);
	self->play_speeds = (_vala_array_free (self->play_speeds, self->play_speeds_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (rygel_media_resource_parent_class)->finalize (obj);
}


/**
 * Represents a media resource (Music, Video, Image, etc).
 */
GType rygel_media_resource_get_type (void) {
	static volatile gsize rygel_media_resource_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_resource_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaResourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_resource_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaResource), 0, (GInstanceInitFunc) rygel_media_resource_instance_init, NULL };
		GType rygel_media_resource_type_id;
		rygel_media_resource_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaResource", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_resource_type_id__volatile, rygel_media_resource_type_id);
	}
	return rygel_media_resource_type_id__volatile;
}


static void _vala_rygel_media_resource_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaResource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource);
	switch (property_id) {
		case RYGEL_MEDIA_RESOURCE_URI_PROPERTY:
		g_value_set_string (value, rygel_media_resource_get_uri (self));
		break;
		case RYGEL_MEDIA_RESOURCE_IMPORT_URI_PROPERTY:
		g_value_set_string (value, rygel_media_resource_get_import_uri (self));
		break;
		case RYGEL_MEDIA_RESOURCE_EXTENSION_PROPERTY:
		g_value_set_string (value, rygel_media_resource_get_extension (self));
		break;
		case RYGEL_MEDIA_RESOURCE_SIZE_PROPERTY:
		g_value_set_int64 (value, rygel_media_resource_get_size (self));
		break;
		case RYGEL_MEDIA_RESOURCE_CLEARTEXT_SIZE_PROPERTY:
		g_value_set_int64 (value, rygel_media_resource_get_cleartext_size (self));
		break;
		case RYGEL_MEDIA_RESOURCE_DURATION_PROPERTY:
		g_value_set_long (value, rygel_media_resource_get_duration (self));
		break;
		case RYGEL_MEDIA_RESOURCE_BITRATE_PROPERTY:
		g_value_set_int (value, rygel_media_resource_get_bitrate (self));
		break;
		case RYGEL_MEDIA_RESOURCE_BITS_PER_SAMPLE_PROPERTY:
		g_value_set_int (value, rygel_media_resource_get_bits_per_sample (self));
		break;
		case RYGEL_MEDIA_RESOURCE_COLOR_DEPTH_PROPERTY:
		g_value_set_int (value, rygel_media_resource_get_color_depth (self));
		break;
		case RYGEL_MEDIA_RESOURCE_WIDTH_PROPERTY:
		g_value_set_int (value, rygel_media_resource_get_width (self));
		break;
		case RYGEL_MEDIA_RESOURCE_HEIGHT_PROPERTY:
		g_value_set_int (value, rygel_media_resource_get_height (self));
		break;
		case RYGEL_MEDIA_RESOURCE_AUDIO_CHANNELS_PROPERTY:
		g_value_set_int (value, rygel_media_resource_get_audio_channels (self));
		break;
		case RYGEL_MEDIA_RESOURCE_SAMPLE_FREQ_PROPERTY:
		g_value_set_int (value, rygel_media_resource_get_sample_freq (self));
		break;
		case RYGEL_MEDIA_RESOURCE_PROTOCOL_PROPERTY:
		g_value_set_string (value, rygel_media_resource_get_protocol (self));
		break;
		case RYGEL_MEDIA_RESOURCE_MIME_TYPE_PROPERTY:
		g_value_set_string (value, rygel_media_resource_get_mime_type (self));
		break;
		case RYGEL_MEDIA_RESOURCE_DLNA_PROFILE_PROPERTY:
		g_value_set_string (value, rygel_media_resource_get_dlna_profile (self));
		break;
		case RYGEL_MEDIA_RESOURCE_NETWORK_PROPERTY:
		g_value_set_string (value, rygel_media_resource_get_network (self));
		break;
		case RYGEL_MEDIA_RESOURCE_DLNA_CONVERSION_PROPERTY:
		g_value_set_flags (value, rygel_media_resource_get_dlna_conversion (self));
		break;
		case RYGEL_MEDIA_RESOURCE_DLNA_FLAGS_PROPERTY:
		g_value_set_flags (value, rygel_media_resource_get_dlna_flags (self));
		break;
		case RYGEL_MEDIA_RESOURCE_DLNA_OPERATION_PROPERTY:
		g_value_set_flags (value, rygel_media_resource_get_dlna_operation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_media_resource_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaResource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource);
	switch (property_id) {
		case RYGEL_MEDIA_RESOURCE_URI_PROPERTY:
		rygel_media_resource_set_uri (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_RESOURCE_IMPORT_URI_PROPERTY:
		rygel_media_resource_set_import_uri (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_RESOURCE_EXTENSION_PROPERTY:
		rygel_media_resource_set_extension (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_RESOURCE_SIZE_PROPERTY:
		rygel_media_resource_set_size (self, g_value_get_int64 (value));
		break;
		case RYGEL_MEDIA_RESOURCE_CLEARTEXT_SIZE_PROPERTY:
		rygel_media_resource_set_cleartext_size (self, g_value_get_int64 (value));
		break;
		case RYGEL_MEDIA_RESOURCE_DURATION_PROPERTY:
		rygel_media_resource_set_duration (self, g_value_get_long (value));
		break;
		case RYGEL_MEDIA_RESOURCE_BITRATE_PROPERTY:
		rygel_media_resource_set_bitrate (self, g_value_get_int (value));
		break;
		case RYGEL_MEDIA_RESOURCE_BITS_PER_SAMPLE_PROPERTY:
		rygel_media_resource_set_bits_per_sample (self, g_value_get_int (value));
		break;
		case RYGEL_MEDIA_RESOURCE_COLOR_DEPTH_PROPERTY:
		rygel_media_resource_set_color_depth (self, g_value_get_int (value));
		break;
		case RYGEL_MEDIA_RESOURCE_WIDTH_PROPERTY:
		rygel_media_resource_set_width (self, g_value_get_int (value));
		break;
		case RYGEL_MEDIA_RESOURCE_HEIGHT_PROPERTY:
		rygel_media_resource_set_height (self, g_value_get_int (value));
		break;
		case RYGEL_MEDIA_RESOURCE_AUDIO_CHANNELS_PROPERTY:
		rygel_media_resource_set_audio_channels (self, g_value_get_int (value));
		break;
		case RYGEL_MEDIA_RESOURCE_SAMPLE_FREQ_PROPERTY:
		rygel_media_resource_set_sample_freq (self, g_value_get_int (value));
		break;
		case RYGEL_MEDIA_RESOURCE_PROTOCOL_PROPERTY:
		rygel_media_resource_set_protocol (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_RESOURCE_MIME_TYPE_PROPERTY:
		rygel_media_resource_set_mime_type (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_RESOURCE_DLNA_PROFILE_PROPERTY:
		rygel_media_resource_set_dlna_profile (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_RESOURCE_NETWORK_PROPERTY:
		rygel_media_resource_set_network (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_RESOURCE_DLNA_CONVERSION_PROPERTY:
		rygel_media_resource_set_dlna_conversion (self, g_value_get_flags (value));
		break;
		case RYGEL_MEDIA_RESOURCE_DLNA_FLAGS_PROPERTY:
		rygel_media_resource_set_dlna_flags (self, g_value_get_flags (value));
		break;
		case RYGEL_MEDIA_RESOURCE_DLNA_OPERATION_PROPERTY:
		rygel_media_resource_set_dlna_operation (self, g_value_get_flags (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



