set terminal epslatex color standalone
set output "speedup-2d-assembly.tex"

# dirichlet_time.cc
set key Left left

set size square
set xrange [0:32]
set yrange [0:32]
set xtics (0,  8,16,24,32)
set ytics (0,1,8,16,24,32)
set xlabel '[c]{$p$}'
set  label '[r]{$S(p)$}' at graph -0.02, 0.87
set  label '[l]{\em assembly $d=2$}' at graph 0.05, 0.60

plot \
  x notitle w l lt 2 lc 0, \
  1 notitle w l lt 2 lc 0, \
  'speedup-dirichlet-square-40-P1-direct.gdat'   u 1:(0.0370/$3)  t 'square-40'   w lp lc 1 pt 1, \
  'speedup-dirichlet-square-80-P1-direct.gdat'   u 1:(0.1149/$3)  t 'square-80'   w lp lc 2 pt 2, \
  'speedup-dirichlet-square-160-P1-direct.gdat'  u 1:(0.4622/$3)  t 'square-160'  w lp lc 3 pt 3, \
  'speedup-dirichlet-square-320-P1-direct.gdat'  u 1:(1.8050/$3)  t 'square-320'  w lp lc 4 pt 4, \
  'speedup-dirichlet-square-640-P1-direct.gdat'  u 1:(7.0484/$3)  t 'square-640'  w lp lc 5 pt 5, \
  'speedup-dirichlet-square-1280-P1-direct.gdat' u 1:(29.09/$3)   t 'square-1280' w lp lc 7 pt 7
#pause -1 "<retour>"
