#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "sinusprod_helmholtz.icc"
int main(int argc, char**argv) {
  environment rheolef(argc, argv);
  geo omega (argv[1]);
  size_t d = omega.dimension();
  space Xh (omega, argv[2]);
  trial u (Xh); test v (Xh);
  form  a  = integrate (u*v + dot(grad(u),grad(v)));
  field lh = integrate (f(d)*v) + integrate ("boundary", g(d)*v);
  field uh (Xh);
  solver sa (a.uu());
  uh.set_u() = sa.solve (lh.u() - a.ub()*uh.b());
  dout << uh;
}
