///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// compute:
//
//  \partial u / partial x_i
//
#include "rheolef/rheolef.h"
using namespace rheolef;
using namespace std;

void usage()
{
      cerr << "form_d_dy_tst: usage: form_d_dy_tst"
	   << " [P0|P1d|P1|P2] [P0|P1d|P1|P2]"
	   << " {-Igeodir}*"
	   << " [file[.geo] | -]"
	   << endl;
      exit (1);
}
Float
u_fct (const point& x)
{
    return x[1];
}
int main(int argc, char**argv)
{
    bool verbose = true;
    if (argc <= 3) usage();
    string approx1 = argv[1];
    string approx2 = argv[2];
    //
    // load geometry
    //
    geo g;
    int io = 3; 
    while (argv [io][0] == '-' && argv [io][1] == 'I') {
	append_dir_to_rheo_path (argv[io]+2);
	io++;
    }
    if (strcmp (argv[io], "-") == 0) {
	// input field on standard input
        cerr << "! form_solve: load geo on stdin\n";
	cin >> g;
      
    } else {
    
	// input field on file
  	g = geo(argv[io]);
    }
    space X(g, approx1);
    field u = interpolate(X, u_fct);
    space Y(g, approx2);
    form  d_dy(X,Y,"d_dx1");
    form_diag m(Y,"mass");
    field q = (1./m)*(d_dy*u);

    // force conversion to double for hight prec classes
    // for non-regression test purpose
    numeric_flags<Float>::output_as_double(true);

    cout << rheo << q;
    return 0;
}
