#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "torus.icc"
int main (int argc, char**argv) {
  environment rheolef (argc, argv);
  Float tol = (argc > 1) ? atof(argv[1]) : 1e-7;
  field uh;
  din >> uh;
  const space& Wh = uh.get_space();
  field pi_h_u = interpolate(Wh, u_exact());
  field eh = uh-pi_h_u;
  trial u (Wh); test v (Wh);
  form m = integrate (u*v);
  form a = integrate (dot(grad_s(u),grad_s(v)));
  field one (Wh, 1);
  Float meas_gamma = m(one,one);
  Float lambda_e = m(one,eh)/meas_gamma;
  eh = eh - lambda_e*one;
  Float err_l2 = sqrt(m(eh,eh))/meas_gamma;
  Float err_h1 = sqrt(a(eh,eh))/meas_gamma;
  Float err_linf = eh.max_abs();
  derr << "lambda_e = " << lambda_e << endl;
  derr << "err_l2   = " << err_l2 << endl
       << "err_h1   = " << err_h1 << endl
       << "err_linf = " << err_linf << endl;
  return (err_linf < tol) ? 0 : 1;
}
