% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{contour.stars}
\alias{contour.stars}
\title{plot contours of a stars object}
\usage{
\method{contour}{stars}(x, ...)
}
\arguments{
\item{x}{object of class \code{stars}}

\item{...}{other parameters passed on to \link[graphics]{contour}}
}
\description{
plot contours of a stars object
}
\details{
this uses the R internal contour algorithm, which (by default) plots contours; \link{st_contour} uses the GDAL contour algorithm that returns contours as simple features.
}
\examples{
d = st_dimensions(x = 1:ncol(volcano), y = 1:nrow(volcano))
r = st_as_stars(t(volcano))
r = st_set_dimensions(r, 1, offset = 0, delta = 1)
r = st_set_dimensions(r, 2, offset = 0, delta = -1)
plot(r, reset = FALSE)
contour(r, add = TRUE)
}
