% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection_deletereplica.R
\name{collection_deletereplica}
\alias{collection_deletereplica}
\title{Delete a replica}
\usage{
collection_deletereplica(conn, name, shard = NULL, replica = NULL,
  onlyIfDown = FALSE, raw = FALSE, callopts = list(), ...)
}
\arguments{
\item{conn}{A solrium connection object, see \link{SolrClient}}

\item{name}{(character) Required. The name of the collection.}

\item{shard}{(character) Required. The name of the shard that includes the replica to
be removed.}

\item{replica}{(character) Required. The name of the replica to remove.}

\item{onlyIfDown}{(logical) When \code{TRUE} will not take any action if the replica
is active. Default: \code{FALSE}}

\item{raw}{(logical) If \code{TRUE}, returns raw data}

\item{callopts}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}

\item{...}{You can pass in parameters like \code{property.name=value}    to set
core property name to value. See the section Defining core.properties for details on
supported properties and values.
(https://cwiki.apache.org/confluence/display/solr/Defining+core.properties)}
}
\description{
Delete a replica from a given collection and shard. If the
corresponding core is up and running the core is unloaded and the entry is
removed from the clusterstate. If the node/core is down , the entry is taken
off the clusterstate and if the core comes up later it is automatically
unregistered.
}
\examples{
\dontrun{
(conn <- SolrClient$new())

# create collection
if (!conn$collection_exists("foobar2")) {
  conn$collection_create(name = "foobar2", maxShardsPerNode = 2)
}

# status
conn$collection_clusterstatus()$cluster$collections$foobar2$shards$shard1

# add replica
conn$collection_addreplica(name = "foobar2", shard = "shard1")

# delete replica
## get replica name
nms <- names(conn$collection_clusterstatus()$cluster$collections$foobar2$shards$shard1$replicas)
conn$collection_deletereplica(name = "foobar2", shard = "shard1", replica = nms[1])

# status again
conn$collection_clusterstatus()$cluster$collections$foobar2$shards$shard1
}
}
