% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_slurm_array.R
\name{local_slurm_array}
\alias{local_slurm_array}
\title{Execute a Slurm job locally}
\usage{
local_slurm_array(slr_job, rscript_path = NULL)
}
\arguments{
\item{slr_job}{An object of class \code{slurm_job}.}

\item{rscript_path}{The location of the Rscript command. If not specified, 
defaults to the location of Rscript within the R installation being run.}
}
\description{
Run a previously created \code{slurm_job} object locally instead of on a
Slurm cluster
}
\details{
This function is most useful for testing your function on a reduced dataset
before submitting the full job to the Slurm cluster.

Call \code{local_slurm_array} on a \code{slurm_job} object created with
\code{slurm_apply(..., submit = FALSE)} or \code{slurm_map(..., submit = FALSE)}.
The job will run serially on the local system rather than being submitted
to the Slurm cluster.
}
\examples{
\dontrun{
sjob <- slurm_apply(func, pars, submit = FALSE)
local_slurm_array(sjob)
func_result <- get_slurm_out(sjob, "table") # Loads output data into R.
cleanup_files(sjob)
}
}
