% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_definitions.R
\name{lines.survmean}
\alias{lines.survmean}
\title{Graphically Inspect Curves Used in Mean Survival Computation}
\usage{
\method{lines}{survmean}(x, ...)
}
\arguments{
\item{x}{a \code{survmean} object}

\item{...}{arguments passed (ultimately) to \code{matlines}; you
may, therefore, supply e.g. \code{lwd} through this, though arguments
such as \code{lty} and \code{col} will not work}
}
\value{
Always returns \code{NULL} invisibly.
This function is called for its side effects.
}
\description{
Plots the observed (with extrapolation) and expected survival
curves for all strata in an object created by \verb{[survmean]}
}
\details{
This function is intended to be a workhorse for \verb{[plot.survmean]}.
If you want finer control over the plotted curves, extract the curves from
the \code{survmean} output using

\code{attr(x, "curves")}

where \code{x} is a \code{survmean} object.
}
\seealso{
Other survmean functions: 
\code{\link{Surv}()},
\code{\link{plot.survmean}()},
\code{\link{survmean}()}
}
\author{
Joonas Miettinen
}
\concept{survmean functions}
