% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group-by.r
\name{groups}
\alias{groups}
\alias{group_vars}
\title{Return grouping variables}
\usage{
groups(x)

group_vars(x)
}
\arguments{
\item{x}{A \code{\link[=tbl]{tbl()}}}
}
\description{
\code{group_vars()} returns a character vector; \code{groups()} returns a list of
symbols.
}
\examples{
df <- tibble(x = 1, y = 2) \%>\% group_by(x, y)
group_vars(df)
groups(df)
}
\seealso{
\code{\link[=group_cols]{group_cols()}} for matching grouping variables in
\link[=select]{selection contexts}.

Other grouping functions: \code{\link{group_by_all}},
  \code{\link{group_by}}, \code{\link{group_indices}},
  \code{\link{group_keys}}, \code{\link{group_map}},
  \code{\link{group_nest}}, \code{\link{group_rows}},
  \code{\link{group_size}}, \code{\link{group_trim}}
}
\concept{grouping functions}
