% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duration.R
\name{duration_cast}
\alias{duration_cast}
\title{Cast a duration between precisions}
\usage{
duration_cast(x, precision)
}
\arguments{
\item{x}{\verb{[clock_duration]}

A duration.}

\item{precision}{\verb{[character(1)]}

A precision. One of:
\itemize{
\item \code{"year"}
\item \code{"quarter"}
\item \code{"month"}
\item \code{"week"}
\item \code{"day"}
\item \code{"hour"}
\item \code{"minute"}
\item \code{"second"}
\item \code{"millisecond"}
\item \code{"microsecond"}
\item \code{"nanosecond"}
}}
}
\value{
\code{x} cast to the new \code{precision}.
}
\description{
Casting is one way to change a duration's precision.

Casting to a less precise precision will completely drop information that
is more precise than the precision that you are casting to. It does so
in a way that makes it round towards zero.

Casting to a more precise precision is done through a multiplication by
a conversion factor between the current precision and the new precision.
}
\details{
When you want to change to a less precise precision, you often want
\code{\link[=duration_floor]{duration_floor()}} instead of \code{duration_cast()}, as that rounds towards
negative infinity, which is generally the desired behavior when working with
time points (especially ones pre-1970, which are stored as negative
durations).
}
\examples{
x <- duration_seconds(c(86401, -86401))

# Casting rounds towards 0
cast <- duration_cast(x, "day")
cast

# Flooring rounds towards negative infinity
floor <- duration_floor(x, "day")
floor

# Flooring is generally more useful when working with time points,
# note that the cast ends up rounding the pre-1970 date up to the next
# day, while the post-1970 date is rounded down.
as_sys_time(x)
as_sys_time(cast)
as_sys_time(floor)

# Casting to a more precise precision
duration_cast(x, "millisecond")
}
