% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHeatmap.R
\name{plotHeatmap}
\alias{plotHeatmap}
\title{Plot heatmap of gene expression values}
\usage{
plotHeatmap(
  object,
  features,
  columns = NULL,
  exprs_values = "logcounts",
  center = FALSE,
  scale = FALSE,
  zlim = NULL,
  colour = color,
  color = NULL,
  colour_columns_by = color_columns_by,
  color_columns_by = NULL,
  column_annotation_colours = column_annotation_colors,
  column_annotation_colors = list(),
  row_annotation_colours = row_annotation_colors,
  row_annotation_colors = list(),
  colour_rows_by = color_rows_by,
  color_rows_by = NULL,
  order_columns_by = NULL,
  by_exprs_values = exprs_values,
  show_colnames = FALSE,
  cluster_cols = is.null(order_columns_by),
  swap_rownames = NULL,
  assay.type = exprs_values,
  by.assay.type = by_exprs_values,
  ...
)
}
\arguments{
\item{object}{A \linkS4class{SingleCellExperiment} object.}

\item{features}{A character (or factor) vector of row names, a logical vector, or integer vector of indices specifying rows of \code{object} to visualize. When using character or integer vectors, the ordering specified by the user is retained. When using factor vectors, ordering is controlled by the factor levels.}

\item{columns}{A vector specifying the subset of columns in \code{object} to show as columns in the heatmap. 
Also specifies the column order if \code{cluster_cols=FALSE} and \code{order_columns_by=NULL}.
By default, all columns are used.}

\item{exprs_values}{Alias to \code{assay.type}.}

\item{center}{A logical scalar indicating whether each feature should have its mean expression centered at zero prior to plotting.}

\item{scale}{A logical scalar specifying whether each feature should have its expression values scaled to have unit variance prior to plotting.}

\item{zlim}{A numeric vector of length 2, specifying the upper and lower bounds for colour mapping of expression values.
Values outside this range are set to the most extreme colour.
If \code{NULL}, it defaults to the range of the expression matrix.
If \code{center=TRUE}, this defaults to the range of the centered expression matrix, made symmetric around zero.}

\item{colour}{A vector of colours specifying the palette to use for increasing expression. 
This defaults to \link[viridis]{viridis} if \code{center=FALSE}, and the the \code{"RdYlBu"}
colour palette from \code{\link[RColorBrewer]{brewer.pal}} otherwise.}

\item{color, color_columns_by, column_annotation_colors, color_rows_by, row_annotation_colors}{Aliases to \code{color}, \code{color_columns_by},
\code{column_annotation_colors}, \code{color_rows_by}, 
\code{row_annotation_colors}.}

\item{colour_columns_by}{A list of values specifying how the columns should be annotated with colours.
Each entry of the list can be any acceptable input to the \code{by} argument in \code{?\link{retrieveCellInfo}}.
A character vector can also be supplied and will be treated as a list of strings.}

\item{column_annotation_colours}{A named list of colour scales to be used for
the column annotations specified in \code{colour_columns_by}. Names
should be character values present in \code{colour_columns_by},
If a colour scale is not specified for a particular annotation, a default
colour scale is chosen.
The full list of colour maps is passed to \code{\link[pheatmap]{pheatmap}} 
as the \code{annotation_colours} argument.}

\item{row_annotation_colours}{Similar to \code{column_annotation_colours} but 
relating to row annotation rather than column annotation.}

\item{colour_rows_by}{Similar to \code{colour_columns_by} but for rows rather
than columns. Each entry of the list can be any acceptable input to the 
\code{by} argument in \code{?\link{retrieveFeatureInfo}}.}

\item{order_columns_by}{A list of values specifying how the columns should be ordered.
Each entry of the list can be any acceptable input to the \code{by} argument in \code{?\link{retrieveCellInfo}}.
A character vector can also be supplied and will be treated as a list of strings.
This argument is automatically appended to \code{colour_columns_by}.}

\item{by_exprs_values}{Alias to {by.assay.type}.}

\item{show_colnames, cluster_cols, ...}{Additional arguments to pass to \code{\link[pheatmap]{pheatmap}}.}

\item{swap_rownames}{Column name of \code{rowData(object)} to be used to 
identify features instead of \code{rownames(object)} when labelling plot 
elements.}

\item{assay.type}{A string or integer scalar indicating which assay of \code{object} should be used as expression values.}

\item{by.assay.type}{A string or integer scalar specifying which assay to obtain expression values from, 
for colouring of column-level data - see the \code{assay.type} argument in \code{?\link{retrieveCellInfo}}.}
}
\value{
A heatmap is produced on the current graphics device. 
The output of \code{\link[pheatmap]{pheatmap}} is invisibly returned.
}
\description{
Create a heatmap of expression values for each cell and specified features in a SingleCellExperiment object.
}
\details{
Setting \code{center=TRUE} is useful for examining log-fold changes of each cell's expression profile from the average across all cells.
This avoids issues with the entire row appearing a certain colour because the gene is highly/lowly expressed across all cells.

Setting \code{zlim} preserves the dynamic range of colours in the presence  of outliers. 
Otherwise, the plot may be dominated by a few genes, which will \dQuote{flatten} the observed colours for the rest of the heatmap.

Setting \code{order_columns_by} is useful for automatically ordering the heatmap by one or more factors of interest, e.g., cluster identity.
This avoids the need to set \code{colour_columns_by}, \code{cluster_cols} and \code{columns} to achieve the same effect.
}
\examples{
example_sce <- mockSCE()
example_sce <- logNormCounts(example_sce)

plotHeatmap(example_sce, features=rownames(example_sce)[1:10])

plotHeatmap(example_sce, features=rownames(example_sce)[1:10],
    center=TRUE)

plotHeatmap(example_sce, features=rownames(example_sce)[1:10],
    colour_columns_by=c("Mutation_Status", "Cell_Cycle"))

}
\seealso{
\code{\link[pheatmap]{pheatmap}}
}
\author{
Aaron Lun
}
