//
// C++ Implementation: qcfog
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "qcfog.hpp"
#include <plib/ssg.h>

qcFog::qcFog(QObject *parent)
: QObject(parent)
{
  fogmode=0;
  foghint=0;
  fogdensity=0;
  fogstart=0;
  fogend=0;
  skyfogcol[0]=0.0;
  skyfogcol[1]=0.0;
  skyfogcol[2]=0.0;
  skyfogcol[3]=0.0;
}


qcFog::~qcFog()
{
}

void   qcFog::slot_update(float dt)
{
  Q_UNUSED(dt);
  // Fog
  glFogf ( GL_FOG_DENSITY, fogdensity );
  glFogfv( GL_FOG_COLOR  , skyfogcol ) ;
  glFogf ( GL_FOG_START  , fogstart ) ;
  glFogf ( GL_FOG_END  , fogend  ) ;
  
   switch(fogmode)      // linear , exp , exp2
   {
      case 0:     
        glFogi ( GL_FOG_MODE   , GL_LINEAR   ) ;
        break;
      case 1:
        glFogi ( GL_FOG_MODE   , GL_EXP   ) ;
        break;
      case 2:
        glFogi ( GL_FOG_MODE   , GL_EXP2   ) ;
        break;
   }

   switch(foghint)      // nicest
   {
      case 0:
        glHint ( GL_FOG_HINT   , GL_DONT_CARE ) ;
        break;
      case 1:
        glHint ( GL_FOG_HINT   , GL_FASTEST ) ;
        break;
      case 2:
        glHint ( GL_FOG_HINT   , GL_NICEST ) ;
        break;
   }

}

void qcFog::slot_preDraw()
{
  if(fogon){
    glEnable ( GL_FOG ) ;
  }
}

void qcFog::slot_postDraw()
{
  if(fogon){
    glDisable ( GL_FOG ) ;
  }
}

void qcFog::on()
{
  fogon=1;
}

void qcFog::off()
{
  fogon=0;
}
