#
# PySNMP MIB module BRIDGE-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/BRIDGE-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:06:39 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( OctetString, ObjectIdentifier, Integer, ) = mibBuilder.importSymbols("ASN1", "OctetString", "ObjectIdentifier", "Integer")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ValueRangeConstraint, ValueSizeConstraint, ConstraintsIntersection, SingleValueConstraint, ConstraintsUnion, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ValueRangeConstraint", "ValueSizeConstraint", "ConstraintsIntersection", "SingleValueConstraint", "ConstraintsUnion")
( InterfaceIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( NotificationType, Counter32, mib_2, Counter64, IpAddress, ObjectIdentity, Gauge32, Unsigned32, MibScalar, MibTable, MibTableRow, MibTableColumn, iso, Bits, MibIdentifier, TimeTicks, ModuleIdentity, Integer32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "NotificationType", "Counter32", "mib-2", "Counter64", "IpAddress", "ObjectIdentity", "Gauge32", "Unsigned32", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "iso", "Bits", "MibIdentifier", "TimeTicks", "ModuleIdentity", "Integer32")
( DisplayString, TextualConvention, MacAddress, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "TextualConvention", "MacAddress")
dot1dBridge = ModuleIdentity((1, 3, 6, 1, 2, 1, 17)).setRevisions(("2005-09-19 00:00", "1993-07-31 00:00", "1991-12-31 00:00",))
if mibBuilder.loadTexts: dot1dBridge.setLastUpdated('200509190000Z')
if mibBuilder.loadTexts: dot1dBridge.setOrganization('IETF Bridge MIB Working Group')
if mibBuilder.loadTexts: dot1dBridge.setContactInfo('Email: bridge-mib@ietf.org\n\n                    K.C. Norseth (Editor)\n                    L-3 Communications\n               Tel: +1 801-594-2809\n             Email: kenyon.c.norseth@L-3com.com\n            Postal: 640 N. 2200 West.\n                    Salt Lake City, Utah 84116-0850\n                    Les Bell (Editor)\n                    3Com Europe Limited\n             Phone: +44 1442 438025\n             Email: elbell@ntlworld.com\n            Postal: 3Com Centre, Boundary Way\n                    Hemel Hempstead\n                    Herts.  HP2 7YU\n                    UK\n\n            Send comments to <bridge-mib@ietf.org>')
if mibBuilder.loadTexts: dot1dBridge.setDescription('The Bridge MIB module for managing devices that support\n           IEEE 802.1D.\n\n           Copyright (C) The Internet Society (2005).  This version of\n           this MIB module is part of RFC 4188; see the RFC itself for\n           full legal notices.')
class BridgeId(OctetString, TextualConvention):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(8,8)
    fixedLength = 8

class Timeout(Integer32, TextualConvention):
    displayHint = 'd'

dot1dNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 0))
dot1dBase = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 1))
dot1dStp = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 2))
dot1dSr = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 3))
dot1dTp = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 4))
dot1dStatic = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 5))
dot1dConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 8))
dot1dBaseBridgeAddress = MibScalar((1, 3, 6, 1, 2, 1, 17, 1, 1), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dBaseBridgeAddress.setDescription('The MAC address used by this bridge when it must be\n           referred to in a unique fashion.  It is recommended\n           that this be the numerically smallest MAC address of\n           all ports that belong to this bridge.  However, it is only\n           required to be unique.  When concatenated with\n           dot1dStpPriority, a unique BridgeIdentifier is formed,\n           which is used in the Spanning Tree Protocol.')
dot1dBaseNumPorts = MibScalar((1, 3, 6, 1, 2, 1, 17, 1, 2), Integer32()).setUnits('ports').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dBaseNumPorts.setDescription('The number of ports controlled by this bridging\n           entity.')
dot1dBaseType = MibScalar((1, 3, 6, 1, 2, 1, 17, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("unknown", 1), ("transparent-only", 2), ("sourceroute-only", 3), ("srt", 4),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dBaseType.setDescription('Indicates what type of bridging this bridge can\n           perform.  If a bridge is actually performing a\n           certain type of bridging, this will be indicated by\n           entries in the port table for the given type.')
dot1dBasePortTable = MibTable((1, 3, 6, 1, 2, 1, 17, 1, 4), )
if mibBuilder.loadTexts: dot1dBasePortTable.setDescription('A table that contains generic information about every\n           port that is associated with this bridge.  Transparent,\n           source-route, and srt ports are included.')
dot1dBasePortEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 1, 4, 1), ).setIndexNames((0, "BRIDGE-MIB", "dot1dBasePort"))
if mibBuilder.loadTexts: dot1dBasePortEntry.setDescription('A list of information for each port of the bridge.')
dot1dBasePort = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 1, 4, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dBasePort.setDescription('The port number of the port for which this entry\n           contains bridge management information.')
dot1dBasePortIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 1, 4, 1, 2), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dBasePortIfIndex.setDescription('The value of the instance of the ifIndex object,\n           defined in IF-MIB, for the interface corresponding\n           to this port.')
dot1dBasePortCircuit = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 1, 4, 1, 3), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dBasePortCircuit.setDescription('For a port that (potentially) has the same value of\n           dot1dBasePortIfIndex as another port on the same bridge.\n           This object contains the name of an object instance\n           unique to this port.  For example, in the case where\n           multiple ports correspond one-to-one with multiple X.25\n           virtual circuits, this value might identify an (e.g.,\n           the first) object instance associated with the X.25\n           virtual circuit corresponding to this port.\n\n           For a port which has a unique value of\n           dot1dBasePortIfIndex, this object can have the value\n           { 0 0 }.')
dot1dBasePortDelayExceededDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 1, 4, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dBasePortDelayExceededDiscards.setDescription('The number of frames discarded by this port due\n           to excessive transit delay through the bridge.  It\n           is incremented by both transparent and source\n           route bridges.')
dot1dBasePortMtuExceededDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 1, 4, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dBasePortMtuExceededDiscards.setDescription('The number of frames discarded by this port due\n           to an excessive size.  It is incremented by both\n           transparent and source route bridges.')
dot1dStpProtocolSpecification = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("unknown", 1), ("decLb100", 2), ("ieee8021d", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpProtocolSpecification.setDescription("An indication of what version of the Spanning Tree\n           Protocol is being run.  The value 'decLb100(2)'\n           indicates the DEC LANbridge 100 Spanning Tree protocol.\n           IEEE 802.1D implementations will return 'ieee8021d(3)'.\n           If future versions of the IEEE Spanning Tree Protocol\n           that are incompatible with the current version\n           are released a new value will be defined.")
dot1dStpPriority = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1dStpPriority.setDescription('The value of the write-able portion of the Bridge ID\n           (i.e., the first two octets of the (8 octet long) Bridge\n           ID).  The other (last) 6 octets of the Bridge ID are\n           given by the value of dot1dBaseBridgeAddress.\n           On bridges supporting IEEE 802.1t or IEEE 802.1w,\n           permissible values are 0-61440, in steps of 4096.')
dot1dStpTimeSinceTopologyChange = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 3), TimeTicks()).setUnits('centi-seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpTimeSinceTopologyChange.setDescription('The time (in hundredths of a second) since the\n           last time a topology change was detected by the\n           bridge entity.\n           For RSTP, this reports the time since the tcWhile\n           timer for any port on this Bridge was nonzero.')
dot1dStpTopChanges = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpTopChanges.setDescription('The total number of topology changes detected by\n           this bridge since the management entity was last\n           reset or initialized.')
dot1dStpDesignatedRoot = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 5), BridgeId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpDesignatedRoot.setDescription('The bridge identifier of the root of the spanning\n           tree, as determined by the Spanning Tree Protocol,\n           as executed by this node.  This value is used as\n           the Root Identifier parameter in all Configuration\n           Bridge PDUs originated by this node.')
dot1dStpRootCost = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 6), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpRootCost.setDescription('The cost of the path to the root as seen from\n           this bridge.')
dot1dStpRootPort = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpRootPort.setDescription('The port number of the port that offers the lowest\n           cost path from this bridge to the root bridge.')
dot1dStpMaxAge = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 8), Timeout()).setUnits('centi-seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpMaxAge.setDescription('The maximum age of Spanning Tree Protocol information\n           learned from the network on any port before it is\n           discarded, in units of hundredths of a second.  This is\n           the actual value that this bridge is currently using.')
dot1dStpHelloTime = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 9), Timeout()).setUnits('centi-seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpHelloTime.setDescription('The amount of time between the transmission of\n           Configuration bridge PDUs by this node on any port when\n           it is the root of the spanning tree, or trying to become\n           so, in units of hundredths of a second.  This is the\n           actual value that this bridge is currently using.')
dot1dStpHoldTime = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 10), Integer32()).setUnits('centi-seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpHoldTime.setDescription('This time value determines the interval length\n           during which no more than two Configuration bridge\n           PDUs shall be transmitted by this node, in units\n           of hundredths of a second.')
dot1dStpForwardDelay = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 11), Timeout()).setUnits('centi-seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpForwardDelay.setDescription('This time value, measured in units of hundredths of a\n           second, controls how fast a port changes its spanning\n           state when moving towards the Forwarding state.  The\n           value determines how long the port stays in each of the\n           Listening and Learning states, which precede the\n           Forwarding state.  This value is also used when a\n           topology change has been detected and is underway, to\n           age all dynamic entries in the Forwarding Database.\n           [Note that this value is the one that this bridge is\n           currently using, in contrast to\n           dot1dStpBridgeForwardDelay, which is the value that this\n           bridge and all others would start using if/when this\n           bridge were to become the root.]')
dot1dStpBridgeMaxAge = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 12), Timeout().subtype(subtypeSpec=ValueRangeConstraint(600,4000))).setUnits('centi-seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1dStpBridgeMaxAge.setDescription('The value that all bridges use for MaxAge when this\n           bridge is acting as the root.  Note that 802.1D-1998\n           specifies that the range for this parameter is related\n           to the value of dot1dStpBridgeHelloTime.  The\n           granularity of this timer is specified by 802.1D-1998 to\n           be 1 second.  An agent may return a badValue error if a\n           set is attempted to a value that is not a whole number\n           of seconds.')
dot1dStpBridgeHelloTime = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 13), Timeout().subtype(subtypeSpec=ValueRangeConstraint(100,1000))).setUnits('centi-seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1dStpBridgeHelloTime.setDescription('The value that all bridges use for HelloTime when this\n           bridge is acting as the root.  The granularity of this\n           timer is specified by 802.1D-1998 to be 1 second.  An\n           agent may return a badValue error if a set is attempted\n           to a value that is not a whole number of seconds.')
dot1dStpBridgeForwardDelay = MibScalar((1, 3, 6, 1, 2, 1, 17, 2, 14), Timeout().subtype(subtypeSpec=ValueRangeConstraint(400,3000))).setUnits('centi-seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1dStpBridgeForwardDelay.setDescription('The value that all bridges use for ForwardDelay when\n           this bridge is acting as the root.  Note that\n           802.1D-1998 specifies that the range for this parameter\n           is related to the value of dot1dStpBridgeMaxAge.  The\n           granularity of this timer is specified by 802.1D-1998 to\n           be 1 second.  An agent may return a badValue error if a\n           set is attempted to a value that is not a whole number\n           of seconds.')
dot1dStpPortTable = MibTable((1, 3, 6, 1, 2, 1, 17, 2, 15), )
if mibBuilder.loadTexts: dot1dStpPortTable.setDescription('A table that contains port-specific information\n           for the Spanning Tree Protocol.')
dot1dStpPortEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 2, 15, 1), ).setIndexNames((0, "BRIDGE-MIB", "dot1dStpPort"))
if mibBuilder.loadTexts: dot1dStpPortEntry.setDescription('A list of information maintained by every port about\n           the Spanning Tree Protocol state for that port.')
dot1dStpPort = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpPort.setDescription('The port number of the port for which this entry\n           contains Spanning Tree Protocol management information.')
dot1dStpPortPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1dStpPortPriority.setDescription('The value of the priority field that is contained in\n           the first (in network byte order) octet of the (2 octet\n           long) Port ID.  The other octet of the Port ID is given\n           by the value of dot1dStpPort.\n           On bridges supporting IEEE 802.1t or IEEE 802.1w,\n           permissible values are 0-240, in steps of 16.')
dot1dStpPortState = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6,))).clone(namedValues=NamedValues(("disabled", 1), ("blocking", 2), ("listening", 3), ("learning", 4), ("forwarding", 5), ("broken", 6),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpPortState.setDescription("The port's current state, as defined by application of\n           the Spanning Tree Protocol.  This state controls what\n           action a port takes on reception of a frame.  If the\n           bridge has detected a port that is malfunctioning, it\n           will place that port into the broken(6) state.  For\n           ports that are disabled (see dot1dStpPortEnable), this\n           object will have a value of disabled(1).")
dot1dStpPortEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("enabled", 1), ("disabled", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1dStpPortEnable.setDescription('The enabled/disabled status of the port.')
dot1dStpPortPathCost = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1dStpPortPathCost.setDescription('The contribution of this port to the path cost of\n           paths towards the spanning tree root which include\n           this port.  802.1D-1998 recommends that the default\n           value of this parameter be in inverse proportion to\n           the speed of the attached LAN.\n\n           New implementations should support dot1dStpPortPathCost32.\n           If the port path costs exceeds the maximum value of this\n           object then this object should report the maximum value,\n           namely 65535.  Applications should try to read the\n           dot1dStpPortPathCost32 object if this object reports\n           the maximum value.')
dot1dStpPortDesignatedRoot = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 6), BridgeId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpPortDesignatedRoot.setDescription('The unique Bridge Identifier of the Bridge\n           recorded as the Root in the Configuration BPDUs\n           transmitted by the Designated Bridge for the\n           segment to which the port is attached.')
dot1dStpPortDesignatedCost = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpPortDesignatedCost.setDescription('The path cost of the Designated Port of the segment\n           connected to this port.  This value is compared to the\n           Root Path Cost field in received bridge PDUs.')
dot1dStpPortDesignatedBridge = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 8), BridgeId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpPortDesignatedBridge.setDescription("The Bridge Identifier of the bridge that this\n           port considers to be the Designated Bridge for\n           this port's segment.")
dot1dStpPortDesignatedPort = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 9), OctetString().subtype(subtypeSpec=ValueSizeConstraint(2,2)).setFixedLength(2)).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpPortDesignatedPort.setDescription("The Port Identifier of the port on the Designated\n           Bridge for this port's segment.")
dot1dStpPortForwardTransitions = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dStpPortForwardTransitions.setDescription('The number of times this port has transitioned\n           from the Learning state to the Forwarding state.')
dot1dStpPortPathCost32 = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 11), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,200000000))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1dStpPortPathCost32.setDescription('The contribution of this port to the path cost of\n           paths towards the spanning tree root which include\n           this port.  802.1D-1998 recommends that the default\n           value of this parameter be in inverse proportion to\n           the speed of the attached LAN.\n\n           This object replaces dot1dStpPortPathCost to support\n           IEEE 802.1t.')
dot1dTpLearnedEntryDiscards = MibScalar((1, 3, 6, 1, 2, 1, 17, 4, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dTpLearnedEntryDiscards.setDescription('The total number of Forwarding Database entries that\n           have been or would have been learned, but have been\n           discarded due to a lack of storage space in the\n           Forwarding Database.  If this counter is increasing, it\n           indicates that the Forwarding Database is regularly\n           becoming full (a condition that has unpleasant\n           performance effects on the subnetwork).  If this counter\n           has a significant value but is not presently increasing,\n           it indicates that the problem has been occurring but is\n           not persistent.')
dot1dTpAgingTime = MibScalar((1, 3, 6, 1, 2, 1, 17, 4, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(10,1000000))).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1dTpAgingTime.setDescription('The timeout period in seconds for aging out\n           dynamically-learned forwarding information.\n           802.1D-1998 recommends a default of 300 seconds.')
dot1dTpFdbTable = MibTable((1, 3, 6, 1, 2, 1, 17, 4, 3), )
if mibBuilder.loadTexts: dot1dTpFdbTable.setDescription('A table that contains information about unicast\n           entries for which the bridge has forwarding and/or\n           filtering information.  This information is used\n           by the transparent bridging function in\n           determining how to propagate a received frame.')
dot1dTpFdbEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 4, 3, 1), ).setIndexNames((0, "BRIDGE-MIB", "dot1dTpFdbAddress"))
if mibBuilder.loadTexts: dot1dTpFdbEntry.setDescription('Information about a specific unicast MAC address\n           for which the bridge has some forwarding and/or\n           filtering information.')
dot1dTpFdbAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 4, 3, 1, 1), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dTpFdbAddress.setDescription('A unicast MAC address for which the bridge has\n           forwarding and/or filtering information.')
dot1dTpFdbPort = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 4, 3, 1, 2), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dTpFdbPort.setDescription("Either the value '0', or the port number of the port on\n           which a frame having a source address equal to the value\n           of the corresponding instance of dot1dTpFdbAddress has\n           been seen.  A value of '0' indicates that the port\n           number has not been learned, but that the bridge does\n           have some forwarding/filtering information about this\n           address (e.g., in the dot1dStaticTable).  Implementors\n           are encouraged to assign the port value to this object\n           whenever it is learned, even for addresses for which the\n           corresponding value of dot1dTpFdbStatus is not\n           learned(3).")
dot1dTpFdbStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 4, 3, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))).clone(namedValues=NamedValues(("other", 1), ("invalid", 2), ("learned", 3), ("self", 4), ("mgmt", 5),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dTpFdbStatus.setDescription("The status of this entry.  The meanings of the\n           values are:\n               other(1) - none of the following.  This would\n                   include the case where some other MIB object\n                   (not the corresponding instance of\n                   dot1dTpFdbPort, nor an entry in the\n                   dot1dStaticTable) is being used to determine if\n                   and how frames addressed to the value of the\n                   corresponding instance of dot1dTpFdbAddress are\n                   being forwarded.\n               invalid(2) - this entry is no longer valid (e.g.,\n                   it was learned but has since aged out), but has\n                   not yet been flushed from the table.\n               learned(3) - the value of the corresponding instance\n                   of dot1dTpFdbPort was learned, and is being\n                   used.\n               self(4) - the value of the corresponding instance of\n                   dot1dTpFdbAddress represents one of the bridge's\n                   addresses.  The corresponding instance of\n                   dot1dTpFdbPort indicates which of the bridge's\n                   ports has this address.\n               mgmt(5) - the value of the corresponding instance of\n                   dot1dTpFdbAddress is also the value of an\n                   existing instance of dot1dStaticAddress.")
dot1dTpPortTable = MibTable((1, 3, 6, 1, 2, 1, 17, 4, 4), )
if mibBuilder.loadTexts: dot1dTpPortTable.setDescription('A table that contains information about every port that\n           is associated with this transparent bridge.')
dot1dTpPortEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 4, 4, 1), ).setIndexNames((0, "BRIDGE-MIB", "dot1dTpPort"))
if mibBuilder.loadTexts: dot1dTpPortEntry.setDescription('A list of information for each port of a transparent\n           bridge.')
dot1dTpPort = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 4, 4, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dTpPort.setDescription('The port number of the port for which this entry\n           contains Transparent bridging management information.')
dot1dTpPortMaxInfo = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 4, 4, 1, 2), Integer32()).setUnits('bytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dTpPortMaxInfo.setDescription('The maximum size of the INFO (non-MAC) field that\n           this port will receive or transmit.')
dot1dTpPortInFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 4, 4, 1, 3), Counter32()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dTpPortInFrames.setDescription('The number of frames that have been received by this\n           port from its segment.  Note that a frame received on the\n           interface corresponding to this port is only counted by\n           this object if and only if it is for a protocol being\n           processed by the local bridging function, including\n           bridge management frames.')
dot1dTpPortOutFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 4, 4, 1, 4), Counter32()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dTpPortOutFrames.setDescription('The number of frames that have been transmitted by this\n           port to its segment.  Note that a frame transmitted on\n           the interface corresponding to this port is only counted\n           by this object if and only if it is for a protocol being\n           processed by the local bridging function, including\n           bridge management frames.')
dot1dTpPortInDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 4, 4, 1, 5), Counter32()).setUnits('frames').setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dTpPortInDiscards.setDescription('Count of received valid frames that were discarded\n           (i.e., filtered) by the Forwarding Process.')
dot1dStaticTable = MibTable((1, 3, 6, 1, 2, 1, 17, 5, 1), )
if mibBuilder.loadTexts: dot1dStaticTable.setDescription('A table containing filtering information configured\n           into the bridge by (local or network) management\n           specifying the set of ports to which frames received\n           from specific ports and containing specific destination\n           addresses are allowed to be forwarded.  The value of\n           zero in this table, as the port number from which frames\n           with a specific destination address are received, is\n           used to specify all ports for which there is no specific\n           entry in this table for that particular destination\n           address.  Entries are valid for unicast and for\n           group/broadcast addresses.')
dot1dStaticEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 5, 1, 1), ).setIndexNames((0, "BRIDGE-MIB", "dot1dStaticAddress"), (0, "BRIDGE-MIB", "dot1dStaticReceivePort"))
if mibBuilder.loadTexts: dot1dStaticEntry.setDescription('Filtering information configured into the bridge by\n           (local or network) management specifying the set of\n           ports to which frames received from a specific port and\n           containing a specific destination address are allowed to\n           be forwarded.')
dot1dStaticAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 5, 1, 1, 1), MacAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dot1dStaticAddress.setDescription("The destination MAC address in a frame to which this\n           entry's filtering information applies.  This object can\n           take the value of a unicast address, a group address, or\n           the broadcast address.")
dot1dStaticReceivePort = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 5, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dot1dStaticReceivePort.setDescription("Either the value '0', or the port number of the port\n           from which a frame must be received in order for this\n           entry's filtering information to apply.  A value of zero\n           indicates that this entry applies on all ports of the\n           bridge for which there is no other applicable entry.")
dot1dStaticAllowedToGoTo = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 5, 1, 1, 3), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,512))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dot1dStaticAllowedToGoTo.setDescription("The set of ports to which frames received from a\n           specific port and destined for a specific MAC address,\n           are allowed to be forwarded.  Each octet within the\n           value of this object specifies a set of eight ports,\n           with the first octet specifying ports 1 through 8, the\n           second octet specifying ports 9 through 16, etc.  Within\n           each octet, the most significant bit represents the\n           lowest numbered port, and the least significant bit\n           represents the highest numbered port.  Thus, each port\n           of the bridge is represented by a single bit within the\n           value of this object.  If that bit has a value of '1',\n           then that port is included in the set of ports; the port\n           is not included if its bit has a value of '0'.  (Note\n           that the setting of the bit corresponding to the port\n           from which a frame is received is irrelevant.)  The\n           default value of this object is a string of ones of\n           appropriate length.\n           The value of this object may exceed the required minimum\n           maximum message size of some SNMP transport (484 bytes,\n           in the case of SNMP over UDP, see RFC 3417, section 3.2).\n           SNMP engines on bridges supporting a large number of\n           ports must support appropriate maximum message sizes.")
dot1dStaticStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 5, 1, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))).clone(namedValues=NamedValues(("other", 1), ("invalid", 2), ("permanent", 3), ("deleteOnReset", 4), ("deleteOnTimeout", 5),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dot1dStaticStatus.setDescription('This object indicates the status of this entry.\n           The default value is permanent(3).\n               other(1) - this entry is currently in use but the\n                   conditions under which it will remain so are\n                   different from each of the following values.\n               invalid(2) - writing this value to the object\n                   removes the corresponding entry.\n               permanent(3) - this entry is currently in use and\n                   will remain so after the next reset of the\n                   bridge.\n               deleteOnReset(4) - this entry is currently in use\n                   and will remain so until the next reset of the\n                   bridge.\n               deleteOnTimeout(5) - this entry is currently in use\n                   and will remain so until it is aged out.')
newRoot = NotificationType((1, 3, 6, 1, 2, 1, 17, 0, 1)).setObjects(*())
if mibBuilder.loadTexts: newRoot.setDescription('The newRoot trap indicates that the sending agent has\n           become the new root of the Spanning Tree; the trap is\n           sent by a bridge soon after its election as the new\n           root, e.g., upon expiration of the Topology Change Timer,\n           immediately subsequent to its election.  Implementation\n           of this trap is optional.')
topologyChange = NotificationType((1, 3, 6, 1, 2, 1, 17, 0, 2)).setObjects(*())
if mibBuilder.loadTexts: topologyChange.setDescription('A topologyChange trap is sent by a bridge when any of\n           its configured ports transitions from the Learning state\n           to the Forwarding state, or from the Forwarding state to\n           the Blocking state.  The trap is not sent if a newRoot\n           trap is sent for the same transition.  Implementation of\n           this trap is optional.')
dot1dGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 8, 1))
dot1dCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 8, 2))
dot1dBaseBridgeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 8, 1, 1)).setObjects(*(("BRIDGE-MIB", "dot1dBaseBridgeAddress"), ("BRIDGE-MIB", "dot1dBaseNumPorts"), ("BRIDGE-MIB", "dot1dBaseType"),))
if mibBuilder.loadTexts: dot1dBaseBridgeGroup.setDescription('Bridge level information for this device.')
dot1dBasePortGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 8, 1, 2)).setObjects(*(("BRIDGE-MIB", "dot1dBasePort"), ("BRIDGE-MIB", "dot1dBasePortIfIndex"), ("BRIDGE-MIB", "dot1dBasePortCircuit"), ("BRIDGE-MIB", "dot1dBasePortDelayExceededDiscards"), ("BRIDGE-MIB", "dot1dBasePortMtuExceededDiscards"),))
if mibBuilder.loadTexts: dot1dBasePortGroup.setDescription('Information for each port on this device.')
dot1dStpBridgeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 8, 1, 3)).setObjects(*(("BRIDGE-MIB", "dot1dStpProtocolSpecification"), ("BRIDGE-MIB", "dot1dStpPriority"), ("BRIDGE-MIB", "dot1dStpTimeSinceTopologyChange"), ("BRIDGE-MIB", "dot1dStpTopChanges"), ("BRIDGE-MIB", "dot1dStpDesignatedRoot"), ("BRIDGE-MIB", "dot1dStpRootCost"), ("BRIDGE-MIB", "dot1dStpRootPort"), ("BRIDGE-MIB", "dot1dStpMaxAge"), ("BRIDGE-MIB", "dot1dStpHelloTime"), ("BRIDGE-MIB", "dot1dStpHoldTime"), ("BRIDGE-MIB", "dot1dStpForwardDelay"), ("BRIDGE-MIB", "dot1dStpBridgeMaxAge"), ("BRIDGE-MIB", "dot1dStpBridgeHelloTime"), ("BRIDGE-MIB", "dot1dStpBridgeForwardDelay"),))
if mibBuilder.loadTexts: dot1dStpBridgeGroup.setDescription('Bridge level Spanning Tree data for this device.')
dot1dStpPortGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 8, 1, 4)).setObjects(*(("BRIDGE-MIB", "dot1dStpPort"), ("BRIDGE-MIB", "dot1dStpPortPriority"), ("BRIDGE-MIB", "dot1dStpPortState"), ("BRIDGE-MIB", "dot1dStpPortEnable"), ("BRIDGE-MIB", "dot1dStpPortPathCost"), ("BRIDGE-MIB", "dot1dStpPortDesignatedRoot"), ("BRIDGE-MIB", "dot1dStpPortDesignatedCost"), ("BRIDGE-MIB", "dot1dStpPortDesignatedBridge"), ("BRIDGE-MIB", "dot1dStpPortDesignatedPort"), ("BRIDGE-MIB", "dot1dStpPortForwardTransitions"),))
if mibBuilder.loadTexts: dot1dStpPortGroup.setDescription('Spanning Tree data for each port on this device.')
dot1dStpPortGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 8, 1, 5)).setObjects(*(("BRIDGE-MIB", "dot1dStpPort"), ("BRIDGE-MIB", "dot1dStpPortPriority"), ("BRIDGE-MIB", "dot1dStpPortState"), ("BRIDGE-MIB", "dot1dStpPortEnable"), ("BRIDGE-MIB", "dot1dStpPortDesignatedRoot"), ("BRIDGE-MIB", "dot1dStpPortDesignatedCost"), ("BRIDGE-MIB", "dot1dStpPortDesignatedBridge"), ("BRIDGE-MIB", "dot1dStpPortDesignatedPort"), ("BRIDGE-MIB", "dot1dStpPortForwardTransitions"), ("BRIDGE-MIB", "dot1dStpPortPathCost32"),))
if mibBuilder.loadTexts: dot1dStpPortGroup2.setDescription('Spanning Tree data for each port on this device.')
dot1dStpPortGroup3 = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 8, 1, 6)).setObjects(*(("BRIDGE-MIB", "dot1dStpPortPathCost32"),))
if mibBuilder.loadTexts: dot1dStpPortGroup3.setDescription('Spanning Tree data for devices supporting 32-bit\n            path costs.')
dot1dTpBridgeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 8, 1, 7)).setObjects(*(("BRIDGE-MIB", "dot1dTpLearnedEntryDiscards"), ("BRIDGE-MIB", "dot1dTpAgingTime"),))
if mibBuilder.loadTexts: dot1dTpBridgeGroup.setDescription('Bridge level Transparent Bridging data.')
dot1dTpFdbGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 8, 1, 8)).setObjects(*(("BRIDGE-MIB", "dot1dTpFdbAddress"), ("BRIDGE-MIB", "dot1dTpFdbPort"), ("BRIDGE-MIB", "dot1dTpFdbStatus"),))
if mibBuilder.loadTexts: dot1dTpFdbGroup.setDescription('Filtering Database information for the Bridge.')
dot1dTpGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 8, 1, 9)).setObjects(*(("BRIDGE-MIB", "dot1dTpPort"), ("BRIDGE-MIB", "dot1dTpPortMaxInfo"), ("BRIDGE-MIB", "dot1dTpPortInFrames"), ("BRIDGE-MIB", "dot1dTpPortOutFrames"), ("BRIDGE-MIB", "dot1dTpPortInDiscards"),))
if mibBuilder.loadTexts: dot1dTpGroup.setDescription('Dynamic Filtering Database information for each port of\n           the Bridge.')
dot1dStaticGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 8, 1, 10)).setObjects(*(("BRIDGE-MIB", "dot1dStaticAddress"), ("BRIDGE-MIB", "dot1dStaticReceivePort"), ("BRIDGE-MIB", "dot1dStaticAllowedToGoTo"), ("BRIDGE-MIB", "dot1dStaticStatus"),))
if mibBuilder.loadTexts: dot1dStaticGroup.setDescription('Static Filtering Database information for each port of\n           the Bridge.')
dot1dNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 17, 8, 1, 11)).setObjects(*(("BRIDGE-MIB", "newRoot"), ("BRIDGE-MIB", "topologyChange"),))
if mibBuilder.loadTexts: dot1dNotificationGroup.setDescription('Group of objects describing notifications (traps).')
bridgeCompliance1493 = ModuleCompliance((1, 3, 6, 1, 2, 1, 17, 8, 2, 1)).setObjects(*(("BRIDGE-MIB", "dot1dBaseBridgeGroup"), ("BRIDGE-MIB", "dot1dBasePortGroup"), ("BRIDGE-MIB", "dot1dStpBridgeGroup"), ("BRIDGE-MIB", "dot1dStpPortGroup"), ("BRIDGE-MIB", "dot1dTpBridgeGroup"), ("BRIDGE-MIB", "dot1dTpFdbGroup"), ("BRIDGE-MIB", "dot1dTpGroup"), ("BRIDGE-MIB", "dot1dStaticGroup"), ("BRIDGE-MIB", "dot1dNotificationGroup"),))
if mibBuilder.loadTexts: bridgeCompliance1493.setDescription('The compliance statement for device support of bridging\n           services, as per RFC1493.')
bridgeCompliance4188 = ModuleCompliance((1, 3, 6, 1, 2, 1, 17, 8, 2, 2)).setObjects(*(("BRIDGE-MIB", "dot1dBaseBridgeGroup"), ("BRIDGE-MIB", "dot1dBasePortGroup"), ("BRIDGE-MIB", "dot1dStpBridgeGroup"), ("BRIDGE-MIB", "dot1dStpPortGroup2"), ("BRIDGE-MIB", "dot1dStpPortGroup3"), ("BRIDGE-MIB", "dot1dTpBridgeGroup"), ("BRIDGE-MIB", "dot1dTpFdbGroup"), ("BRIDGE-MIB", "dot1dTpGroup"), ("BRIDGE-MIB", "dot1dStaticGroup"), ("BRIDGE-MIB", "dot1dNotificationGroup"),))
if mibBuilder.loadTexts: bridgeCompliance4188.setDescription('The compliance statement for device support of bridging\n           services.  This supports 32-bit Path Cost values and the\n           more restricted bridge and port priorities, as per IEEE\n           802.1t.\n\n           Full support for the 802.1D management objects requires that\n           the SNMPv2-MIB [RFC3418] objects sysDescr, and sysUpTime, as\n           well as the IF-MIB [RFC2863] objects ifIndex, ifType,\n           ifDescr, ifPhysAddress, and ifLastChange are implemented.')
mibBuilder.exportSymbols("BRIDGE-MIB", dot1dStpPortGroup2=dot1dStpPortGroup2, dot1dStpHelloTime=dot1dStpHelloTime, dot1dStp=dot1dStp, dot1dBasePortMtuExceededDiscards=dot1dBasePortMtuExceededDiscards, dot1dTpGroup=dot1dTpGroup, dot1dStaticAllowedToGoTo=dot1dStaticAllowedToGoTo, dot1dStpPortDesignatedRoot=dot1dStpPortDesignatedRoot, dot1dStpPort=dot1dStpPort, dot1dStpPortDesignatedPort=dot1dStpPortDesignatedPort, dot1dStpTimeSinceTopologyChange=dot1dStpTimeSinceTopologyChange, dot1dStpPortForwardTransitions=dot1dStpPortForwardTransitions, dot1dBaseNumPorts=dot1dBaseNumPorts, dot1dTpAgingTime=dot1dTpAgingTime, dot1dTpFdbEntry=dot1dTpFdbEntry, dot1dTpFdbPort=dot1dTpFdbPort, dot1dTpPort=dot1dTpPort, dot1dStaticTable=dot1dStaticTable, newRoot=newRoot, dot1dStpPriority=dot1dStpPriority, dot1dBridge=dot1dBridge, dot1dTpLearnedEntryDiscards=dot1dTpLearnedEntryDiscards, dot1dTpPortMaxInfo=dot1dTpPortMaxInfo, dot1dBasePortTable=dot1dBasePortTable, dot1dBasePortGroup=dot1dBasePortGroup, dot1dStpBridgeGroup=dot1dStpBridgeGroup, dot1dStpPortGroup3=dot1dStpPortGroup3, dot1dTpPortInFrames=dot1dTpPortInFrames, dot1dStaticEntry=dot1dStaticEntry, dot1dStpPortTable=dot1dStpPortTable, dot1dTpFdbStatus=dot1dTpFdbStatus, dot1dBasePortCircuit=dot1dBasePortCircuit, dot1dStpPortDesignatedBridge=dot1dStpPortDesignatedBridge, dot1dStpMaxAge=dot1dStpMaxAge, dot1dTpPortOutFrames=dot1dTpPortOutFrames, dot1dBasePort=dot1dBasePort, dot1dTpPortInDiscards=dot1dTpPortInDiscards, bridgeCompliance1493=bridgeCompliance1493, dot1dStaticStatus=dot1dStaticStatus, bridgeCompliance4188=bridgeCompliance4188, dot1dStpPortEntry=dot1dStpPortEntry, dot1dStaticReceivePort=dot1dStaticReceivePort, dot1dConformance=dot1dConformance, dot1dStpPortPathCost32=dot1dStpPortPathCost32, dot1dStaticAddress=dot1dStaticAddress, dot1dTpPortTable=dot1dTpPortTable, dot1dStaticGroup=dot1dStaticGroup, dot1dTpPortEntry=dot1dTpPortEntry, dot1dBasePortEntry=dot1dBasePortEntry, dot1dStpRootCost=dot1dStpRootCost, Timeout=Timeout, dot1dStpPortGroup=dot1dStpPortGroup, dot1dStpRootPort=dot1dStpRootPort, dot1dStpBridgeMaxAge=dot1dStpBridgeMaxAge, dot1dStpProtocolSpecification=dot1dStpProtocolSpecification, BridgeId=BridgeId, dot1dStpHoldTime=dot1dStpHoldTime, PYSNMP_MODULE_ID=dot1dBridge, dot1dStpPortPriority=dot1dStpPortPriority, dot1dStpPortPathCost=dot1dStpPortPathCost, dot1dStpPortState=dot1dStpPortState, dot1dStpPortEnable=dot1dStpPortEnable, dot1dStpPortDesignatedCost=dot1dStpPortDesignatedCost, dot1dTpBridgeGroup=dot1dTpBridgeGroup, dot1dStpForwardDelay=dot1dStpForwardDelay, dot1dBaseType=dot1dBaseType, dot1dTpFdbTable=dot1dTpFdbTable, dot1dSr=dot1dSr, dot1dStatic=dot1dStatic, dot1dGroups=dot1dGroups, dot1dStpDesignatedRoot=dot1dStpDesignatedRoot, dot1dTp=dot1dTp, dot1dStpTopChanges=dot1dStpTopChanges, dot1dTpFdbAddress=dot1dTpFdbAddress, dot1dTpFdbGroup=dot1dTpFdbGroup, dot1dStpBridgeForwardDelay=dot1dStpBridgeForwardDelay, dot1dBaseBridgeAddress=dot1dBaseBridgeAddress, dot1dNotifications=dot1dNotifications, dot1dBasePortDelayExceededDiscards=dot1dBasePortDelayExceededDiscards, topologyChange=topologyChange, dot1dBaseBridgeGroup=dot1dBaseBridgeGroup, dot1dNotificationGroup=dot1dNotificationGroup, dot1dCompliances=dot1dCompliances, dot1dBase=dot1dBase, dot1dStpBridgeHelloTime=dot1dStpBridgeHelloTime, dot1dBasePortIfIndex=dot1dBasePortIfIndex)
