/* $Cambridge: hermes/src/prayer/cmd/cmd_compose1.c,v 1.3 2008/09/16 09:59:55 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

void cmd_compose1(struct session *session)
{
    struct request *request = session->request;
    struct draft *draft = session->draft;
    struct options *options = session->options;
    struct role *role = NIL;
    char *s;

    request_decode_form(request);
    if ((s = assoc_lookup(request->form, "role")))
        role = role_find(options->role_list, s);

    /* Set up draft and role */
    draft_role_set(draft, role);
    draft_init(draft);
    draft_init_rich_headers(draft);

    /* Redirect to draft */
    session_redirect(session, request, "compose");
}
