/*
 *   Copyright 2009 - 2010 by Giulio Camuffo <giuliocamuffo@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "lyricswidget.h"

#include <KTextEdit>

#include "playercontroller.h"

LyricsWidget::LyricsWidget(QGraphicsWidget *parent)
            : TextEdit(parent)
{
    static_cast<KTextEdit *>(widget())->setReadOnly(true);
    connect(PlayerController::self(), SIGNAL(metadataChanged(QVariantMap)),
            this, SLOT(onMetadataChanged(QVariantMap)));
}

LyricsWidget::~LyricsWidget()
{

}

void LyricsWidget::onMetadataChanged(const QVariantMap &data)
{
    setText(data.value("lyrics").toString());
}

#include "lyricswidget.moc"