/*	Message_Delivered_Listener

PIRL CVS ID: Message_Delivered_Listener.java,v 1.7 2012/04/16 06:11:36 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/
package	PIRL.Messenger;

import	java.util.EventListener;

/**	A <i>Message_Delivered_Listener</i> defines the interface used
	to deliver a Message_Delivered_Event.
<p>
	@author		Bradford Castalia - UA/PIRL
	@version	1.7
	@see		Message_Delivered_Event
*/
public interface Message_Delivered_Listener
	extends EventListener
{
/**	Deliver a Message_Delivered_Event.
<p>
	@param	event	The Message_Delivered_Event containing the Message
		to be delivered and a reference to the delivering Messenger.
*/
public void Message_Delivered
	(
	Message_Delivered_Event	event
	);

/**	Get the identity of the listener.
<p>
	The Message is expected to contain at least the following parameters:
<dl>
<dt>{@link Message#ACTION_PARAMETER_NAME}
	<dd>The value should be {@link Message#IDENTITY_ACTION}.
<dt>{@link Message#NAME_PARAMETER_NAME}
	<dd>The value should be the name by which the object is known.
</dl>
	Any additional parameters that provide identification information
	may also be included.
<p>
	@return	A Message containing parameters describing the identification
		of the Message_Delivered_Listener object.
*/
public Message Listener_Identity ();

}
