# *Percona XtraBackup* 8.0.23-16.0


* **Date**

    March 22, 2021



* **Installation**

    [Installing Percona XtraBackup](https://www.percona.com/doc/percona-xtrabackup/8.0/installation.html)


Percona XtraBackup enables MySQL backups without blocking user queries, making it ideal
for companies with large data sets and mission-critical applications that cannot tolerate
long periods of downtime. Offered free as an open source solution, it drives down backup
costs while providing unique features for MySQL backups.

This release fixes the security vulnerability [CVE-2020-29488](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2020-29488)

## Improvements


* [PXB-2280](https://jira.percona.com/browse/PXB-2280): Provide SELinux and AppArmor default policies


* [PXB-1979](https://jira.percona.com/browse/PXB-1979): Enable –lock-ddl by default to prevent corruption of the backup

## Bugs Fixed


* [PXB-2274](https://jira.percona.com/browse/PXB-2274): Correct restore processing when there are DML statements running during backup stage by writing the last_checkpoint and LSN from ps.log_status instead of the redo log (Thanks to user Li Biao for reporting this issue)


* [PXB-2430](https://jira.percona.com/browse/PXB-2430): Correct build failure by removing the dependency of no-server-version-check with version-check (Thanks to user agarner for reporting this issue)


* [PXB-2415](https://jira.percona.com/browse/PXB-2415): Add build dependencies to correct Debian/Ubuntu packages in docker (Thanks to user Matt Cole for reporting this issue)


* [PXB-2429](https://jira.percona.com/browse/PXB-2429): Correct Backup failure for encrypted tablespace by skipping the encryption reset operation during the redo scan phase


* [PXB-2418](https://jira.percona.com/browse/PXB-2418): Remove PROTOBUF_LITE_LIBRARY - it is not used and is not needed


* [PXB-2395](https://jira.percona.com/browse/PXB-2395): Update versions for xbstream and xbcrypt


* [PXB-2394](https://jira.percona.com/browse/PXB-2394): Correct spellings in xbcloud help


* [PXB-2357](https://jira.percona.com/browse/PXB-2357): Correct hang in backup with redo log archive by using block number instead of checksum (checksum of redo file and archive file can be different)


* [PXB-2180](https://jira.percona.com/browse/PXB-2180): Correct incremental prepare failure with logical redo by skipping the apply of logical redos (MLOG_TABLE_DYNAMIC_META) during the incremental prepare (except the last prepare).
