/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.util.processcontrol;

import java.util.Vector;

public class Scheduler
extends Thread {
    private Vector mQueue = new Vector();
    private boolean mStop = false;

    public synchronized void stopWhenDone() {
        this.mStop = true;
        this.notifyAll();
    }

    public synchronized void addRunnable(Runnable runnable) {
        this.mQueue.addElement(runnable);
        this.notifyAll();
    }

    private synchronized Runnable getRunnable() {
        Runnable ret = null;
        while (this.mQueue.size() == 0 && !this.mStop) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.mQueue.size() > 0) {
            ret = (Runnable)this.mQueue.elementAt(0);
            this.mQueue.remove(0);
        }
        return ret;
    }

    public void run() {
        while (!this.mStop) {
            Runnable runnable = this.getRunnable();
            if (runnable == null) continue;
            this.doWork(runnable);
        }
    }

    private synchronized void doWork(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.start();
        while (thread.isAlive()) {
            try {
                this.wait(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

