/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse.translators;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.scidac.cmcs.tools.bse.BSEProperties;
import org.scidac.cmcs.tools.bse.Matrix;
import org.scidac.cmcs.tools.bse.translators.AbstractBasisSetXmlToText;

public class BasisXmlToDeMonKSInput
extends AbstractBasisSetXmlToText {
    protected String mTitle = "";

    @Override
    public String convert(String data, Vector elementList, boolean optimize) throws IOException, FormatException {
        this.enableSplitSP();
        return this.readBasisSet(data, elementList, optimize);
    }

    @Override
    protected void addHeader(StringBuffer output, Element root) throws FormatException {
        this.mTitle = root.getChildText("title", BSEProperties.mDcNs);
        String harmonicType = root.getChildText("harmonicType", BSEProperties.mBseNs);
        output.append("\n# This basis set uses " + harmonicType + " components\n");
    }

    @Override
    protected void addFooter(StringBuffer output) throws FormatException {
    }

    @Override
    protected void addElementDescription(StringBuffer output, String element, Element contractions) {
        String elementName = this.mPertable.name(this.mPertable.atomicNumber(element));
        output.append("O-" + elementName.toUpperCase());
        output.append(" (" + this.mTitle + ")\n#\n");
        List descriptionList = contractions.getChildren("description", BSEProperties.mDcNs);
        Iterator iterator = descriptionList.iterator();
        boolean first = true;
        while (iterator.hasNext()) {
            Element description = (Element)iterator.next();
            if (first) {
                output.append("# Primary Functions: ");
            } else {
                output.append("# Augmenting Functions: ");
            }
            output.append(description.getValue() + "\n");
            first = false;
        }
        Element description_1 = contractions.getChild("description", BSEProperties.mDcNs);
        String descr = description_1.getValue();
        int startindex = descr.lastIndexOf(91) + 1;
        int endindex = descr.toLowerCase().lastIndexOf(93);
        if (startindex != -1 && endindex != -1) {
            String shells = descr.substring(startindex, endindex);
            String tmp1 = shells.toLowerCase();
            tmp1 = tmp1.replace('s', ' ').replace('p', ' ').replace('d', ' ');
            String[] tmp2 = tmp1.trim().split(",");
            for (int i = 0; i < 3; ++i) {
                if (i >= tmp2.length) {
                    output.append("    0");
                    continue;
                }
                output.append("    " + tmp2[i]);
            }
            output.append("\n");
        }
    }

    @Override
    protected void readCmlMatrix(StringBuffer output, Vector matrices, String element, String shell) throws FormatException {
        for (int k = 0; k < matrices.size(); ++k) {
            Matrix matrix = (Matrix)matrices.get(k);
            int rows = matrix.getNumRows();
            int columns = matrix.getNumColumns();
            Matrix[] matricesList = this.splitMatrixNcolumnTo2column(matrix);
            try {
                for (int m = 0; m < matricesList.length; ++m) {
                    int rows2 = matricesList[m].getNumRows();
                    int columns2 = matricesList[m].getNumColumns();
                    output.append("    " + rows2 + "\n");
                    for (int i = 0; i < rows2; ++i) {
                        for (int j = 0; j < columns2; ++j) {
                            String value = this.formattedValue(matricesList[m].getValue(i, j));
                            output.append(value);
                        }
                        output.append("\n");
                    }
                }
                continue;
            }
            catch (IndexOutOfBoundsException ie) {
                throw new FormatException(ie.getMessage());
            }
        }
    }
}

