/**************************************************************************
/* This class adds all the DCRAW methods to an Operation.
/*
/* Copyright (c) 2009 by Bernhard Bablok (mail@bablokb.de)
/*
/* This program is free software; you can redistribute it and/or modify
/* it under the terms of the GNU Library General Public License as published
/* by  the Free Software Foundation; either version 2 of the License or
/* (at your option) any later version.
/*
/* This program is distributed in the hope that it will be useful, but
/* WITHOUT ANY WARRANTY; without even the implied warranty of
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/* GNU Library General Public License for more details.
/*
/* You should have received a copy of the GNU Library General Public License
/* along with this program; see the file COPYING.LIB.  If not, write to
/* the Free Software Foundation Inc., 59 Temple Place - Suite 330,
/* Boston, MA  02111-1307 USA
/**************************************************************************/

package org.im4java.core;

/**
   This class subclasses Operation and adds methods for all commandline
   options of dcraw.

   <p>This class is automatically generated by the source-code generator of
   im4java.</p>

   @version $Revision: 1.14 $
   @author  $Author: bablokb, Bruno Mascret (warnings) $
*/

public abstract class DCRAWOps extends Operation {

  /**
   * Add option -v to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @return the dcraw commandline with -v option
   */

  public DCRAWOps verbose() {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-v");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
   * Add option -c to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @return the dcraw commandline with -c option
   */

  public DCRAWOps write2stdout() {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-c");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
   * Add option -e to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @return the dcraw commandline with -e option
   */
  public DCRAWOps extractThumbnail() {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-e");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
   * Add option -z to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @return the dcraw commandline with -z option
   */
  public DCRAWOps changeTimestamp() {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-z");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////
  /**
   * Add option -i to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @return the dcraw commandline with -i option
   */
  public DCRAWOps identify() {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-i");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////
  /**
   * Add option -P to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @param pFile the File argument of -P
   * @return the dcraw commandline with -P option and the pFile argument
   */
  public DCRAWOps setDeadpixelFile(String pFile) {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-P");

    if (pFile != null) {
      buf.append(pFile.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
   * Add option -K to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @param pFile the File argument of -K
   * @return the dcraw commandline with -K option and the pFile argument
   */
  public DCRAWOps setDarkframeFile(String pFile) {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-K");

    if (pFile != null) {
      buf.append(pFile.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
   * Add option -k to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @param pDdarkness the Double argument of -k
   * @return the dcraw commandline with -k option and the pDdarkness argument
   */
  public DCRAWOps darkness(Double pDdarkness) {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-k");

    if (pDdarkness != null) {
      buf.append(pDdarkness.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
   * Add option -S to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @param pSaturation the Double argument of -S
   * @return the dcraw commandline with -S option and the pSaturation argument
   */
  public DCRAWOps saturation(Double pSaturation) {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-S");

    if (pSaturation != null) {
      buf.append(pSaturation.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
   * Add option -n to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @param pThreshold the Double argument of -n
   * @return the dcraw commandline with -n option and the pThreshold argument
   */
  public DCRAWOps noiseThreshold(Double pThreshold) {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-n");

    if (pThreshold != null) {
      buf.append(pThreshold.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
   * Add option -C to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @param pRedFactor the Double argument of -C
   * @return the dcraw commandline with -C option and the pRedFactor argument
   */
  public DCRAWOps colorFactor(Double pRedFactor) {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-C");

    if (pRedFactor != null) {
      buf.append(pRedFactor.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
   * Add option -H to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @param pMethod the Integer argument of -H
   * @return the dcraw commandline with -H option and the pMethod argument
   */
  public DCRAWOps clipMethod(Integer pMethod) {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-H");

    if (pMethod != null) {
      buf.append(pMethod.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////
  /**
   * Add option -w to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @return the dcraw commandline with -w option
   */
  public DCRAWOps useCameraWB() {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-w");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////
  /**
   * Add option -a to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @return the dcraw commandline with -a option
   */
  public DCRAWOps useAverageWB() {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-a");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////
  /**
   * Add option -A to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @param pLeft the Integer Left argument
   * @param pWidth the Integer Width argument
   * @return the dcraw commandline with -A option with pLeft and pWidth arguments
   */ 
  public DCRAWOps calcAverageWB(Integer pLeft, Integer pWidth) {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-A");

    if (pLeft != null) {
      buf.append(pLeft.toString());
    }
    buf.append("Integer:pTop");
    if (pWidth != null) {
      buf.append(pWidth.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////
  /**
   * Add option -r to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @param pMult0 the Double Mult0 argument
   * @param pMult2 the Double Mult2 argument
   * @return the dcraw commandline with -r option with pMult0 and pMult2 arguments
   */ 
  public DCRAWOps setWB(Double pMult0, Double pMult2) {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-r");

    if (pMult0 != null) {
      buf.append(pMult0.toString());
    }
    buf.append("Double:pMult1");
    if (pMult2 != null) {
      buf.append(pMult2.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////
  /**
   * Add option +M to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @return the dcraw commandline with +M option
   */ 
  public DCRAWOps useColorMatrix() {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("+M");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////
  /**
   * Add option -M to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @return the dcraw commandline with -M option
   */ 
  public DCRAWOps ignoreColorMatrix() {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-M");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////
  /**
   * Add option -o to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @param pMethod value for Integer Method argument
   * @return the dcraw commandline with -o option with pMethod argument
   */   
  public DCRAWOps setOutputColorSpace(Integer pMethod) {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-o");

    if (pMethod != null) {
      buf.append(pMethod.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
   * Add option -o to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @param pColorProfileFile value for String ColorProfileFile argument
   * @return the dcraw commandline with -o option with pColorProfileFile argument
   */ 
  public DCRAWOps setOutputColorSpace(String pColorProfileFile) {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-o");

    if (pColorProfileFile != null) {
      buf.append(pColorProfileFile.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////
  /**
   * Add option -o to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @param pColorProfileFile value for String ColorProfileFile argument
   * @return the dcraw commandline with -o option with pColorProfileFile argument
   */ 
  public DCRAWOps setCameraColorSpace(String pColorProfileFile) {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-o");

    if (pColorProfileFile != null) {
      buf.append(pColorProfileFile.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////
  /**
   * Add option -d to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @return the dcraw commandline with -d option
   */ 
  public DCRAWOps grayscale() {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-d");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
   * Add option -D to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @return the dcraw commandline with -D option
   */
  public DCRAWOps grayscaleRaw() {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-D");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
   * Add option -h to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @return the dcraw commandline with -h option
   */
  public DCRAWOps halfSize() {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-h");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
   * Add option -q to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @param pMethod the Integer representing interpolation Method 
   * @return the dcraw commandline with -q option and pMethod argument
   */
  public DCRAWOps setInterpolationMethod(Integer pMethod) {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-q");

    if (pMethod != null) {
      buf.append(pMethod.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
   * Add option -f to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @return the dcraw commandline with -f option
   */
  public DCRAWOps use4ColorRGB() {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-f");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////
  /**
   * Add option -m to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @param pPasses the Integer representing Passes
   * @return the dcraw commandline with -m option and pPasses
   */
  public DCRAWOps cleanupPasses(Integer pPasses) {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-m");

    if (pPasses != null) {
      buf.append(pPasses.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
   * Add option -W to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @return the dcraw commandline with -W option
   */
  public DCRAWOps fixedWhiteLevel() {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-W");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////
  /**
   * Add option -b to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @param pLevel the Integer representing Level argument
   * @return the dcraw commandline with -b option and pLevel argument
   */
  public DCRAWOps brightness(Double pLevel) {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-b");

    if (pLevel != null) {
      buf.append(pLevel.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////

  /**
   * Add option -4 to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @return the dcraw commandline with -4 option
   */
  public DCRAWOps depth16() {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-4");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////
  /**
   * Add option -T to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @return the dcraw commandline with -T option
   */
  public DCRAWOps createTIFF() {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-T");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////
  /**
   * Add option -t to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @param pValue The Interger representing the Value argument
   * @return the dcraw commandline with -t option and the pValue argument
   */
  public DCRAWOps flipImage(Integer pValue) {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-t");

    if (pValue != null) {
      buf.append(pValue.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////
  /**
   * Add option -j to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @return the dcraw commandline with -j option
   */
  public DCRAWOps tilt45() {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-j");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////
  /**
   * Add option -s to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @param pNumber the Integer representing the Number argument
   * @return the dcraw commandline with -s option with pNumber argument
   */
  public DCRAWOps selectImage(Integer pNumber) {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-s");

    if (pNumber != null) {
      buf.append(pNumber.toString());
    }
    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }

  //////////////////////////////////////////////////////////////////////////////
  /**
   * Add option -s to the dcraw commandline
   * (see the documentation of dcraw for details).
   * @return the dcraw commandline with -s option with pNumber argument
   */
  public DCRAWOps selectAllImages() {
    StringBuffer buf = new StringBuffer();  // local buffer for option-args
    iCmdArgs.add("-s");

    if (buf.length()>0) {
      iCmdArgs.add(buf.toString());
    }
    return this;
  }


}
