/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvTemplates_DEFINED
#define MvTemplates_DEFINED
#include <Metview.h>

// Templates have to be included only when needed for efficiency.
//

//==========================================================================
//
// Template to create an asynchronous service
// to use do:
/*

// Define a Trait

struct ServiceTrait {
	static const char* name() { return "SOME_NAME"); }
}

void TMvTransaction<ServiceTrait>::callback(MvRequest& r) // Implement the callcack
{
	.....
}

foo()
{
	new TMvTransaction<ServiceTrait>("SOME_NAME"); // Create an instance
}

*/

//! (not used; obsolete?)
template<class T> class TMvTransaction : public MvTransaction {
	TMvTransaction(MvTransaction* t)   : MvTransaction(t)  {};
	MvTransaction *cloneSelf()         { return new TMvTransaction<T>(this); }
public:
	TMvTransaction() : MvTransaction(T::name())        { }

	void callback(MvRequest&);
};

//==========================================================================
// An other way is the following

//! (used by Vis5D interface module)
template<class T> class TMvServe : public MvTransaction {
	T& object_;
	void callback(MvRequest& in) { 
		object_.serve(*this,in);

		// Specially important for Macro&MetviewUI
		// Macro ("execute" & "not_screen") calls uPlotBatch 
		// which needs to inform back that it has finished and 
		// the icon can become green
		MvRequest out("RESULT");
		sendReply(out);
	}
	MvTransaction *cloneSelf()   { return new TMvServe(this); }
	TMvServe(TMvServe<T>* other): MvTransaction(other),object_(other->object_) {}
public:
	TMvServe(T& object, const char* name) : MvTransaction(name),
		object_(object) {}
};

template<class T>
void registerTMvServe(T& object,const char* name)
{
	new TMvServe<T>(object,name);
}

//==========================================================================
//
// Template to create an asynchronous functions
//
// use as above:
/*

struct FunctionTrait {
	static const char*   name() { return "SOME_NAME"); }
	static const argdef* args() { .... }
	static const char*   info() { .. }
}

void TMvFunction<FunctionTrait>::callback(MvRequest& r) // Implement the callcack
{
	.....
}

bar()
{
	new TMvFunction<FunctionTrait>();
}

*/

#ifndef DOXYGEN_SHOULD_SKIP_THIS

// it seems that this template is not used anywhere (2008-04-10/vk)

template<class T> class TMvFunction : public MvFunction {
protected:
	char		*Info;
    TMvFunction(MvTransaction* t)   : MvFunction(t)  {};
    MvTransaction *cloneSelf() { return new TMvFunction<T>(this); }
	char *getInfo() { return Info; }
public:
    TMvFunction() : MvFunction(T::name(), T::args())
        { Info = T::info(); }
    void callback(MvRequest&);
};
#endif

//===========================================================================
//
//
#if 0

template<class T> class TMvList : public MvList {
public:
	TMvList (int protect = 0) : MvList(protect) {};
	TMvList (ListType lt, ListSortBy lsb, ListSortType lst,
		ListCase lc, int protect = 0, T *e = 0L) :
			MvList(lt,lsb,lst,lc,protect,e) {};

// Inquire Functions

	T* first()             { return (T*)MvList::first();    }
	T* last()              { return (T*)MvList::last();     }
	T* next()              { return (T*)MvList::next();     }
	T* previous()          { return (T*)MvList::previous(); }
	T* current()           { return (T*)MvList::current();  }
	T* get(int posit)      { return (T*)MvList::get(posit); }
	int positionOf(T* e)   { return MvList::positionOf(e);  }

	T* findByCode(int n)          { return (T*)MvList::findByCode(n);      }
	T* findByName(char *n)        { return (T*)MvList::findByName(n);      }
	T* findNearestCode(int n)     { return (T*)MvList::findNearestCode(n); }
	T* findNearestName(char *n)   { return (T*)MvList::findNearestName(n); }

	void insert(int n, T* e)      { MvList::insert(n,e);                }
	void insertFirst(T* e)        { MvList::insertFirst(e);             }
	void insertLast(T* e)         { MvList::insertLast(e);              }
	void append (T* e)            { MvList::append(e);                  }
	void insertBeforeCurr(T* e)   { MvList::insertBeforeCurr(e);        }
	void insertAfterCurr(T* e)    { MvList::insertAfterCurr(e);         }
	void replaceCurr(T* e)        { MvList::replaceCurr(e);             }
	T* insertByType(T* e)         { return (T*)MvList::insertByType(e); }
	int remove(T* e)              { return MvList::remove(e);           }
};

#endif

#endif
