# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class OpenGLRenderUtilities(Object):
    r"""
    OpenGLRenderUtilities - open_gl rendering utility functions
    
    Superclass: Object
    
    OpenGLRenderUtilities provides functions to help render
    primitives.
    
    See also the OpenGLQuadHelper class which may be easier to use.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOpenGLRenderUtilities, obj, update, **traits)
    
    def _get_full_screen_quad_fragment_shader_template(self):
        return self._vtk_obj.GetFullScreenQuadFragmentShaderTemplate()
    full_screen_quad_fragment_shader_template = traits.Property(_get_full_screen_quad_fragment_shader_template, desc=\
        r"""
        
        """
    )

    def _get_full_screen_quad_geometry_shader(self):
        return self._vtk_obj.GetFullScreenQuadGeometryShader()
    full_screen_quad_geometry_shader = traits.Property(_get_full_screen_quad_geometry_shader, desc=\
        r"""
        
        """
    )

    def _get_full_screen_quad_vertex_shader(self):
        return self._vtk_obj.GetFullScreenQuadVertexShader()
    full_screen_quad_vertex_shader = traits.Property(_get_full_screen_quad_vertex_shader, desc=\
        r"""
        Draw a full-screen quad:
        
        * vertex_shader and geometry_shader should be used as-is when
          building the shader_program.
        * fragment_shader_template supports the replacements
          //VTK::FSQ::Decl  and//VTK::FSQ::Impl  for declaring variables
          and the shader body, respectively.
        * The varying texCoord is available to the fragment shader for
          texture lookups into full-screen textures, ie.
          texture2D(textureName, texCoord).
        * prep_full_screen_vao initializes a new VAO for drawing a quad.
        * draw_full_screen_quad actually draws the quad.
        
        * Example usage:
        * * typedef OpenGLRenderUtilities GLUtil;
        
        * // Prep fragment shader source:
        * std::string fragShader =
          GLUtil::get_full_screen_quad_fragment_shader_template();
        * ShaderProgram::Substitute(fragShader, "//VTK::FSQ::Decl",
        * "uniform sampler2D aTexture;");
        * ShaderProgram::Substitute(fragShader, "//VTK::FSQ::Impl",
        * "gl_frag_data[0] = texture2D(aTexture, texCoord);");
        
        * // Create shader program:
        * ShaderProgram *prog = shaderCache->ready_shader_program(
        * GLUtil::get_full_screen_quad_vertex_shader().c_str(),
        * fragShader.c_str(),
        * GLUtil::get_full_screen_quad_geometry_shader().c_str());
        
        * // Initialize new VAO/vertex buffer. This is only done once:
        * Newvao;
        * GLUtil::prep_full_screen_vao(renWin, vao.Get(), prog);
        
        * // Setup shader program to sample TextureObject aTexture:
        * aTexture->Activate();
        * prog->set_uniformi("aTexture", aTexture->get_texture_unit());
        
        * // Render the full-screen quad:
        * vao->Bind();
        * GLUtil::draw_full_screen_quad();
        * vao->Release();
        * aTexture->Deactivate();
        * 
        """
    )

    def draw_full_screen_quad(self):
        """
        draw_full_screen_quad() -> None
        C++: static void draw_full_screen_quad()"""
        ret = self._vtk_obj.DrawFullScreenQuad()
        return ret
        

    def mark_debug_event(self, *args):
        """
        mark_debug_event(event:str) -> None
        C++: static void mark_debug_event(const std::string &event)
        Pass a debugging mark to the render engine to assist development
        via tools like apitrace. This calls gldebug_message_insert to
        insert the event string into the open_gl command stream.
        
        Note that this method only works when gldebug_message_insert is
        bound, which it may not be on certain platforms.
        """
        ret = self._wrap_call(self._vtk_obj.MarkDebugEvent, *args)
        return ret

    def prep_full_screen_vao(self, *args):
        """
        prep_full_screen_vao(renWin:OpenGLRenderWindow,
            vao:OpenGLVertexArrayObject, prog:ShaderProgram) -> bool
        C++: static bool prep_full_screen_vao(OpenGLRenderWindow *renWin,
            OpenGLVertexArrayObject *vao, ShaderProgram *prog)
        prep_full_screen_vao(vertBuf:OpenGLBufferObject,
            vao:OpenGLVertexArrayObject, prog:ShaderProgram) -> bool
        C++: static bool prep_full_screen_vao(OpenGLBufferObject *vertBuf,
             OpenGLVertexArrayObject *vao, ShaderProgram *prog)"""
        my_args = deref_array(args, [('vtkOpenGLRenderWindow', 'vtkOpenGLVertexArrayObject', 'vtkShaderProgram'), ('vtkOpenGLBufferObject', 'vtkOpenGLVertexArrayObject', 'vtkShaderProgram')])
        ret = self._wrap_call(self._vtk_obj.PrepFullScreenVAO, *my_args)
        return ret

    def render_quad(self, *args):
        """
        render_quad(verts:[float, ...], tcoords:[float, ...],
            program:ShaderProgram, vao:OpenGLVertexArrayObject)
            -> None
        C++: static void render_quad(float *verts, float *tcoords,
            ShaderProgram *program, OpenGLVertexArrayObject *vao)
        Helper function that draws a quad on the screen at the specified
        vertex coordinates and if tcoords are not NULL with the specified
        texture coordinates.
        """
        my_args = deref_array(args, [('tuple', 'tuple', 'vtkShaderProgram', 'vtkOpenGLVertexArrayObject')])
        ret = self._wrap_call(self._vtk_obj.RenderQuad, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OpenGLRenderUtilities, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OpenGLRenderUtilities properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit OpenGLRenderUtilities properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OpenGLRenderUtilities properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

