# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object_algorithm import DataObjectAlgorithm


class IOSSWriter(DataObjectAlgorithm):
    r"""
    IOSSWriter - writer using IOSS
    
    Superclass: DataObjectAlgorithm
    
    IOSSWriter is a writer to write datasets using IOSS library.
    Currently this writer supports writing Exodus files. This writer is a
    work in progress and currently only supports targeted use-cases. The
    writer will be iteratively cleaned up and fixed to support all types
    of incoming datasets.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkIOSSWriter, obj, update, **traits)
    
    offset_global_ids = tvtk_base.false_bool_trait(desc=\
        r"""
        Exodus wants global ids to start with 1, while VTK generally
        produces global ids starting with 0. Set this to true (default
        false), if the global ids are generated by VTK and hence start
        with 0. When writing to the output file, they will be offset by 1
        to ensure the ids are valid exodus ids.
        """
    )

    def _offset_global_ids_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOffsetGlobalIds,
                        self.offset_global_ids_)

    preserve_input_entity_groups = tvtk_base.false_bool_trait(desc=\
        r"""
        If input is untransformed IOSS dataset, then the writer can
        preserve entity group classifications, such as element blocks,
        side sets etc. The same is not true if the input has been
        transformed e.g. through a clip filter. Thus flag is used to
        indicate whether the input has valid element classifications.
        """
    )

    def _preserve_input_entity_groups_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPreserveInputEntityGroups,
                        self.preserve_input_entity_groups_)

    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        r"""
        
        """
    )

    displacement_magnitude = traits.Trait(1.0, traits.Range(0.0, 1e+299, enter_set=True, auto_set=False), desc=\
        r"""
        If input dataset has displacements pre-applied, setting the
        displacement magnitude to non-zero ensures that the point
        coordinates in the dataset are correctly transformed using the
        displacement field array, if present.
        
        Defaults to 1.0.
        """
    )

    def _displacement_magnitude_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDisplacementMagnitude,
                        self.displacement_magnitude)

    file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        Get/set the filename. When writing in a distributed environment,
        the actual filename written out may be different.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    maximum_time_steps_per_file = traits.Trait(0, traits.Range(0, 2147483647, enter_set=True, auto_set=False), desc=\
        r"""
        A debugging variable, set this to non-zero positive number to
        save at most the specified number of timesteps in a single file
        before starting a new one. The writer may start new files (aka
        restarts) automatically if it determines that the mesh has
        changed.
        
        Defaults to 0 i.e. unlimited timesteps per file.
        """
    )

    def _maximum_time_steps_per_file_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaximumTimeStepsPerFile,
                        self.maximum_time_steps_per_file)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def write(self):
        """
        write(self) -> bool
        C++: bool write()
        Writes the input dataset.
        """
        ret = self._vtk_obj.Write()
        return ret
        

    _updateable_traits_ = \
    (('offset_global_ids', 'GetOffsetGlobalIds'),
    ('preserve_input_entity_groups', 'GetPreserveInputEntityGroups'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('displacement_magnitude', 'GetDisplacementMagnitude'), ('file_name',
    'GetFileName'), ('maximum_time_steps_per_file',
    'GetMaximumTimeStepsPerFile'), ('progress_text', 'GetProgressText'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'offset_global_ids', 'preserve_input_entity_groups',
    'release_data_flag', 'displacement_magnitude', 'file_name',
    'maximum_time_steps_per_file', 'object_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(IOSSWriter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit IOSSWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['offset_global_ids', 'preserve_input_entity_groups'], [],
            ['displacement_magnitude', 'file_name', 'maximum_time_steps_per_file',
            'object_name']),
            title='Edit IOSSWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit IOSSWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

