/*
 * @(#)ChainableExceptionUTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.util.throwable.v1;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.ByteArrayOutputStream;
import net.sourceforge.groboutils.autodoc.v1.*;
import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;


/**
 * Tests the ChainableException class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/05/06 05:35:02 $
 * @since     March 17, 2002
 */
public class ChainableExceptionUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS =
        ChainableExceptionUTest.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public ChainableExceptionUTest( String name )
    {
        super( name );
        DOC.getLog().info( "ChainableExceptionUTest() constructor");
    }

    
    //-------------------------------------------------------------------------
    // setup
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }


    //-------------------------------------------------------------------------
    // Tests
    
    public void testAllTestsCoveredByInterfaceTests()
    {
        // do nothing
    }
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static class CEFactory
        implements IChainableExceptionUTestI.IChainableExceptionFactory
    {
        public IChainableException createException()
        {
            return new ChainableException();
        }
        
        public IChainableException createException( String message )
        {
            return new ChainableException( message );
        }
        
        public IChainableException createException( Throwable cause )
        {
            return new ChainableException( cause );
        }
        
        public IChainableException createException( String message,
            Throwable cause )
        {
            return new ChainableException( message, cause );
        }
        
        public IChainableException createException( Throwable cause,
            String message )
        {
            return new ChainableException( cause, message );
        }
    }
        
    
    
    public static Test suite()
    {
        InterfaceTestSuite suite = IChainableExceptionUTestI.suite();
        
        // all tests are covered by the interface tests, so don't need this
        // line.  But will add it for insurance in case tests are needed later.
        suite.addTestSuite( THIS_CLASS );
        
        DOC.getLog().info( "Adding factory to suite." );
        suite.addFactory( new CxFactory( "A" ) {
            public Object createImplObject() {
                DOC.getLog().info( "Creating factory implementation object." );
                return new CEFactory();
                //return null;
            }
        } );
        
        DOC.getLog().info( "Returning suite." );
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

