/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.runner.BenchmarkMethod;
import com.google.caliper.runner.Scenario;
import com.google.caliper.runner.ScenarioSelection;
import com.google.caliper.runner.VirtualMachine;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class FullCartesianScenarioSelection
implements ScenarioSelection {
    private final ImmutableSet<BenchmarkMethod> benchmarkMethods;
    private final ImmutableSet<VirtualMachine> vms;
    private final ImmutableSetMultimap<String, String> userParameters;
    private final ImmutableSetMultimap<String, String> vmArguments;

    public FullCartesianScenarioSelection(Collection<BenchmarkMethod> benchmarkMethods, Collection<VirtualMachine> vms, SetMultimap<String, String> userParameters, SetMultimap<String, String> vmArguments) {
        this.benchmarkMethods = ImmutableSet.copyOf(benchmarkMethods);
        this.vms = ImmutableSet.copyOf(vms);
        this.userParameters = ImmutableSetMultimap.copyOf(userParameters);
        this.vmArguments = ImmutableSetMultimap.copyOf(vmArguments);
        Preconditions.checkArgument((!benchmarkMethods.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((!vms.isEmpty() ? 1 : 0) != 0);
    }

    @Override
    public ImmutableSet<BenchmarkMethod> benchmarkMethods() {
        return this.benchmarkMethods;
    }

    @Override
    public ImmutableSet<VirtualMachine> vms() {
        return this.vms;
    }

    @Override
    public ImmutableSetMultimap<String, String> userParameters() {
        return this.userParameters;
    }

    @Override
    public ImmutableSetMultimap<String, String> vmArguments() {
        return this.vmArguments;
    }

    @Override
    public ImmutableSet<Scenario> buildScenarios() {
        ArrayList tmp = Lists.newArrayList();
        for (BenchmarkMethod benchmarkMethod : this.benchmarkMethods) {
            for (VirtualMachine vm : this.vms) {
                for (List<String> userParamsChoice : FullCartesianScenarioSelection.cartesian(this.userParameters)) {
                    ImmutableMap theseUserParams = FullCartesianScenarioSelection.zip(this.userParameters.keySet(), userParamsChoice);
                    for (List<String> vmArgsChoice : FullCartesianScenarioSelection.cartesian(this.vmArguments)) {
                        ImmutableMap theseVmArgs = FullCartesianScenarioSelection.zip(this.vmArguments.keySet(), vmArgsChoice);
                        tmp.add(new Scenario(benchmarkMethod, (Map<String, String>)theseUserParams, (Map<String, String>)theseVmArgs, vm));
                    }
                }
            }
        }
        return ImmutableSet.copyOf((Collection)tmp);
    }

    protected static <T> Set<List<T>> cartesian(SetMultimap<String, T> multimap) {
        ImmutableMap paramsAsMap = (ImmutableMap)multimap.asMap();
        return Sets.cartesianProduct((List)paramsAsMap.values().asList());
    }

    protected static <K, V> ImmutableMap<K, V> zip(Set<K> keys, Collection<V> values) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Iterator<K> keyIterator = keys.iterator();
        Iterator<V> valueIterator = values.iterator();
        while (keyIterator.hasNext() && valueIterator.hasNext()) {
            builder.put(keyIterator.next(), valueIterator.next());
        }
        if (keyIterator.hasNext() || valueIterator.hasNext()) {
            throw new AssertionError();
        }
        return builder.build();
    }

    @Override
    public String selectionType() {
        return "Full cartesian product";
    }
}

