/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.xmlrpc;

import net.noderunner.exml.Element;

/**
 * This interface contains all the element tags used in Xml-Rpc calls.
 *
 * @author Elias Ross
 * @version 1.0
 */
interface XmlRpcTags
{
	Element ELEM_METHOD_RESPONSE = new Element("methodResponse");
	Element ELEM_METHOD_CALL = new Element("methodCall");
	Element ELEM_METHOD_NAME = new Element("methodName");
	Element ELEM_FAULT = new Element("fault");
	String FAULT_CODE = "faultCode";
	String FAULT_STRING = "faultString";
	Element ELEM_PARAMS = new Element("params");
	Element ELEM_PARAM = new Element("param");
	Element ELEM_VALUE = new Element("value");
	// encoded values
	Element ELEM_NIL = new Element("nil", null, false);
	Element ELEM_STRING = new Element("string");
	Element ELEM_INT = new Element("int");
	Element ELEM_BOOLEAN = new Element("boolean");
	Element ELEM_DOUBLE = new Element("double");
	Element ELEM_DATE = new Element("dateTime.iso8601");
	Element ELEM_BASE64 = new Element("base64");
	Element ELEM_ARRAY = new Element("array");
	Element ELEM_DATA = new Element("data");
	Element ELEM_STRUCT = new Element("struct");
	Element ELEM_MEMBER = new Element("member");
	Element ELEM_NAME = new Element("name");
}

