; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=indvars -S < %s | FileCheck %s

declare i1 @cond()

define i32 @test_01(ptr %p, ptr %s) {
; CHECK-LABEL: @test_01(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START:%.*]] = load i32, ptr [[P:%.*]], align 4, !range [[RNG0:![0-9]+]]
; CHECK-NEXT:    [[END:%.*]] = load i32, ptr [[S:%.*]], align 4, !range [[RNG0]]
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ [[START]], [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[BACKEDGE:%.*]] ]
; CHECK-NEXT:    [[C1:%.*]] = icmp slt i32 [[IV]], [[END]]
; CHECK-NEXT:    br i1 [[C1]], label [[GUARDED:%.*]], label [[SIDE_EXIT:%.*]]
; CHECK:       guarded:
; CHECK-NEXT:    br i1 true, label [[BACKEDGE]], label [[SIDE_EXIT]]
; CHECK:       backedge:
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i32 [[IV]], 1
; CHECK-NEXT:    [[LOOP_COND:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 1
; CHECK:       side_exit:
; CHECK-NEXT:    ret i32 0
;
entry:
  %start = load i32, ptr %p, !range !0
  %end = load i32, ptr %s, !range !0
  br label %loop

loop:
  %iv = phi i32 [%start, %entry], [%iv.next, %backedge]
  %c1 = icmp slt i32 %iv, %end
  br i1 %c1, label %guarded, label %side_exit

guarded:
  %c2 = icmp ult i32 %iv, %end
  br i1 %c2, label %backedge, label %side_exit

backedge:
  %iv.next = add nuw nsw i32 %iv, 1
  %loop.cond = call i1 @cond()
  br i1 %loop.cond, label %loop, label %exit

exit:
  ret i32 1

side_exit:
  ret i32 0
}

define i32 @test_02(ptr %p, ptr %s) {
; CHECK-LABEL: @test_02(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START:%.*]] = load i32, ptr [[P:%.*]], align 4, !range [[RNG0]]
; CHECK-NEXT:    [[END:%.*]] = load i32, ptr [[S:%.*]], align 4, !range [[RNG0]]
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ [[START]], [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[BACKEDGE:%.*]] ]
; CHECK-NEXT:    [[C1:%.*]] = icmp ult i32 [[IV]], [[END]]
; CHECK-NEXT:    br i1 [[C1]], label [[GUARDED:%.*]], label [[SIDE_EXIT:%.*]]
; CHECK:       guarded:
; CHECK-NEXT:    br i1 true, label [[BACKEDGE]], label [[SIDE_EXIT]]
; CHECK:       backedge:
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i32 [[IV]], 1
; CHECK-NEXT:    [[LOOP_COND:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 1
; CHECK:       side_exit:
; CHECK-NEXT:    ret i32 0
;
entry:
  %start = load i32, ptr %p, !range !0
  %end = load i32, ptr %s, !range !0
  br label %loop

loop:
  %iv = phi i32 [%start, %entry], [%iv.next, %backedge]
  %c1 = icmp ult i32 %iv, %end
  br i1 %c1, label %guarded, label %side_exit

guarded:
  %c2 = icmp slt i32 %iv, %end
  br i1 %c2, label %backedge, label %side_exit

backedge:
  %iv.next = add nuw nsw i32 %iv, 1
  %loop.cond = call i1 @cond()
  br i1 %loop.cond, label %loop, label %exit

exit:
  ret i32 1

side_exit:
  ret i32 0
}

!0 = !{i32 -1000, i32 0}
