; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -O0 -mtriple=aarch64-apple-ios -global-isel -stop-after=irtranslator %s -o - | FileCheck %s

declare void @llvm.trap()

define void @unreachable() {
  ; CHECK-LABEL: name: unreachable
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   G_INTRINSIC_W_SIDE_EFFECTS intrinsic(@llvm.trap)
  unreachable
  ret void
}

declare void @foo() noreturn
define void @trap_call_noreturn() {
  ; CHECK-LABEL: name: trap_call_noreturn
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $sp, implicit $sp
  ; CHECK-NEXT:   BL @foo, csr_darwin_aarch64_aapcs, implicit-def $lr, implicit $sp
  ; CHECK-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $sp, implicit $sp
  call void @foo()
  unreachable
  ret void
}
