#ifndef _SLIDER_H
#define _SLIDER_H

#include <string>
#include "applet.h"

class Slider : public Applet {
  public:
    Slider(AppletWindowParams params, int slide_dist);

    enum SlideDir { SLIDE_W, SLIDE_E, SLIDE_N, SLIDE_S, NO_SLIDE };

    void AddAction(SlideDir dir, std::string action);

    virtual AppAction OnMousePress(int x, int y);
    virtual AppAction OnMouseRelease(int x, int y);
    virtual void OnRotate(Rotation r){}

  private:
    SlideDir slide_dir(int px, int py, int kx, int ky);

    AppAction actions[5];
    int pressx, pressy;
    int slide_dist;
};

#endif
