package latexDraw.generators.svg;

import static java.lang.Math.min;

import java.awt.geom.RectangularShape;

import latexDraw.figures.Square;
import latexDraw.parsers.svg.SVGDocument;
import latexDraw.parsers.svg.elements.SVGElement;
import latexDraw.parsers.svg.elements.SVGGElement;
import latexDraw.parsers.svg.elements.SVGRectElement;
import latexDraw.util.LaTeXDrawNamespace;

/**
 * Defines a SVG generator for a square.<br>
 *<br>
 * This file is part of LaTeXDraw.<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 11/11/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 0.1<br>
 */
public class LSquareSVGGenerator extends LRectangleSVGGenerator
{

	public LSquareSVGGenerator(Square f)
	{
		super(f);
	}
	
	
	
	public LSquareSVGGenerator(SVGGElement elt)
	{
		this(elt, true);
	}
	
	
	
	/**
	 * Creates a square from a latexdraw-SVG element.
	 * @param elt The source element.
	 * @since 2.0.0
	 */
	public LSquareSVGGenerator(SVGGElement elt, boolean withTransformation)
	{
		this(new Square(false));

		setNumber(elt);
		SVGElement elt2 = getLaTeXDrawElement(elt, null);
		Square s = (Square)getShape();
		
		if(elt==null || elt2==null || !(elt2 instanceof SVGRectElement))
			throw new IllegalArgumentException();
		
		SVGRectElement main = (SVGRectElement)elt2;
		double gap = getPositionGap()/2.;
		double rx = main.getRx();
		
		setSVGLatexdrawParameters(elt);
		setSVGParameters(main);
		
		s.getPoint(0).setLocation(main.getX()+gap, main.getY()+gap);
		s.getPoint(1).setLocation(main.getX()+main.getWidth()-gap, main.getY()+gap);
		s.getPoint(2).setLocation(main.getX()+gap, main.getY()+main.getHeight()-gap);
		s.getPoint(3).setLocation(main.getX()+main.getWidth()-gap, main.getY()+main.getHeight()-gap);
		s.setWidth(main.getWidth());
		setSVGShadowParameters(getLaTeXDrawElement(elt, LaTeXDrawNamespace.XML_TYPE_SHADOW));
		setSVGDbleBordersParameters(getLaTeXDrawElement(elt, LaTeXDrawNamespace.XML_TYPE_DBLE_BORDERS));
		
		if(rx>0)
			s.setIsRound(true);
		
		RectangularShape r = (RectangularShape)s.getShape();
		s.setFrameArc((2*rx)/(min(r.getHeight(), r.getWidth())- (s.hasDoubleBoundary() ? s.getDoubleSep()+s.getThickness() : 0)));
		
		if(withTransformation)
			applyTransformations(elt);
	}


	
	@Override
	public SVGElement toSVG(SVGDocument doc)
	{
		if(doc==null)
			return null;
		
		SVGElement root = super.toSVG(doc);
		root.setAttribute(LaTeXDrawNamespace.LATEXDRAW_NAMESPACE+':'+LaTeXDrawNamespace.XML_TYPE, LaTeXDrawNamespace.XML_TYPE_SQUARE);
		
		return root;
	}
}
