/*
 * JPGFilter.java
 */

package latexDraw.filters;

import java.io.File;

import javax.swing.filechooser.FileFilter;

import latexDraw.util.LaTeXDrawResources;


/** 
 * This class defines a filter for jpg files (*.jpg)<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 * 
 *<br>
 * 01/20/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class JPGFilter extends FileFilter
{

	@Override
	public boolean accept(File file) 
	{
		return file.getName().endsWith(LaTeXDrawResources.JPG_EXTENSION)|| file.isDirectory();
	}

	
	
	@Override
	public String getDescription() 
	{
		return "*" + LaTeXDrawResources.JPG_EXTENSION; //$NON-NLS-1$
	}
}
